/*
 * Decompiled with CFR 0.152.
 */
package boopickle;

import boopickle.Decoder;
import boopickle.StringCodec$;
import boopickle.StringCodecBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class DecoderSize
implements Decoder {
    private final ByteBuffer buf;
    private final StringCodecBase stringCodec;

    public DecoderSize(ByteBuffer buf) {
        this.buf = buf;
        this.stringCodec = StringCodec$.MODULE$;
    }

    public ByteBuffer buf() {
        return this.buf;
    }

    public StringCodecBase stringCodec() {
        return this.stringCodec;
    }

    @Override
    public byte readByte() {
        return this.buf().get();
    }

    @Override
    public char readChar() {
        int b0 = this.buf().get() & 0xFF;
        if (b0 < 128) {
            return (char)b0;
        }
        if ((b0 & 0xE0) == 192) {
            int b1 = this.buf().get() & 0x3F;
            return (char)((b0 & 0x1F) << 6 | b1);
        }
        if ((b0 & 0xF0) == 224) {
            int s0 = this.buf().get() & 0x3F;
            int s1 = this.buf().get() & 0x3F;
            return (char)((b0 & 0xF) << 12 | s0 << 6 | s1);
        }
        throw new CharacterCodingException();
    }

    @Override
    public short readShort() {
        return this.buf().getShort();
    }

    @Override
    public int readInt() {
        int b = this.buf().get() & 0xFF;
        if ((b & 0x80) != 0) {
            int sign = (b & 0x10) == 0 ? 1 : -1;
            int b0 = b & 0xF;
            int n = b >> 4;
            switch (n) {
                case 8: 
                case 9: {
                    int b1 = this.buf().get() & 0xFF;
                    return sign * (b0 << 8 | b1);
                }
                case 10: 
                case 11: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    return sign * (b0 << 16 | b1 << 8 | b2);
                }
                case 12: 
                case 13: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    int b3 = this.buf().get() & 0xFF;
                    return sign * (b0 << 24 | b1 << 16 | b2 << 8 | b3);
                }
            }
            if (14 == n && b == 224) {
                return sign * this.readRawInt();
            }
            throw new IllegalArgumentException("Unknown integer coding");
        }
        return b;
    }

    @Override
    public int readRawInt() {
        return this.buf().getInt();
    }

    @Override
    public long readLong() {
        int b = this.buf().get() & 0xFF;
        if (b != 225) {
            this.buf().position(this.buf().position() - 1);
            return this.readInt();
        }
        return this.readRawLong();
    }

    @Override
    public long readRawLong() {
        return this.buf().getLong();
    }

    @Override
    public Either<Object, Object> readIntCode() {
        int b = this.buf().get() & 0xFF;
        if ((b & 0x80) != 0) {
            int sign = (b & 0x10) == 0 ? 1 : -1;
            int b0 = b & 0xF;
            int n = b >> 4;
            switch (n) {
                case 8: 
                case 9: {
                    int b1 = this.buf().get() & 0xFF;
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 8 | b1))));
                }
                case 10: 
                case 11: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 16 | b1 << 8 | b2))));
                }
                case 12: 
                case 13: {
                    int b1 = this.buf().get() & 0xFF;
                    int b2 = this.buf().get() & 0xFF;
                    int b3 = this.buf().get() & 0xFF;
                    return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * (b0 << 24 | b1 << 16 | b2 << 8 | b3))));
                }
            }
            if (14 == n && b == 224) {
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)(sign * this.readRawInt())));
            }
            return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(b & 0xF))));
        }
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)b));
    }

    @Override
    public Either<Object, Object> readLongCode() {
        int b = this.buf().get() & 0xFF;
        if (b != 225) {
            this.buf().position(this.buf().position() - 1);
            Either<Object, Object> either = this.readIntCode();
            if (either instanceof Left) {
                byte x = BoxesRunTime.unboxToByte((Object)((Left)either).value());
                return package$.MODULE$.Left().apply((Object)BoxesRunTime.boxToByte((byte)((byte)(x & 0xF))));
            }
            if (either instanceof Right) {
                int x = BoxesRunTime.unboxToInt((Object)((Right)either).value());
                return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)x));
            }
            throw new MatchError(either);
        }
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)this.readRawLong()));
    }

    @Override
    public float readFloat() {
        return this.buf().getFloat();
    }

    @Override
    public double readDouble() {
        return this.buf().getDouble();
    }

    @Override
    public String readString() {
        int len = this.readInt();
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public String readString(int len) {
        return this.stringCodec().decodeFast(len, this.buf());
    }

    @Override
    public ByteBuffer readByteBuffer() {
        int sizeBO = this.readInt();
        if (sizeBO < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid size ").append(sizeBO).append(" for ByteBuffer").toString());
        }
        int size = sizeBO >> 1;
        ByteOrder byteOrder = (sizeBO & 1) == 1 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        ByteBuffer b = this.buf().slice().order(byteOrder);
        this.buf().position(this.buf().position() + size);
        b.limit(b.position() + size);
        return b;
    }

    @Override
    public byte[] readByteArray() {
        return this.readByteArray(this.readRawInt());
    }

    @Override
    public byte[] readByteArray(int len) {
        byte[] array = new byte[len];
        this.buf().get(array);
        return array;
    }

    @Override
    public int[] readIntArray() {
        return this.readIntArray(this.readRawInt());
    }

    @Override
    public int[] readIntArray(int len) {
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    @Override
    public float[] readFloatArray() {
        return this.readFloatArray(this.readRawInt());
    }

    @Override
    public float[] readFloatArray(int len) {
        float[] array = new float[len];
        this.buf().asFloatBuffer().get(array);
        this.buf().position(this.buf().position() + len * 4);
        return array;
    }

    @Override
    public double[] readDoubleArray() {
        int len = this.readRawInt();
        this.readRawInt();
        return this.readDoubleArray(len);
    }

    @Override
    public double[] readDoubleArray(int len) {
        double[] array = new double[len];
        this.buf().asDoubleBuffer().get(array);
        this.buf().position(this.buf().position() + len * 8);
        return array;
    }
}

