/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.handler;

import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.oas.inflector.models.RequestContext;
import io.swagger.oas.inflector.models.ResponseContext;
import io.swagger.parser.OpenAPIParser;
import io.swagger.util.Json;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ConverterController {
    public ResponseContext convertByContent(RequestContext request, JsonNode inputSpec) {
        if (inputSpec == null) {
            return new ResponseContext().status(Response.Status.BAD_REQUEST).entity((Object)"No specification supplied in either the url or request body.  Try again?");
        }
        String inputAsString = Json.pretty((Object)inputSpec);
        SwaggerParseResult output = new OpenAPIParser().readContents(inputAsString, null, null);
        if (output == null) {
            return new ResponseContext().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to process URL");
        }
        if (output.getOpenAPI() == null) {
            return new ResponseContext().status(Response.Status.BAD_REQUEST).entity((Object)output.getMessages());
        }
        MediaType outputType = this.getMediaType(request);
        return new ResponseContext().contentType(outputType).entity((Object)output.getOpenAPI());
    }

    public ResponseContext convertByUrl(RequestContext request, String url) {
        if (url == null) {
            return new ResponseContext().status(Response.Status.BAD_REQUEST).entity((Object)"No specification supplied in either the url or request body.  Try again?");
        }
        SwaggerParseResult output = new OpenAPIParser().readLocation(url, null, null);
        if (output == null) {
            return new ResponseContext().status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Failed to process URL");
        }
        if (output.getOpenAPI() == null) {
            return new ResponseContext().status(Response.Status.BAD_REQUEST).entity((Object)output.getMessages());
        }
        MediaType outputType = this.getMediaType(request);
        return new ResponseContext().contentType(outputType).entity((Object)output.getOpenAPI());
    }

    private MediaType getMediaType(RequestContext request) {
        MediaType outputType = MediaType.APPLICATION_JSON_TYPE;
        boolean isJsonOK = false;
        boolean isYamlOK = false;
        MediaType yamlMediaType = new MediaType("application", "yaml");
        for (MediaType mediaType : request.getAcceptableMediaTypes()) {
            if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                isJsonOK = true;
                continue;
            }
            if (!mediaType.equals((Object)yamlMediaType)) continue;
            isYamlOK = true;
        }
        if (isYamlOK && !isJsonOK) {
            outputType = yamlMediaType;
        }
        return outputType;
    }
}

