/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.plugin;

import config.Config;
import config.ConfigParser;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConfigLoader;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class CodeGenMojo
extends AbstractMojo {
    @Parameter(name="output", property="swagger.codegen.maven.plugin.output", defaultValue="${project.build.directory}/generated-sources/swagger")
    private File output;
    @Parameter(name="inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="templateDirectory")
    private File templateDirectory;
    @Parameter(name="modelPackage")
    private String modelPackage;
    @Parameter(name="apiPackage")
    private String apiPackage;
    @Parameter(name="invokerPackage")
    private String invokerPackage;
    @Parameter(name="language", required=true)
    private String language;
    @Parameter(name="configurationFile", required=false)
    private String configurationFile;
    @Parameter(name="configOptions")
    private Map configOptions;
    @Parameter(defaultValue="true")
    private boolean addCompileSourceRoot = true;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Swagger swagger = new SwaggerParser().read(this.inputSpec);
        CodegenConfig config = CodegenConfigLoader.forName((String)this.language);
        config.setOutputDir(this.output.getAbsolutePath());
        if (this.environmentVariables != null) {
            for (String key : this.environmentVariables.keySet()) {
                String value = this.environmentVariables.get(key);
                if (value == null) {
                    value = "";
                }
                System.setProperty(key, value);
            }
        }
        if (null != this.templateDirectory) {
            config.additionalProperties().put("templateDir", this.templateDirectory.getAbsolutePath());
        }
        if (null != this.modelPackage) {
            config.additionalProperties().put("modelPackage", this.modelPackage);
        }
        if (null != this.apiPackage) {
            config.additionalProperties().put("apiPackage", this.apiPackage);
        }
        if (null != this.invokerPackage) {
            config.additionalProperties().put("invokerPackage", this.invokerPackage);
        }
        if (this.configOptions != null) {
            for (CliOption langCliOption : config.cliOptions()) {
                if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                config.additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
            }
        }
        if (null != this.configurationFile) {
            Config genConfig = ConfigParser.read((String)this.configurationFile);
            if (null != genConfig) {
                for (CliOption langCliOption : config.cliOptions()) {
                    if (!genConfig.hasOption(langCliOption.getOpt())) continue;
                    config.additionalProperties().put(langCliOption.getOpt(), genConfig.getOption(langCliOption.getOpt()));
                }
            } else {
                throw new RuntimeException("Unable to read configuration file");
            }
        }
        ClientOptInput input = new ClientOptInput().opts(new ClientOpts()).swagger(swagger);
        input.setConfig(config);
        try {
            new DefaultGenerator().opts(input).generate();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
        if (this.addCompileSourceRoot) {
            this.project.addCompileSourceRoot(this.output.toString());
        }
    }
}

