/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Scanner;
import java.util.regex.Pattern;

public abstract class AbstractGenerator {
    public File writeToFile(String filename, String contents) throws IOException {
        System.out.println("writing file " + filename);
        File output = new File(filename);
        if (output.getParent() != null && !new File(output.getParent()).exists()) {
            File parent = new File(output.getParent());
            parent.mkdirs();
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), "UTF-8"));
        out.write(contents);
        ((Writer)out).close();
        return output;
    }

    public String readTemplate(String name) {
        try {
            Reader reader = this.getTemplateReader(name);
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can't load template " + name);
        }
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            if (is == null) {
                throw new RuntimeException("no file found");
            }
            return new InputStreamReader(is);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("can't load template " + name);
        }
    }

    private String getCPResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }
}

