/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ClientOptInput {
    protected CodegenConfig config;
    private ClientOpts opts;
    private Swagger swagger;
    private List<AuthorizationValue> auths;

    public ClientOptInput swagger(Swagger swagger) {
        this.setSwagger(swagger);
        return this;
    }

    public ClientOptInput opts(ClientOpts opts) {
        this.setOpts(opts);
        return this;
    }

    public String getAuth() {
        if (this.auths != null) {
            StringBuilder b = new StringBuilder();
            for (AuthorizationValue v : this.auths) {
                try {
                    if (b.toString().length() > 0) {
                        b.append(",");
                    }
                    b.append(URLEncoder.encode(v.getKeyName(), "UTF-8")).append(":").append(URLEncoder.encode(v.getValue(), "UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return b.toString();
        }
        return null;
    }

    public void setAuth(String urlEncodedAuthString) {
        ArrayList<AuthorizationValue> auths = new ArrayList<AuthorizationValue>();
        if (urlEncodedAuthString != null && !"".equals(urlEncodedAuthString)) {
            String[] parts;
            for (String part : parts = urlEncodedAuthString.split(",")) {
                String[] kvPair = part.split(":");
                if (kvPair.length != 2) continue;
                auths.add(new AuthorizationValue(URLDecoder.decode(kvPair[0]), URLDecoder.decode(kvPair[1]), "header"));
            }
        }
        this.auths = auths;
    }

    public List<AuthorizationValue> getAuthorizationValues() {
        return this.auths;
    }

    public CodegenConfig getConfig() {
        return this.config;
    }

    public void setConfig(CodegenConfig config) {
        this.config = config;
    }

    public ClientOpts getOpts() {
        return this.opts;
    }

    public void setOpts(ClientOpts opts) {
        this.opts = opts;
    }

    @ApiModelProperty(dataType="Object")
    public Swagger getSwagger() {
        return this.swagger;
    }

    public void setSwagger(Swagger swagger) {
        this.swagger = swagger;
    }
}

