/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.AbstractGenerator;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.Generator;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    protected CodegenConfig config;
    protected ClientOptInput opts = null;
    protected Swagger swagger = null;

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.swagger = opts.getSwagger();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(opts.getOpts().getProperties());
        return this;
    }

    @Override
    public List<File> generate() {
        if (this.swagger == null || this.config == null) {
            throw new RuntimeException("missing swagger input or config!");
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.swagger);
        }
        ArrayList<File> files = new ArrayList<File>();
        try {
            Template tmpl;
            String template;
            this.config.processOpts();
            if (this.swagger.getInfo() != null) {
                Info info = this.swagger.getInfo();
                if (info.getTitle() != null) {
                    this.config.additionalProperties().put("appName", info.getTitle());
                }
                if (info.getVersion() != null) {
                    this.config.additionalProperties().put("appVersion", info.getVersion());
                }
                if (info.getDescription() != null) {
                    this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
                }
                if (info.getContact() != null) {
                    Contact contact = info.getContact();
                    this.config.additionalProperties().put("infoUrl", contact.getUrl());
                    if (contact.getEmail() != null) {
                        this.config.additionalProperties().put("infoEmail", contact.getEmail());
                    }
                }
                if (info.getLicense() != null) {
                    License license = info.getLicense();
                    if (license.getName() != null) {
                        this.config.additionalProperties().put("licenseInfo", license.getName());
                    }
                    if (license.getUrl() != null) {
                        this.config.additionalProperties().put("licenseUrl", license.getUrl());
                    }
                }
                if (info.getVersion() != null) {
                    this.config.additionalProperties().put("version", info.getVersion());
                }
            }
            StringBuilder hostBuilder = new StringBuilder();
            String scheme = this.swagger.getSchemes() != null && this.swagger.getSchemes().size() > 0 ? ((Scheme)this.swagger.getSchemes().get(0)).toValue() : "https";
            hostBuilder.append(scheme);
            hostBuilder.append("://");
            if (this.swagger.getHost() != null) {
                hostBuilder.append(this.swagger.getHost());
            } else {
                hostBuilder.append("localhost");
            }
            if (this.swagger.getBasePath() != null) {
                hostBuilder.append(this.swagger.getBasePath());
            } else {
                hostBuilder.append("/");
            }
            String contextPath = this.swagger.getBasePath() == null ? "/" : this.swagger.getBasePath();
            String basePath = hostBuilder.toString();
            ArrayList<HashMap<String, Object>> allOperations = new ArrayList<HashMap<String, Object>>();
            ArrayList allModels = new ArrayList();
            Map definitions = this.swagger.getDefinitions();
            if (definitions != null) {
                for (Object name : definitions.keySet()) {
                    Model model = (Model)definitions.get(name);
                    HashMap<String, Model> modelMap = new HashMap<String, Model>();
                    modelMap.put((String)name, model);
                    Map<String, Object> models = this.processModels(this.config, modelMap);
                    models.putAll(this.config.additionalProperties());
                    allModels.add(((List)models.get("models")).get(0));
                    for (String templateName : this.config.modelTemplateFiles().keySet()) {
                        String suffix = this.config.modelTemplateFiles().get(templateName);
                        String filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename((String)name) + suffix;
                        String template2 = this.readTemplate(this.config.templateDir() + File.separator + templateName);
                        Template tmpl2 = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                            public Reader getTemplate(String name) {
                                return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                            }
                        }).defaultValue("").compile(template2);
                        this.writeToFile(filename, tmpl2.execute(models));
                        files.add(new File(filename));
                    }
                }
            }
            if (System.getProperty("debugModels") != null) {
                System.out.println("############ Model info ############");
                Json.prettyPrint(allModels);
            }
            Map<String, List<CodegenOperation>> paths = this.processPaths(this.swagger.getPaths());
            for (String tag : paths.keySet()) {
                List<CodegenOperation> ops = paths.get(tag);
                Map<String, Object> operation = this.processOperations(this.config, tag, ops);
                operation.put("basePath", basePath);
                operation.put("contextPath", contextPath);
                operation.put("baseName", tag);
                operation.put("modelPackage", this.config.modelPackage());
                operation.putAll(this.config.additionalProperties());
                operation.put("classname", this.config.toApiName(tag));
                operation.put("classVarName", this.config.toApiVarName(tag));
                operation.put("importPath", this.config.toApiImport(tag));
                this.processMimeTypes(this.swagger.getConsumes(), operation, "consumes");
                this.processMimeTypes(this.swagger.getProduces(), operation, "produces");
                allOperations.add(new HashMap<String, Object>(operation));
                for (int i = 0; i < allOperations.size(); ++i) {
                    Map oo = (Map)allOperations.get(i);
                    if (i >= allOperations.size() - 1) continue;
                    oo.put("hasMore", "true");
                }
                for (String templateName : this.config.apiTemplateFiles().keySet()) {
                    String filename = this.config.apiFilename(templateName, tag);
                    if (new File(filename).exists() && !this.config.shouldOverwrite(filename)) continue;
                    template = this.readTemplate(this.config.templateDir() + File.separator + templateName);
                    tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                        public Reader getTemplate(String name) {
                            return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                        }
                    }).defaultValue("").compile(template);
                    this.writeToFile(filename, tmpl.execute(operation));
                    files.add(new File(filename));
                }
            }
            if (System.getProperty("debugOperations") != null) {
                System.out.println("############ Operation info ############");
                Json.prettyPrint(allOperations);
            }
            HashMap<String, Object> bundle = new HashMap<String, Object>();
            bundle.putAll(this.config.additionalProperties());
            bundle.put("apiPackage", this.config.apiPackage());
            HashMap<String, ArrayList<HashMap<String, Object>>> apis = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            apis.put("apis", allOperations);
            if (this.swagger.getHost() != null) {
                bundle.put("host", this.swagger.getHost());
            }
            bundle.put("basePath", basePath);
            bundle.put("scheme", scheme);
            bundle.put("contextPath", contextPath);
            bundle.put("apiInfo", apis);
            bundle.put("models", allModels);
            bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
            bundle.put("modelPackage", this.config.modelPackage());
            bundle.put("authMethods", this.config.fromSecurity(this.swagger.getSecurityDefinitions()));
            if (this.swagger.getExternalDocs() != null) {
                bundle.put("externalDocs", this.swagger.getExternalDocs());
            }
            for (int i = 0; i < allModels.size() - 1; ++i) {
                HashMap cm = (HashMap)allModels.get(i);
                CodegenModel m = (CodegenModel)cm.get("model");
                m.hasMoreModels = true;
            }
            this.config.postProcessSupportingFileData(bundle);
            if (System.getProperty("debugSupportingFiles") != null) {
                System.out.println("############ Supporting file info ############");
                Json.prettyPrint(bundle);
            }
            for (SupportingFile support : this.config.supportingFiles()) {
                File of;
                String outputFolder = this.config.outputFolder();
                if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                    outputFolder = outputFolder + File.separator + support.folder;
                }
                if (!(of = new File(outputFolder)).isDirectory()) {
                    of.mkdirs();
                }
                String outputFilename = outputFolder + File.separator + support.destinationFilename;
                if (support.templateFile.endsWith("mustache")) {
                    template = this.readTemplate(this.config.templateDir() + File.separator + support.templateFile);
                    tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                        public Reader getTemplate(String name) {
                            return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.config.templateDir() + File.separator + name + ".mustache");
                        }
                    }).defaultValue("").compile(template);
                    this.writeToFile(outputFilename, tmpl.execute(bundle));
                    files.add(new File(outputFilename));
                    continue;
                }
                InputStream in = null;
                try {
                    in = new FileInputStream(this.config.templateDir() + File.separator + support.templateFile);
                }
                catch (Exception tmpl3) {
                    // empty catch block
                }
                if (in == null) {
                    in = this.getClass().getClassLoader().getResourceAsStream(this.config.templateDir() + File.separator + support.templateFile);
                }
                File outputFile = new File(outputFilename);
                FileOutputStream out = new FileOutputStream(outputFile, false);
                if (in != null && out != null) {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                } else {
                    if (in == null) {
                        System.out.println("can't open " + this.config.templateDir() + File.separator + support.templateFile + " for input");
                    }
                    if (out == null) {
                        System.out.println("can't open " + outputFile + " for output");
                    }
                }
                files.add(outputFile);
            }
            this.config.processSwagger(this.swagger);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return files;
    }

    private void processMimeTypes(List<String> mimeTypeList, Map<String, Object> operation, String source) {
        if (mimeTypeList != null && mimeTypeList.size() > 0) {
            ArrayList c = new ArrayList();
            int count = 0;
            for (String key : mimeTypeList) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < mimeTypeList.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            operation.put(source, c);
            String flagFieldName = "has" + source.substring(0, 1).toUpperCase() + source.substring(1);
            operation.put(flagFieldName, true);
        }
    }

    public Map<String, List<CodegenOperation>> processPaths(Map<String, Path> paths) {
        HashMap<String, List<CodegenOperation>> ops = new HashMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            Path path = paths.get(resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops);
            this.processOperation(resourcePath, "put", path.getPut(), ops);
            this.processOperation(resourcePath, "post", path.getPost(), ops);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops);
            this.processOperation(resourcePath, "options", path.getOptions(), ops);
        }
        return ops;
    }

    public SecuritySchemeDefinition fromSecurity(String name) {
        Map map = this.swagger.getSecurityDefinitions();
        if (map == null) {
            return null;
        }
        return (SecuritySchemeDefinition)map.get(name);
    }

    public void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations) {
        if (operation != null) {
            ArrayList<String> tags = operation.getTags();
            if (tags == null) {
                tags = new ArrayList<String>();
                tags.add("default");
            }
            for (String tag : tags) {
                CodegenOperation co = this.config.fromOperation(resourcePath, httpMethod, operation, this.swagger.getDefinitions());
                co.tags = new ArrayList<String>();
                co.tags.add(this.sanitizeTag(tag));
                this.config.addOperationToGroup(this.sanitizeTag(tag), resourcePath, operation, co, operations);
                List securities = operation.getSecurity();
                if (securities == null) continue;
                HashMap<String, SecuritySchemeDefinition> authMethods = new HashMap<String, SecuritySchemeDefinition>();
                for (Map security : securities) {
                    String securityName;
                    SecuritySchemeDefinition securityDefinition;
                    if (security.size() != 1 || (securityDefinition = this.fromSecurity(securityName = (String)security.keySet().iterator().next())) == null) continue;
                    authMethods.put(securityName, securityDefinition);
                }
                if (authMethods.isEmpty()) continue;
                co.authMethods = this.config.fromSecurity(authMethods);
            }
        }
    }

    protected String sanitizeTag(String tag) {
        String[] parts = tag.split(" ");
        StringBuilder buf = new StringBuilder();
        for (String part : parts) {
            if (!StringUtils.isNotEmpty((CharSequence)part)) continue;
            buf.append(StringUtils.capitalize((String)part));
        }
        return buf.toString().replaceAll("[^a-zA-Z ]", "");
    }

    public Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops) {
        List list;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation codegenOperation : ops) {
            String string = codegenOperation.nickname;
            if (opIds.contains(string)) {
                codegenOperation.nickname = codegenOperation.nickname + "_" + ++counter;
            }
            opIds.add(string);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (CodegenOperation codegenOperation : ops) {
            allImports.addAll(codegenOperation.imports);
        }
        ArrayList arrayList = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null) continue;
            im.put("import", mapping);
            arrayList.add(im);
        }
        operations.put("imports", arrayList);
        config.postProcessOperations(operations);
        if (objs.size() > 0 && (list = (List)objs.get("operation")) != null && list.size() > 0) {
            CodegenOperation op = (CodegenOperation)list.get(list.size() - 1);
            op.hasMore = null;
        }
        return operations;
    }

    public Map<String, Object> processModels(CodegenConfig config, Map<String, Model> definitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String key : definitions.keySet()) {
            Model mm = definitions.get(key);
            CodegenModel cm = config.fromModel(key, mm);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("importPath", config.toModelImport(key));
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        ArrayList imports = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                im.put("import", mapping);
                imports.add(im);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            im.put("import", mapping);
            imports.add(im);
        }
        objs.put("imports", imports);
        config.postProcessModels(objs);
        return objs;
    }
}

