/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.examples;

import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;

public class XmlExampleGenerator {
    public static String NEWLINE = "\n";
    public static String TAG_START = "<";
    public static String CLOSE_TAG = ">";
    public static String TAG_END = "</";
    private static String EMPTY = "";
    protected Map<String, Model> examples;
    protected SimpleDateFormat dtFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public XmlExampleGenerator(Map<String, Model> examples) {
        this.examples = examples;
        if (examples == null) {
            examples = new HashMap<String, Model>();
        }
    }

    public String toXml(Property property) {
        return this.toXml(null, property, 0, Collections.<String>emptySet());
    }

    protected String toXml(Model model, int indent, Collection<String> path) {
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            Model actualModel = this.examples.get(ref.getSimpleRef());
            if (actualModel instanceof ModelImpl) {
                return this.modelImplToXml((ModelImpl)actualModel, indent, path);
            }
        } else if (model instanceof ModelImpl) {
            return this.modelImplToXml((ModelImpl)model, indent, path);
        }
        return null;
    }

    protected String modelImplToXml(ModelImpl model, int indent, Collection<String> path) {
        Property p;
        String modelName = model.getName();
        if (path.contains(modelName)) {
            return EMPTY;
        }
        HashSet<String> selfPath = new HashSet<String>(path);
        selfPath.add(modelName);
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, Property> attributes = new LinkedHashMap<String, Property>();
        LinkedHashMap<String, Property> elements = new LinkedHashMap<String, Property>();
        String name = modelName;
        Xml xml = model.getXml();
        if (xml != null && xml.getName() != null) {
            name = xml.getName();
        }
        for (String pName : model.getProperties().keySet()) {
            p = (Property)model.getProperties().get(pName);
            if (p != null && p.getXml() != null && p.getXml().getAttribute() != null && p.getXml().getAttribute().booleanValue()) {
                attributes.put(pName, p);
                continue;
            }
            elements.put(pName, p);
        }
        sb.append(this.indent(indent)).append(TAG_START);
        sb.append(name);
        for (String pName : attributes.keySet()) {
            p = (Property)attributes.get(pName);
            sb.append(" ").append(pName).append("=").append(this.quote(this.toXml(null, p, 0, selfPath)));
        }
        sb.append(CLOSE_TAG);
        sb.append(NEWLINE);
        for (String pName : elements.keySet()) {
            String asXml = this.toXml(pName, p = (Property)elements.get(pName), indent + 1, selfPath);
            if (StringUtils.isEmpty((String)asXml)) continue;
            sb.append(asXml);
            sb.append(NEWLINE);
        }
        sb.append(this.indent(indent)).append(TAG_END).append(name).append(CLOSE_TAG);
        return sb.toString();
    }

    protected String quote(String string) {
        return "\"" + string + "\"";
    }

    protected String toXml(String name, Property property, int indent, Collection<String> path) {
        if (property == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (property instanceof ArrayProperty) {
            ArrayProperty p = (ArrayProperty)property;
            Property inner = p.getItems();
            boolean wrapped = false;
            if (property.getXml() != null && property.getXml().getWrapped().booleanValue()) {
                wrapped = true;
            }
            if (wrapped) {
                String asXml;
                String prefix = EMPTY;
                if (name != null) {
                    sb.append(this.indent(indent));
                    sb.append(this.openTag(name));
                    prefix = NEWLINE;
                }
                if (StringUtils.isNotEmpty((String)(asXml = this.toXml(name, inner, indent + 1, path)))) {
                    sb.append(prefix).append(asXml);
                }
                if (name != null) {
                    sb.append(NEWLINE);
                    sb.append(this.indent(indent));
                    sb.append(this.closeTag(name));
                }
            } else {
                sb.append(this.toXml(name, inner, indent, path));
            }
        } else if (property instanceof RefProperty) {
            RefProperty ref = (RefProperty)property;
            Model actualModel = this.examples.get(ref.getSimpleRef());
            sb.append(this.toXml(actualModel, indent, path));
        } else {
            if (name != null) {
                sb.append(this.indent(indent));
                sb.append(this.openTag(name));
            }
            sb.append(this.getExample(property));
            if (name != null) {
                sb.append(this.closeTag(name));
            }
        }
        return sb.toString();
    }

    protected String getExample(Property property) {
        if (property instanceof DateTimeProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return this.dtFormat.format(new Date());
        }
        if (property instanceof StringProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return "string";
        }
        if (property instanceof DateProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return this.dateFormat.format(new Date());
        }
        if (property instanceof IntegerProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return "0";
        }
        if (property instanceof BooleanProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return "true";
        }
        if (property instanceof LongProperty) {
            if (property.getExample() != null) {
                return property.getExample();
            }
            return "123456";
        }
        return "not implemented " + property;
    }

    protected String openTag(String name) {
        return "<" + name + ">";
    }

    protected String closeTag(String name) {
        return "</" + name + ">";
    }

    protected String indent(int indent) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

