/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.base.CaseFormat;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AkkaScalaClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String mainPackage = "io.swagger.client";
    protected String invokerPackage = this.mainPackage + ".core";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";
    protected String resourcesFolder = "src/main/resources";
    protected String configKey = "apiRequest";
    protected int defaultTimeoutInMs = 5000;
    protected String configKeyPath = this.mainPackage;
    protected boolean registerNonStandardStatusCodes = true;
    protected boolean renderJavadoc = true;
    protected boolean removeOAuthSecurities = true;
    protected boolean onlyOneSuccess = true;
    Logger LOGGER = LoggerFactory.getLogger(AkkaScalaClientCodegen.class);

    public AkkaScalaClientCodegen() {
        this.outputFolder = "generated-code/scala";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "akka-scala";
        this.apiPackage = this.mainPackage + ".api";
        this.modelPackage = this.mainPackage + ".model";
        this.reservedWords = new HashSet<String>(Arrays.asList("abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("configKey", this.configKey);
        this.additionalProperties.put("configKeyPath", this.configKeyPath);
        this.additionalProperties.put("defaultTimeout", this.defaultTimeoutInMs);
        if (this.renderJavadoc) {
            this.additionalProperties.put("javadocRenderer", new JavadocLambda());
        }
        this.additionalProperties.put("fnCapitalize", new CapitalizeLambda());
        this.additionalProperties.put("fnCamelize", new CamelizeLambda(false));
        this.additionalProperties.put("fnEnumEntry", new EnumEntryLambda());
        this.additionalProperties.put("onlyOneSuccess", this.onlyOneSuccess);
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("reference.mustache", this.resourcesFolder, "reference.conf"));
        String invokerFolder = (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("apiRequest.mustache", invokerFolder, "ApiRequest.scala"));
        this.supportingFiles.add(new SupportingFile("apiInvoker.mustache", invokerFolder, "ApiInvoker.scala"));
        this.supportingFiles.add(new SupportingFile("requests.mustache", invokerFolder, "requests.scala"));
        this.supportingFiles.add(new SupportingFile("apiSettings.mustache", invokerFolder, "ApiSettings.scala"));
        String apiFolder = (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator);
        this.supportingFiles.add(new SupportingFile("enumsSerializers.mustache", apiFolder, "EnumsSerializers.scala"));
        this.importMapping.remove("Seq");
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.typeMapping = new HashMap();
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("number", "Double");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Int", "Long", "Float", "Object", "List", "Seq", "Map"));
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "Map");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "akka-scala";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala client library base on Akka/Spray.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "`" + name + "`";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        if (this.registerNonStandardStatusCodes) {
            try {
                Map opsMap = (Map)objs.get("operations");
                HashSet<Integer> unknownCodes = new HashSet<Integer>();
                for (CodegenOperation operation : (ArrayList)opsMap.get("operation")) {
                    for (CodegenResponse response : operation.responses) {
                        if ("default".equals(response.code)) continue;
                        try {
                            int code = Integer.parseInt(response.code);
                            if (code < 600) continue;
                            unknownCodes.add(code);
                        }
                        catch (NumberFormatException e) {
                            this.LOGGER.error("Status code is not an integer : response.code", (Throwable)e);
                        }
                    }
                }
                if (!unknownCodes.isEmpty()) {
                    this.additionalProperties.put("unknownStatusCodes", unknownCodes);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Unable to find operations List", (Throwable)e);
            }
        }
        return super.postProcessOperations(objs);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecuritySchemeDefinition> schemes) {
        CodegenSecurity security;
        List<CodegenSecurity> codegenSecurities = super.fromSecurity(schemes);
        if (!this.removeOAuthSecurities) {
            return codegenSecurities;
        }
        Iterator<CodegenSecurity> it = codegenSecurities.iterator();
        while (it.hasNext()) {
            security = it.next();
            if (!security.isOAuth.booleanValue()) continue;
            it.remove();
        }
        it = codegenSecurities.iterator();
        while (it.hasNext()) {
            security = it.next();
            security.hasMore = it.hasNext();
        }
        if (codegenSecurities.isEmpty()) {
            return null;
        }
        return codegenSecurities;
    }

    @Override
    public String toOperationId(String operationId) {
        return super.toOperationId(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, operationId));
    }

    private String formatIdentifier(String name, boolean capitalized) {
        String identifier = AkkaScalaClientCodegen.camelize(name, true);
        if (capitalized) {
            identifier = StringUtils.capitalize((String)identifier);
        }
        if (identifier.matches("[a-zA-Z_$][\\w_$]+") && !this.reservedWords.contains(identifier)) {
            return identifier;
        }
        return this.escapeReservedWord(identifier);
    }

    @Override
    public String toParamName(String name) {
        return this.formatIdentifier(name, false);
    }

    @Override
    public String toVarName(String name) {
        return this.formatIdentifier(name, false);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.formatIdentifier(property.baseName, true);
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map") + "[String, " + inner + "]";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array") + "[" + inner + "]";
        }
        return null;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (!p.getRequired()) {
            return "None";
        }
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            return "null";
        }
        if (p instanceof FloatProperty) {
            return "null";
        }
        if (p instanceof IntegerProperty) {
            return "null";
        }
        if (p instanceof LongProperty) {
            return "null";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "Map[String, " + inner + "].empty ";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return "Seq[" + inner + "].empty ";
        }
        return "null";
    }

    private class EnumEntryLambda
    extends CustomLambda {
        private EnumEntryLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return AkkaScalaClientCodegen.this.formatIdentifier(fragment, true);
        }
    }

    private static class CamelizeLambda
    extends CustomLambda {
        private final boolean capitalizeFirst;

        public CamelizeLambda(boolean capitalizeFirst) {
            this.capitalizeFirst = capitalizeFirst;
        }

        @Override
        public String formatFragment(String fragment) {
            return DefaultCodegen.camelize(fragment, !this.capitalizeFirst);
        }
    }

    private static class CapitalizeLambda
    extends CustomLambda {
        private CapitalizeLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            return StringUtils.capitalize((String)fragment);
        }
    }

    private static class JavadocLambda
    extends CustomLambda {
        private JavadocLambda() {
        }

        @Override
        public String formatFragment(String fragment) {
            String[] lines = fragment.split("\\r?\\n");
            StringBuilder sb = new StringBuilder();
            sb.append("  /**\n");
            for (String line : lines) {
                sb.append("   * ").append(line).append("\n");
            }
            sb.append("   */\n");
            return sb.toString();
        }
    }

    private static abstract class CustomLambda
    implements Mustache.Lambda {
        private CustomLambda() {
        }

        public void execute(Template.Fragment frag, Writer out) throws IOException {
            StringWriter tempWriter = new StringWriter();
            frag.execute((Writer)tempWriter);
            out.write(this.formatFragment(tempWriter.toString()));
        }

        public abstract String formatFragment(String var1);
    }
}

