/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ObjcClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected Set<String> foundationClasses = new HashSet<String>();
    protected String sourceFolder = "client";
    protected String classPrefix = "SWG";
    protected String projectName = "swaggerClient";

    public ObjcClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "objc";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".m");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".m");
        this.templateDir = "objc";
        this.modelPackage = "";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("bool", "BOOL", "int", "NSString", "NSObject", "NSArray", "NSNumber", "NSDate", "NSDictionary", "NSMutableArray", "NSMutableDictionary"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("NSNumber", "NSString", "NSObject", "NSDate", "bool", "BOOL"));
        this.reservedWords = new HashSet<String>(Arrays.asList("auto", "else", "long", "switch", "break", "enum", "register", "typedef", "case", "extern", "return", "union", "char", "float", "short", "unsigned", "const", "for", "signed", "void", "continue", "goto", "sizeof", "volatile", "default", "if", "id", "static", "while", "do", "int", "struct", "_Packed", "double", "protocol", "interface", "implementation", "NSObject", "NSInteger", "NSNumber", "CGFloat", "property", "nonatomic", "retain", "strong", "weak", "unsafe_unretained", "readwrite", "readonly"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("Date", "NSDate");
        this.typeMapping.put("DateTime", "NSDate");
        this.typeMapping.put("boolean", "BOOL");
        this.typeMapping.put("string", "NSString");
        this.typeMapping.put("integer", "NSNumber");
        this.typeMapping.put("int", "NSNumber");
        this.typeMapping.put("float", "NSNumber");
        this.typeMapping.put("long", "NSNumber");
        this.typeMapping.put("double", "NSNumber");
        this.typeMapping.put("array", "NSArray");
        this.typeMapping.put("map", "NSDictionary");
        this.typeMapping.put("number", "NSNumber");
        this.typeMapping.put("List", "NSArray");
        this.typeMapping.put("object", "NSObject");
        this.importMapping = new HashMap();
        this.foundationClasses = new HashSet<String>(Arrays.asList("NSNumber", "NSObject", "NSString", "NSDate", "NSDictionary"));
        this.instantiationTypes.put("array", "NSMutableArray");
        this.instantiationTypes.put("map", "NSMutableDictionary");
        this.cliOptions.add(new CliOption("classPrefix", "prefix for generated classes"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
        this.cliOptions.add(new CliOption("projectName", "name of the Xcode project in generated Podfile"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "objc";
    }

    @Override
    public String getHelp() {
        return "Generates an Objective-C client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("classPrefix")) {
            this.setClassPrefix((String)this.additionalProperties.get("classPrefix"));
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.additionalProperties.put("projectName", this.projectName);
        }
        this.supportingFiles.add(new SupportingFile("SWGObject.h", this.sourceFolder, "SWGObject.h"));
        this.supportingFiles.add(new SupportingFile("SWGObject.m", this.sourceFolder, "SWGObject.m"));
        this.supportingFiles.add(new SupportingFile("SWGQueryParamCollection.h", this.sourceFolder, "SWGQueryParamCollection.h"));
        this.supportingFiles.add(new SupportingFile("SWGQueryParamCollection.m", this.sourceFolder, "SWGQueryParamCollection.m"));
        this.supportingFiles.add(new SupportingFile("SWGApiClient.h", this.sourceFolder, "SWGApiClient.h"));
        this.supportingFiles.add(new SupportingFile("SWGApiClient.m", this.sourceFolder, "SWGApiClient.m"));
        this.supportingFiles.add(new SupportingFile("SWGFile.h", this.sourceFolder, "SWGFile.h"));
        this.supportingFiles.add(new SupportingFile("SWGFile.m", this.sourceFolder, "SWGFile.m"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601.m", this.sourceFolder, "JSONValueTransformer+ISO8601.m"));
        this.supportingFiles.add(new SupportingFile("JSONValueTransformer+ISO8601.h", this.sourceFolder, "JSONValueTransformer+ISO8601.h"));
        this.supportingFiles.add(new SupportingFile("SWGConfiguration-body.mustache", this.sourceFolder, "SWGConfiguration.m"));
        this.supportingFiles.add(new SupportingFile("SWGConfiguration-header.mustache", this.sourceFolder, "SWGConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("Podfile.mustache", "", "Podfile"));
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return (String)this.instantiationTypes.get("map");
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return (String)this.instantiationTypes.get("array");
        }
        return null;
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (this.languageSpecificPrimitives.contains(name) && !this.foundationClasses.contains(name)) {
            return name;
        }
        return name + "*";
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type) && !this.foundationClasses.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            String innerType = this.getSwaggerType(inner);
            if (this.languageSpecificPrimitives.contains(innerType)) {
                return this.getSwaggerType(p) + "*";
            }
            String innerTypeDeclaration = this.getTypeDeclaration(inner);
            if (innerTypeDeclaration.endsWith("*")) {
                innerTypeDeclaration = innerTypeDeclaration.substring(0, innerTypeDeclaration.length() - 1);
            }
            return this.getSwaggerType(p) + "<" + innerTypeDeclaration + ">*";
        }
        String swaggerType = this.getSwaggerType(p);
        if (this.languageSpecificPrimitives.contains(swaggerType) && this.foundationClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        return swaggerType + "*";
    }

    @Override
    public String toModelName(String type) {
        type = type.replaceAll("[^0-9a-zA-Z_]", "_");
        if (this.typeMapping.keySet().contains(type) || this.foundationClasses.contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return ObjcClientCodegen.camelize(type);
        }
        return this.classPrefix + ObjcClientCodegen.camelize(type);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        super.setNonArrayMapProperty(property, type);
        property.setter = "NSDictionary".equals(type) ? "initWithDictionary" : "initWithValues";
    }

    @Override
    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    @Override
    public String toDefaultValue(Property p) {
        return null;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder;
    }

    @Override
    public String toApiName(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiFilename(String name) {
        return this.classPrefix + ObjcClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("[^a-zA-Z0-9_]", "_")).matches("^[A-Z_]$")) {
            return name;
        }
        if (this.reservedWords.contains(name = ObjcClientCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return ObjcClientCodegen.camelize(operationId, true);
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setClassPrefix(String classPrefix) {
        this.classPrefix = classPrefix;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
}

