/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;

public class PythonClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String module = "SwaggerPetstore";
    protected String invokerPackage;
    protected String eggPackage = this.module + "-python";

    public PythonClientCodegen() {
        this.invokerPackage = this.eggPackage + File.separatorChar + this.module;
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.modelTemplateFiles.put("model.mustache", ".py");
        this.apiTemplateFiles.put("api.mustache", ".py");
        this.templateDir = "python";
        this.apiPackage = this.invokerPackage + File.separatorChar + "apis";
        this.modelPackage = this.invokerPackage + File.separatorChar + "models";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("float");
        this.languageSpecificPrimitives.add("list");
        this.languageSpecificPrimitives.add("bool");
        this.languageSpecificPrimitives.add("str");
        this.languageSpecificPrimitives.add("datetime");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("double", "float");
        this.typeMapping.put("array", "list");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "str");
        this.typeMapping.put("date", "datetime");
        this.reservedWords = new HashSet<String>(Arrays.asList("and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try"));
        this.additionalProperties.put("module", this.module);
        this.supportingFiles.add(new SupportingFile("README.mustache", this.eggPackage, "README.md"));
        this.supportingFiles.add(new SupportingFile("setup.mustache", this.eggPackage, "setup.py"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", this.invokerPackage, "api_client.py"));
        this.supportingFiles.add(new SupportingFile("rest.mustache", this.invokerPackage, "rest.py"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.invokerPackage, "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package.mustache", this.invokerPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model.mustache", this.modelPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api.mustache", this.apiPackage, "__init__.py"));
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "python";
    }

    @Override
    public String getHelp() {
        return "Generates a Python client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "(String, " + this.getTypeDeclaration(inner) + ")";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(swaggerType);
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.reservedWords.contains(name = PythonClientCodegen.underscore(PythonClientCodegen.dropDots(name))) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return PythonClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return PythonClientCodegen.underscore(PythonClientCodegen.dropDots(name));
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return PythonClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return PythonClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "default_api";
        }
        return PythonClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return PythonClientCodegen.underscore(operationId);
    }
}

