/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;

public class RubyClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String gemName = "swagger_client";
    protected String moduleName = this.generateModuleName();
    protected String libFolder = "lib";

    public RubyClientCodegen() {
        this.modelPackage = this.gemName + "/models";
        this.apiPackage = this.gemName + "/api";
        this.outputFolder = "generated-code" + File.separatorChar + "ruby";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "ruby";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.reservedWords = new HashSet<String>(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.additionalProperties.put("gemName", this.gemName);
        this.additionalProperties.put("moduleName", this.moduleName);
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Array", "array");
        this.typeMapping.put("String", "string");
        this.typeMapping.put("List", "array");
        this.typeMapping.put("map", "map");
        String baseFolder = "lib" + File.separatorChar + this.gemName;
        String swaggerFolder = baseFolder + File.separatorChar + "swagger";
        String modelFolder = baseFolder + File.separatorChar + "models";
        this.supportingFiles.add(new SupportingFile("swagger_client.gemspec.mustache", "", this.gemName + ".gemspec"));
        this.supportingFiles.add(new SupportingFile("swagger_client.mustache", "lib", this.gemName + ".rb"));
        this.supportingFiles.add(new SupportingFile("monkey.mustache", baseFolder, "monkey.rb"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", baseFolder, "swagger.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separatorChar + "request.mustache", swaggerFolder, "request.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separatorChar + "response.mustache", swaggerFolder, "response.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separatorChar + "version.mustache", swaggerFolder, "version.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separatorChar + "configuration.mustache", swaggerFolder, "configuration.rb"));
        this.supportingFiles.add(new SupportingFile("base_object.mustache", modelFolder, "base_object.rb"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ruby";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby client library.";
    }

    public String generateModuleName() {
        return RubyClientCodegen.camelize(this.gemName.replaceAll("[^\\w]+", "_"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + "lib" + File.separatorChar + this.gemName + File.separatorChar + "api";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + "lib" + File.separatorChar + this.gemName + File.separatorChar + "models";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.reservedWords.contains(name = RubyClientCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return RubyClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return RubyClientCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RubyClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return RubyClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return RubyClientCodegen.underscore(operationId);
    }

    @Override
    public String toModelImport(String name) {
        return this.modelPackage() + "/" + this.toModelFilename(name);
    }

    @Override
    public String toApiImport(String name) {
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }
}

