/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class JavaInflectorServerCodegen
extends JavaClientCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.handler";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-inflector-server";
    protected String artifactVersion = "1.0.0";
    protected String title = "Swagger Inflector";

    public JavaInflectorServerCodegen() {
        this.sourceFolder = "src/main/java";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.templateDir = "JavaInflector";
        this.apiPackage = System.getProperty("swagger.codegen.inflector.apipackage", "io.swagger.handler");
        this.modelPackage = System.getProperty("swagger.codegen.inflector.modelpackage", "io.swagger.model");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("title", this.title);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "inflector";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Inflector Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("inflector.mustache", "", "inflector.yaml"));
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end);
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end);
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end);
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public void processSwagger(Swagger swagger) {
        super.processSwagger(swagger);
        try {
            File file = new File(this.outputFolder + "/src/main/swagger/swagger.json");
            file.getParentFile().mkdirs();
            FileWriter swaggerFile = new FileWriter(file);
            swaggerFile.write(Json.pretty((Object)swagger));
            swaggerFile.flush();
            swaggerFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        name = name.replaceAll("[^a-zA-Z0-9]+", "_");
        return JavaInflectorServerCodegen.camelize(name) + "Controller";
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return super.shouldOverwrite(filename);
    }
}

