/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class RubyClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String gemName = null;
    protected String moduleName = null;
    protected String gemVersion = "1.0.0";
    protected String libFolder = "lib";

    public RubyClientCodegen() {
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separator + "ruby";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.templateDir = "ruby";
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.reservedWords = new HashSet<String>(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("DateTime");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("boolean", "BOOLEAN");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Hash");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("file", "File");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("gemName", "gem name (convention: underscore_case), default: swagger_client"));
        this.cliOptions.add(new CliOption("moduleName", "top module name (convention: CamelCase, usually corresponding to gem name), default: SwaggerClient"));
        this.cliOptions.add(new CliOption("gemVersion", "gem version, default: 1.0.0"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("gemName")) {
            this.setGemName((String)this.additionalProperties.get("gemName"));
        }
        if (this.additionalProperties.containsKey("moduleName")) {
            this.setModuleName((String)this.additionalProperties.get("moduleName"));
        }
        if (this.gemName == null && this.moduleName == null) {
            this.setGemName("swagger_client");
            this.setModuleName(this.generateModuleName(this.gemName));
        } else if (this.gemName == null) {
            this.setGemName(this.generateGemName(this.moduleName));
        } else if (this.moduleName == null) {
            this.setModuleName(this.generateModuleName(this.gemName));
        }
        this.additionalProperties.put("gemName", this.gemName);
        this.additionalProperties.put("moduleName", this.moduleName);
        if (this.additionalProperties.containsKey("gemVersion")) {
            this.setGemVersion((String)this.additionalProperties.get("gemVersion"));
        } else {
            this.additionalProperties.put("gemVersion", this.gemVersion);
        }
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("swagger_client.gemspec.mustache", "", this.gemName + ".gemspec"));
        this.supportingFiles.add(new SupportingFile("swagger_client.mustache", this.libFolder, this.gemName + ".rb"));
        String baseFolder = this.libFolder + File.separator + this.gemName;
        this.supportingFiles.add(new SupportingFile("swagger.mustache", baseFolder, "swagger.rb"));
        String swaggerFolder = baseFolder + File.separator + "swagger";
        this.supportingFiles.add(new SupportingFile("swagger" + File.separator + "request.mustache", swaggerFolder, "request.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separator + "response.mustache", swaggerFolder, "response.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separator + "api_error.mustache", swaggerFolder, "api_error.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separator + "version.mustache", swaggerFolder, "version.rb"));
        this.supportingFiles.add(new SupportingFile("swagger" + File.separator + "configuration.mustache", swaggerFolder, "configuration.rb"));
        String modelFolder = baseFolder + File.separator + this.modelPackage.replace("/", File.separator);
        this.supportingFiles.add(new SupportingFile("base_object.mustache", modelFolder, "base_object.rb"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ruby";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby client library.";
    }

    public String generateModuleName(String gemName) {
        return RubyClientCodegen.camelize(gemName.replaceAll("[^\\w]+", "_"));
    }

    public String generateGemName(String moduleName) {
        return RubyClientCodegen.underscore(moduleName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.reservedWords.contains(name = RubyClientCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return RubyClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.reservedWords.contains(name)) {
            throw new RuntimeException(name + " (reserved word) cannot be used as a model name");
        }
        return RubyClientCodegen.underscore(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RubyClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return RubyClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return RubyClientCodegen.underscore(operationId);
    }

    @Override
    public String toModelImport(String name) {
        return this.gemName + "/" + this.modelPackage() + "/" + this.toModelFilename(name);
    }

    @Override
    public String toApiImport(String name) {
        return this.gemName + "/" + this.apiPackage() + "/" + this.toApiFilename(name);
    }

    public void setGemName(String gemName) {
        this.gemName = gemName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setGemVersion(String gemVersion) {
        this.gemVersion = gemVersion;
    }
}

