/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenModelFactory;
import io.swagger.codegen.CodegenModelType;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.examples.ExampleGenerator;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCodegen {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCodegen.class);
    protected String outputFolder = "";
    protected Set<String> defaultIncludes = new HashSet<String>();
    protected Map<String, String> typeMapping = new HashMap<String, String>();
    protected Map<String, String> instantiationTypes = new HashMap<String, String>();
    protected Set<String> reservedWords = new HashSet<String>();
    protected Set<String> languageSpecificPrimitives = new HashSet<String>();
    protected Map<String, String> importMapping = new HashMap<String, String>();
    protected String modelPackage = "";
    protected String apiPackage = "";
    protected String fileSuffix;
    protected Map<String, String> apiTemplateFiles = new HashMap<String, String>();
    protected Map<String, String> modelTemplateFiles = new HashMap<String, String>();
    protected String templateDir;
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected List<SupportingFile> supportingFiles = new ArrayList<SupportingFile>();
    protected List<CliOption> cliOptions = new ArrayList<CliOption>();
    protected boolean skipOverwrite;
    protected boolean supportsInheritance = false;
    protected Map<String, String> supportedLibraries = new LinkedHashMap<String, String>();
    protected String library = null;
    protected Boolean sortParamsByRequiredFlag = true;

    public List<CliOption> cliOptions() {
        return this.cliOptions;
    }

    public void processOpts() {
        if (this.additionalProperties.containsKey("templateDir")) {
            this.setTemplateDir((String)this.additionalProperties.get("templateDir"));
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.setModelPackage((String)this.additionalProperties.get("modelPackage"));
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.setApiPackage((String)this.additionalProperties.get("apiPackage"));
        }
        if (this.additionalProperties.containsKey("sortParamsByRequiredFlag")) {
            this.setSortParamsByRequiredFlag(Boolean.valueOf(this.additionalProperties.get("sortParamsByRequiredFlag").toString()));
        }
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        return objs;
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        return objs;
    }

    public void preprocessSwagger(Swagger swagger) {
    }

    public void processSwagger(Swagger swagger) {
    }

    public String escapeText(String input) {
        if (input != null) {
            input = input.trim();
            String output = input.replaceAll("\n", "\\\\n");
            output = output.replace("\"", "\\\"");
            return output;
        }
        return input;
    }

    public Set<String> defaultIncludes() {
        return this.defaultIncludes;
    }

    public Map<String, String> typeMapping() {
        return this.typeMapping;
    }

    public Map<String, String> instantiationTypes() {
        return this.instantiationTypes;
    }

    public Set<String> reservedWords() {
        return this.reservedWords;
    }

    public Set<String> languageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public Map<String, String> importMapping() {
        return this.importMapping;
    }

    public String modelPackage() {
        return this.modelPackage;
    }

    public String apiPackage() {
        return this.apiPackage;
    }

    public String fileSuffix() {
        return this.fileSuffix;
    }

    public String templateDir() {
        return this.templateDir;
    }

    public Map<String, String> apiTemplateFiles() {
        return this.apiTemplateFiles;
    }

    public Map<String, String> modelTemplateFiles() {
        return this.modelTemplateFiles;
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public List<SupportingFile> supportingFiles() {
        return this.supportingFiles;
    }

    public String outputFolder() {
        return this.outputFolder;
    }

    public void setOutputDir(String dir) {
        this.outputFolder = dir;
    }

    public String getOutputDir() {
        return this.outputFolder();
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
    }

    public void setSortParamsByRequiredFlag(Boolean sortParamsByRequiredFlag) {
        this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
    }

    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    public String toApiVarName(String name) {
        return this.snakeCase(name);
    }

    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return operationId;
    }

    public String toVarName(String name) {
        if (this.reservedWords.contains(name)) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toParamName(String name) {
        if (this.reservedWords.contains(name = this.removeNonNameElementToCamelCase(name))) {
            return this.escapeReservedWord(name);
        }
        return name;
    }

    public String toEnumName(CodegenProperty property) {
        return StringUtils.capitalize((String)property.name) + "Enum";
    }

    public String escapeReservedWord(String name) {
        throw new RuntimeException("reserved word " + name + " not allowed");
    }

    public String toModelImport(String name) {
        if ("".equals(this.modelPackage())) {
            return name;
        }
        return this.modelPackage() + "." + name;
    }

    public String toApiImport(String name) {
        return this.apiPackage() + "." + name;
    }

    public DefaultCodegen() {
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "int", "long", "short", "char", "float", "String", "boolean", "Boolean", "Double", "Void", "Integer", "Long", "Float"));
        this.typeMapping = new HashMap<String, String>();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("number", "BigDecimal");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("ByteArray", "byte[]");
        this.instantiationTypes = new HashMap<String, String>();
        this.reservedWords = new HashSet<String>();
        this.importMapping = new HashMap<String, String>();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("List", "java.util.*");
        this.importMapping.put("Set", "java.util.*");
        this.importMapping.put("DateTime", "org.joda.time.*");
        this.importMapping.put("LocalDateTime", "org.joda.time.*");
        this.importMapping.put("LocalDate", "org.joda.time.*");
        this.importMapping.put("LocalTime", "org.joda.time.*");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters. Default: true"));
    }

    public String generateExamplePath(String path, Operation operation) {
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (operation.getParameters() != null) {
            int count = 0;
            for (Parameter param : operation.getParameters()) {
                if (!(param instanceof QueryParameter)) continue;
                StringBuilder paramPart = new StringBuilder();
                QueryParameter qp = (QueryParameter)param;
                if (count == 0) {
                    paramPart.append("?");
                } else {
                    paramPart.append(",");
                }
                ++count;
                if (!param.getRequired()) {
                    paramPart.append("[");
                }
                paramPart.append(param.getName()).append("=");
                paramPart.append("{");
                if (qp.getCollectionFormat() != null) {
                    paramPart.append(param.getName() + "1");
                    if ("csv".equals(qp.getCollectionFormat())) {
                        paramPart.append(",");
                    } else if ("pipes".equals(qp.getCollectionFormat())) {
                        paramPart.append("|");
                    } else if ("tsv".equals(qp.getCollectionFormat())) {
                        paramPart.append("\t");
                    } else if ("multi".equals(qp.getCollectionFormat())) {
                        paramPart.append("&").append(param.getName()).append("=");
                        paramPart.append(param.getName() + "2");
                    }
                } else {
                    paramPart.append(param.getName());
                }
                paramPart.append("}");
                if (!param.getRequired()) {
                    paramPart.append("]");
                }
                sb.append(paramPart.toString());
            }
        }
        return sb.toString();
    }

    public String toInstantiationType(Property p) {
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            Property additionalProperties2 = ap.getAdditionalProperties();
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n" + "\tIn Property: " + p);
            }
            String inner = this.getSwaggerType(additionalProperties2);
            return this.instantiationTypes.get("map") + "<String, " + inner + ">";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            return this.instantiationTypes.get("array") + "<" + inner + ">";
        }
        return null;
    }

    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "null";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof FloatProperty) {
            FloatProperty dp = (FloatProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty dp = (IntegerProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "null";
        }
        return "null";
    }

    public String getSwaggerType(Property p) {
        String datatype = null;
        if (p instanceof StringProperty) {
            datatype = "string";
        } else if (p instanceof ByteArrayProperty) {
            datatype = "ByteArray";
        } else if (p instanceof BooleanProperty) {
            datatype = "boolean";
        } else if (p instanceof DateProperty) {
            datatype = "date";
        } else if (p instanceof DateTimeProperty) {
            datatype = "DateTime";
        } else if (p instanceof DoubleProperty) {
            datatype = "double";
        } else if (p instanceof FloatProperty) {
            datatype = "float";
        } else if (p instanceof IntegerProperty) {
            datatype = "integer";
        } else if (p instanceof LongProperty) {
            datatype = "long";
        } else if (p instanceof MapProperty) {
            datatype = "map";
        } else if (p instanceof DecimalProperty) {
            datatype = "number";
        } else if (p instanceof RefProperty) {
            try {
                RefProperty r = (RefProperty)p;
                datatype = r.get$ref();
                if (datatype.indexOf("#/definitions/") == 0) {
                    datatype = datatype.substring("#/definitions/".length());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error obtaining the datatype from RefProperty:" + p + ". Datatype default to Object");
                datatype = "Object";
                e.printStackTrace();
            }
        } else if (p != null) {
            datatype = p.getType();
        }
        return datatype;
    }

    public String snakeCase(String name) {
        return name.length() > 0 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : "";
    }

    public String initialCaps(String name) {
        return StringUtils.capitalize((String)name);
    }

    public String getTypeDeclaration(String name) {
        return name;
    }

    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            return this.typeMapping.get(swaggerType);
        }
        return swaggerType;
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return this.initialCaps(name) + "Api";
    }

    public String toModelName(String name) {
        return this.initialCaps(name);
    }

    public CodegenModel fromModel(String name, Model model) {
        return this.fromModel(name, model, null);
    }

    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance(CodegenModelType.MODEL);
        m.name = this.reservedWords.contains(name) ? this.escapeReservedWord(name) : name;
        m.description = this.escapeText(model.getDescription());
        m.unescapedDescription = model.getDescription();
        m.classname = this.toModelName(name);
        m.classVarName = this.toVarName(name);
        m.modelJson = Json.pretty((Object)model);
        m.externalDocs = model.getExternalDocs();
        if (model instanceof ArrayModel) {
            ArrayModel am = (ArrayModel)model;
            ArrayProperty arrayProperty = new ArrayProperty(am.getItems());
            m.hasEnums = false;
            this.addParentContainer(m, name, (Property)arrayProperty);
        } else if (!(model instanceof RefModel)) {
            if (model instanceof ComposedModel) {
                Model child;
                ComposedModel composed = (ComposedModel)model;
                HashMap<String, Property> properties = new HashMap<String, Property>();
                ArrayList<String> required = new ArrayList<String>();
                RefModel parent = (RefModel)composed.getParent();
                if (parent != null) {
                    Model parentModel;
                    String parentRef;
                    m.parent = parentRef = this.toModelName(parent.getSimpleRef());
                    this.addImport(m, parentRef);
                    if (!this.supportsInheritance && allDefinitions != null && (parentModel = allDefinitions.get(parentRef)) instanceof ModelImpl) {
                        ModelImpl _parent = (ModelImpl)parentModel;
                        if (_parent.getProperties() != null) {
                            properties.putAll(_parent.getProperties());
                        }
                        if (_parent.getRequired() != null) {
                            required.addAll(_parent.getRequired());
                        }
                    }
                }
                if (allDefinitions != null && composed.getInterfaces() != null) {
                    for (RefModel _interface : composed.getInterfaces()) {
                        String interfaceRef = this.toModelName(_interface.getSimpleRef());
                        Model interfaceModel = allDefinitions.get(interfaceRef);
                        if (!(interfaceModel instanceof ModelImpl)) continue;
                        ModelImpl _interfaceModel = (ModelImpl)interfaceModel;
                        if (_interfaceModel.getProperties() != null) {
                            properties.putAll(_interfaceModel.getProperties());
                        }
                        if (_interfaceModel.getRequired() == null) continue;
                        required.addAll(_interfaceModel.getRequired());
                    }
                }
                if ((child = composed.getChild()) != null && child instanceof RefModel && allDefinitions != null) {
                    String childRef = ((RefModel)child).getSimpleRef();
                    child = allDefinitions.get(childRef);
                }
                if (child != null && child instanceof ModelImpl) {
                    ModelImpl _child = (ModelImpl)child;
                    if (_child.getProperties() != null) {
                        properties.putAll(_child.getProperties());
                    }
                    if (_child.getRequired() != null) {
                        required.addAll(_child.getRequired());
                    }
                }
                this.addVars(m, properties, required);
            } else {
                ModelImpl impl = (ModelImpl)model;
                if (impl.getAdditionalProperties() != null) {
                    MapProperty mapProperty = new MapProperty(impl.getAdditionalProperties());
                    this.addParentContainer(m, name, (Property)mapProperty);
                }
                this.addVars(m, impl.getProperties(), impl.getRequired());
            }
        }
        return m;
    }

    public String getterAndSetterCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return DefaultCodegen.camelize(this.toVarName(name));
    }

    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty cp;
        ArrayProperty ap;
        HashMap<String, Object> allowableValues;
        List _enum;
        StringProperty sp;
        if (p == null) {
            LOGGER.error("unexpected missing property for name " + name);
            return null;
        }
        CodegenProperty property = (CodegenProperty)CodegenModelFactory.newInstance(CodegenModelType.PROPERTY);
        property.name = this.toVarName(name);
        property.baseName = name;
        property.description = this.escapeText(p.getDescription());
        property.unescapedDescription = p.getDescription();
        property.getter = "get" + this.getterAndSetterCapitalize(name);
        property.setter = "set" + this.getterAndSetterCapitalize(name);
        property.example = p.getExample();
        property.defaultValue = this.toDefaultValue(p);
        property.jsonSchema = Json.pretty((Object)p);
        property.isReadOnly = p.getReadOnly();
        String type = this.getSwaggerType(p);
        if (p instanceof AbstractNumericProperty) {
            AbstractNumericProperty np = (AbstractNumericProperty)p;
            property.minimum = np.getMinimum();
            property.maximum = np.getMaximum();
            property.exclusiveMinimum = np.getExclusiveMinimum();
            property.exclusiveMaximum = np.getExclusiveMaximum();
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (np.getMinimum() != null) {
                allowableValues2.put("min", np.getMinimum());
            }
            if (np.getMaximum() != null) {
                allowableValues2.put("max", np.getMaximum());
            }
            if (allowableValues2.size() > 0) {
                property.allowableValues = allowableValues2;
            }
        }
        if (p instanceof StringProperty) {
            sp = (StringProperty)p;
            property.maxLength = sp.getMaxLength();
            property.minLength = sp.getMinLength();
            property.pattern = sp.getPattern();
            if (sp.getEnum() != null) {
                property._enum = _enum = sp.getEnum();
                property.isEnum = true;
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                property.allowableValues = allowableValues;
            }
        }
        if (p instanceof IntegerProperty && (sp = (IntegerProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((Integer)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        if (p instanceof LongProperty && (sp = (LongProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((Long)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        if (p instanceof DoubleProperty && (sp = (DoubleProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((Double)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        if (p instanceof FloatProperty && (sp = (FloatProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((Float)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        if (p instanceof DateProperty && (sp = (DateProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((String)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        if (p instanceof DateTimeProperty && (sp = (DateTimeProperty)p).getEnum() != null) {
            _enum = sp.getEnum();
            property._enum = new ArrayList<String>();
            for (Object i : _enum) {
                property._enum.add(((String)i).toString());
            }
            property.isEnum = true;
            allowableValues = new HashMap();
            allowableValues.put("values", _enum);
            property.allowableValues = allowableValues;
        }
        property.datatype = this.getTypeDeclaration(p);
        property.datatypeWithEnum = property.isEnum ? this.toEnumName(property) : property.datatype;
        property.baseType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            property.isContainer = true;
            property.containerType = "array";
            ap = (ArrayProperty)p;
            cp = this.fromProperty(property.name, ap.getItems());
            if (cp == null) {
                LOGGER.warn("skipping invalid property " + Json.pretty((Object)p));
            } else {
                property.baseType = this.getSwaggerType(p);
                if (!this.languageSpecificPrimitives.contains(cp.baseType)) {
                    property.complexType = cp.baseType;
                } else {
                    property.isPrimitiveType = true;
                }
                property.items = cp;
                if (property.items.isEnum) {
                    property.datatypeWithEnum = property.datatypeWithEnum.replace(property.items.baseType, property.items.datatypeWithEnum);
                    if (property.defaultValue != null) {
                        property.defaultValue = property.defaultValue.replace(property.items.baseType, property.items.datatypeWithEnum);
                    }
                }
            }
        } else if (p instanceof MapProperty) {
            property.isContainer = true;
            property.containerType = "map";
            ap = (MapProperty)p;
            cp = this.fromProperty("inner", ap.getAdditionalProperties());
            property.baseType = this.getSwaggerType(p);
            if (!this.languageSpecificPrimitives.contains(cp.baseType)) {
                property.complexType = cp.baseType;
            } else {
                property.isPrimitiveType = true;
            }
        } else {
            this.setNonArrayMapProperty(property, type);
        }
        return property;
    }

    protected void setNonArrayMapProperty(CodegenProperty property, String type) {
        property.isNotContainer = true;
        if (this.languageSpecificPrimitives().contains(type)) {
            property.isPrimitiveType = true;
        } else {
            property.complexType = property.baseType;
        }
    }

    private Response findMethodResponse(Map<String, Response> responses) {
        String code = null;
        for (String responseCode : responses.keySet()) {
            if (!responseCode.startsWith("2") && !responseCode.equals("default") || code != null && code.compareTo(responseCode) <= 0) continue;
            code = responseCode;
        }
        if (code == null) {
            return null;
        }
        return responses.get(code);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions) {
        return this.fromOperation(path, httpMethod, operation, definitions, null);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation op = (CodegenOperation)CodegenModelFactory.newInstance(CodegenModelType.OPERATION);
        HashSet<String> imports = new HashSet<String>();
        op.vendorExtensions = operation.getVendorExtensions();
        String operationId = operation.getOperationId();
        if (operationId == null) {
            String tmpPath = path;
            tmpPath = tmpPath.replaceAll("\\{", "");
            tmpPath = tmpPath.replaceAll("\\}", "");
            String[] parts = (tmpPath + "/" + httpMethod).split("/");
            StringBuilder builder = new StringBuilder();
            if ("/".equals(tmpPath)) {
                builder.append("root");
            }
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.length() <= 0) continue;
                part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : this.initialCaps(part);
                builder.append(part);
            }
            operationId = builder.toString();
            LOGGER.info("generated operationId " + operationId + "\tfor Path: " + httpMethod + " " + path);
        }
        operationId = this.removeNonNameElementToCamelCase(operationId);
        op.path = path;
        op.operationId = this.toOperationId(operationId);
        op.summary = this.escapeText(operation.getSummary());
        op.notes = this.escapeText(operation.getDescription());
        op.tags = operation.getTags();
        op.hasConsumes = false;
        op.hasProduces = false;
        List consumes = new ArrayList();
        if (operation.getConsumes() != null) {
            if (operation.getConsumes().size() > 0) {
                consumes = operation.getConsumes();
            }
        } else if (swagger != null && swagger.getConsumes() != null && swagger.getConsumes().size() > 0) {
            consumes = swagger.getConsumes();
            LOGGER.debug("No consumes defined in operation. Using global consumes (" + swagger.getConsumes() + ") for " + op.operationId);
        }
        if (consumes != null && consumes.size() > 0) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            int count = 0;
            for (String key : consumes) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < consumes.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            op.consumes = c;
            op.hasConsumes = true;
        }
        List produces = new ArrayList();
        if (operation.getProduces() != null) {
            if (operation.getProduces().size() > 0) {
                produces = operation.getProduces();
            }
        } else if (swagger != null && swagger.getProduces() != null && swagger.getProduces().size() > 0) {
            produces = swagger.getProduces();
            LOGGER.debug("No produces defined in operation. Using global produces (" + swagger.getProduces() + ") for " + op.operationId);
        }
        if (produces != null && produces.size() > 0) {
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            int count = 0;
            for (String key : produces) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < produces.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            op.produces = c;
            op.hasProduces = true;
        }
        if (operation.getResponses() != null && !operation.getResponses().isEmpty()) {
            Response methodResponse = this.findMethodResponse(operation.getResponses());
            for (Map.Entry entry : operation.getResponses().entrySet()) {
                Response response = (Response)entry.getValue();
                CodegenResponse r = this.fromResponse((String)entry.getKey(), response);
                r.hasMore = true;
                if (r.baseType != null && !this.defaultIncludes.contains(r.baseType) && !this.languageSpecificPrimitives.contains(r.baseType)) {
                    imports.add(r.baseType);
                }
                r.isDefault = response == methodResponse;
                op.responses.add(r);
                if (!r.isBinary.booleanValue() || !r.isDefault.booleanValue()) continue;
                op.isResponseBinary = Boolean.TRUE;
            }
            op.responses.get((int)(op.responses.size() - 1)).hasMore = false;
            if (methodResponse != null) {
                if (methodResponse.getSchema() != null) {
                    CodegenProperty cm = this.fromProperty("response", methodResponse.getSchema());
                    Property responseProperty = methodResponse.getSchema();
                    if (responseProperty instanceof ArrayProperty) {
                        ArrayProperty ap = (ArrayProperty)responseProperty;
                        CodegenProperty innerProperty = this.fromProperty("response", ap.getItems());
                        op.returnBaseType = innerProperty.baseType;
                    } else {
                        op.returnBaseType = cm.complexType != null ? cm.complexType : cm.baseType;
                    }
                    op.examples = new ExampleGenerator(definitions).generate(methodResponse.getExamples(), operation.getProduces(), responseProperty);
                    op.defaultResponse = this.toDefaultValue(responseProperty);
                    op.returnType = cm.datatype;
                    if (cm.isContainer != null) {
                        op.returnContainer = cm.containerType;
                        if ("map".equals(cm.containerType)) {
                            op.isMapContainer = Boolean.TRUE;
                        } else if ("list".equalsIgnoreCase(cm.containerType)) {
                            op.isListContainer = Boolean.TRUE;
                        } else if ("array".equalsIgnoreCase(cm.containerType)) {
                            op.isListContainer = Boolean.TRUE;
                        }
                    } else {
                        op.returnSimpleType = true;
                    }
                    if (this.languageSpecificPrimitives().contains(op.returnBaseType) || op.returnBaseType == null) {
                        op.returnTypeIsPrimitive = true;
                    }
                }
                this.addHeaders(methodResponse, op.responseHeaders);
            }
        }
        List parameters = operation.getParameters();
        CodegenParameter bodyParam = null;
        ArrayList<CodegenParameter> allParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> bodyParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> pathParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> queryParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> headerParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> cookieParams = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> formParams = new ArrayList<CodegenParameter>();
        if (parameters != null) {
            for (Parameter param : parameters) {
                CodegenParameter p = this.fromParameter(param, imports);
                allParams.add(p);
                if (param instanceof QueryParameter) {
                    p.isQueryParam = new Boolean(true);
                    queryParams.add(p.copy());
                    continue;
                }
                if (param instanceof PathParameter) {
                    p.required = true;
                    p.isPathParam = new Boolean(true);
                    pathParams.add(p.copy());
                    continue;
                }
                if (param instanceof HeaderParameter) {
                    p.isHeaderParam = new Boolean(true);
                    headerParams.add(p.copy());
                    continue;
                }
                if (param instanceof CookieParameter) {
                    p.isCookieParam = new Boolean(true);
                    cookieParams.add(p.copy());
                    continue;
                }
                if (param instanceof BodyParameter) {
                    p.isBodyParam = new Boolean(true);
                    bodyParam = p;
                    bodyParams.add(p.copy());
                    continue;
                }
                if (!(param instanceof FormParameter)) continue;
                if ("file".equalsIgnoreCase(((FormParameter)param).getType())) {
                    p.isFile = true;
                } else {
                    p.notFile = true;
                }
                p.isFormParam = new Boolean(true);
                formParams.add(p.copy());
            }
        }
        for (String i : imports) {
            if (!this.needToImport(i)) continue;
            op.imports.add(i);
        }
        op.bodyParam = bodyParam;
        op.httpMethod = httpMethod.toUpperCase();
        if (this.sortParamsByRequiredFlag.booleanValue()) {
            Collections.sort(allParams, new Comparator<CodegenParameter>(){

                @Override
                public int compare(CodegenParameter one, CodegenParameter another) {
                    boolean anotherRequired;
                    boolean oneRequired = one.required == null ? false : one.required;
                    boolean bl = anotherRequired = another.required == null ? false : another.required;
                    if (oneRequired == anotherRequired) {
                        return 0;
                    }
                    if (oneRequired) {
                        return -1;
                    }
                    return 1;
                }
            });
        }
        op.allParams = this.addHasMore(allParams);
        op.bodyParams = this.addHasMore(bodyParams);
        op.pathParams = this.addHasMore(pathParams);
        op.queryParams = this.addHasMore(queryParams);
        op.headerParams = this.addHasMore(headerParams);
        op.formParams = this.addHasMore(formParams);
        op.nickname = op.operationId;
        if (op.allParams.size() > 0) {
            op.hasParams = true;
        }
        op.externalDocs = operation.getExternalDocs();
        return op;
    }

    public CodegenResponse fromResponse(String responseCode, Response response) {
        CodegenResponse r = (CodegenResponse)CodegenModelFactory.newInstance(CodegenModelType.RESPONSE);
        r.code = "default".equals(responseCode) ? "0" : responseCode;
        r.message = this.escapeText(response.getDescription());
        r.schema = response.getSchema();
        r.examples = this.toExamples(response.getExamples());
        r.jsonSchema = Json.pretty((Object)response);
        this.addHeaders(response, r.headers);
        if (r.schema != null) {
            Property responseProperty = response.getSchema();
            responseProperty.setRequired(true);
            CodegenProperty cm = this.fromProperty("response", responseProperty);
            if (responseProperty instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)responseProperty;
                CodegenProperty innerProperty = this.fromProperty("response", ap.getItems());
                r.baseType = innerProperty.baseType;
            } else {
                r.baseType = cm.complexType != null ? cm.complexType : cm.baseType;
            }
            r.dataType = cm.datatype;
            r.isBinary = cm.datatype.equals("byte[]");
            if (cm.isContainer != null) {
                r.simpleType = false;
                r.containerType = cm.containerType;
                r.isMapContainer = "map".equals(cm.containerType);
                r.isListContainer = "list".equals(cm.containerType);
            } else {
                r.simpleType = true;
            }
            r.primitiveType = r.baseType == null || this.languageSpecificPrimitives().contains(r.baseType);
        }
        if (r.baseType == null) {
            r.isMapContainer = false;
            r.isListContainer = false;
            r.primitiveType = true;
            r.simpleType = true;
        }
        return r;
    }

    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter p = (CodegenParameter)CodegenModelFactory.newInstance(CodegenModelType.PARAMETER);
        p.baseName = param.getName();
        p.description = this.escapeText(param.getDescription());
        if (param.getRequired()) {
            p.required = param.getRequired();
        }
        p.jsonSchema = Json.pretty((Object)param);
        if (System.getProperty("debugParser") != null) {
            LOGGER.info("working on Parameter " + param);
        }
        if (param instanceof QueryParameter) {
            p.defaultValue = ((QueryParameter)param).getDefaultValue();
        } else if (param instanceof HeaderParameter) {
            p.defaultValue = ((HeaderParameter)param).getDefaultValue();
        } else if (param instanceof FormParameter) {
            p.defaultValue = ((FormParameter)param).getDefaultValue();
        }
        p.vendorExtensions = param.getVendorExtensions();
        if (param instanceof SerializableParameter) {
            Property inner;
            SerializableParameter qp = (SerializableParameter)param;
            ArrayProperty property = null;
            String collectionFormat = null;
            String type = qp.getType();
            if (null == type) {
                LOGGER.warn("Type is NULL for Serializable Parameter: " + param);
            }
            if ("array".equals(type)) {
                inner = qp.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for array parameter \"" + qp.getName() + "\", using String");
                    inner = new StringProperty().description("//TODO automatically added by swagger-codegen");
                }
                property = new ArrayProperty(inner);
                collectionFormat = qp.getCollectionFormat();
                CodegenProperty pr = this.fromProperty("inner", inner);
                p.baseType = pr.datatype;
                p.isContainer = true;
                imports.add(pr.baseType);
            } else if ("object".equals(type)) {
                inner = qp.getItems();
                if (inner == null) {
                    LOGGER.warn("warning!  No inner type supplied for map parameter \"" + qp.getName() + "\", using String");
                    inner = new StringProperty().description("//TODO automatically added by swagger-codegen");
                }
                property = new MapProperty(inner);
                collectionFormat = qp.getCollectionFormat();
                CodegenProperty pr = this.fromProperty("inner", inner);
                p.baseType = pr.datatype;
                imports.add(pr.baseType);
            } else {
                HashMap<PropertyBuilder.PropertyId, List> args = new HashMap<PropertyBuilder.PropertyId, List>();
                String format = qp.getFormat();
                args.put(PropertyBuilder.PropertyId.ENUM, qp.getEnum());
                property = PropertyBuilder.build((String)type, (String)format, args);
            }
            if (property == null) {
                LOGGER.warn("warning!  Property type \"" + type + "\" not found for parameter \"" + param.getName() + "\", using String");
                property = new StringProperty().description("//TODO automatically added by swagger-codegen.  Type was " + type + " but not supported");
            }
            property.setRequired(param.getRequired());
            CodegenProperty model = this.fromProperty(qp.getName(), (Property)property);
            p.dataType = model.datatype;
            p.isEnum = model.isEnum;
            p._enum = model._enum;
            p.allowableValues = model.allowableValues;
            p.collectionFormat = collectionFormat;
            if (collectionFormat != null && collectionFormat.equals("multi")) {
                p.isCollectionFormatMulti = true;
            }
            p.paramName = this.toParamName(qp.getName());
            if (model.complexType != null) {
                imports.add(model.complexType);
            }
        } else {
            BodyParameter bp;
            Model model;
            if (!(param instanceof BodyParameter)) {
                LOGGER.error("Cannot use Parameter " + param + " as Body Parameter");
            }
            if ((model = (bp = (BodyParameter)param).getSchema()) instanceof ModelImpl) {
                ModelImpl impl = (ModelImpl)model;
                CodegenModel cm = this.fromModel(bp.getName(), (Model)impl);
                if (cm.emptyVars != null && !cm.emptyVars.booleanValue()) {
                    p.dataType = this.getTypeDeclaration(cm.classname);
                    imports.add(p.dataType);
                } else {
                    Property prop = PropertyBuilder.build((String)impl.getType(), (String)impl.getFormat(), null);
                    prop.setRequired(bp.getRequired());
                    CodegenProperty cp = this.fromProperty("property", prop);
                    if (cp != null) {
                        p.dataType = cp.datatype;
                        p.isBinary = p.dataType.equals("byte[]") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                }
            } else if (model instanceof ArrayModel) {
                ArrayModel impl = (ArrayModel)model;
                CodegenModel cm = this.fromModel(bp.getName(), (Model)impl);
                ArrayProperty ap = new ArrayProperty().items(impl.getItems());
                ap.setRequired(param.getRequired());
                CodegenProperty cp = this.fromProperty("inner", (Property)ap);
                if (cp.complexType != null) {
                    imports.add(cp.complexType);
                }
                imports.add(cp.baseType);
                p.dataType = cp.datatype;
                p.isContainer = true;
            } else {
                Model sub = bp.getSchema();
                if (sub instanceof RefModel) {
                    String name = ((RefModel)sub).getSimpleRef();
                    if (this.typeMapping.containsKey(name)) {
                        name = this.typeMapping.get(name);
                    } else {
                        if (this.defaultIncludes.contains(name = this.toModelName(name))) {
                            imports.add(name);
                        }
                        imports.add(name);
                        name = this.getTypeDeclaration(name);
                    }
                    p.dataType = name;
                }
            }
            p.paramName = this.toParamName(bp.getName());
        }
        return p;
    }

    public List<CodegenSecurity> fromSecurity(Map<String, SecuritySchemeDefinition> schemes) {
        if (schemes == null) {
            return null;
        }
        ArrayList<CodegenSecurity> secs = new ArrayList<CodegenSecurity>(schemes.size());
        Iterator<Map.Entry<String, SecuritySchemeDefinition>> it = schemes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SecuritySchemeDefinition> entry = it.next();
            SecuritySchemeDefinition schemeDefinition = entry.getValue();
            CodegenSecurity sec = (CodegenSecurity)CodegenModelFactory.newInstance(CodegenModelType.SECURITY);
            sec.name = entry.getKey();
            sec.type = schemeDefinition.getType();
            if (schemeDefinition instanceof ApiKeyAuthDefinition) {
                ApiKeyAuthDefinition apiKeyDefinition = (ApiKeyAuthDefinition)schemeDefinition;
                sec.isBasic = sec.isOAuth = Boolean.valueOf(false);
                sec.isApiKey = true;
                sec.keyParamName = apiKeyDefinition.getName();
                sec.isKeyInHeader = apiKeyDefinition.getIn() == In.HEADER;
                sec.isKeyInQuery = sec.isKeyInHeader == false;
            } else if (schemeDefinition instanceof BasicAuthDefinition) {
                sec.isApiKey = sec.isOAuth = Boolean.valueOf(false);
                sec.isKeyInQuery = sec.isOAuth;
                sec.isKeyInHeader = sec.isOAuth;
                sec.isBasic = true;
            } else {
                OAuth2Definition oauth2Definition = (OAuth2Definition)schemeDefinition;
                sec.isApiKey = sec.isBasic = Boolean.valueOf(false);
                sec.isKeyInQuery = sec.isBasic;
                sec.isKeyInHeader = sec.isBasic;
                sec.isOAuth = true;
                sec.flow = oauth2Definition.getFlow();
                sec.authorizationUrl = oauth2Definition.getAuthorizationUrl();
                sec.tokenUrl = oauth2Definition.getTokenUrl();
                if (oauth2Definition.getScopes() != null) {
                    ArrayList<Map<String, Object>> scopes = new ArrayList<Map<String, Object>>();
                    int count = 0;
                    int numScopes = oauth2Definition.getScopes().size();
                    for (Map.Entry scopeEntry : oauth2Definition.getScopes().entrySet()) {
                        HashMap<String, Object> scope = new HashMap<String, Object>();
                        scope.put("scope", scopeEntry.getKey());
                        scope.put("description", scopeEntry.getValue());
                        if (++count < numScopes) {
                            scope.put("hasMore", "true");
                        } else {
                            scope.put("hasMore", null);
                        }
                        scopes.add(scope);
                    }
                    sec.scopes = scopes;
                }
            }
            sec.hasMore = it.hasNext();
            secs.add(sec);
        }
        return secs;
    }

    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type) && type.indexOf(".") < 0;
    }

    protected List<Map<String, Object>> toExamples(Map<String, Object> examples) {
        if (examples == null) {
            return null;
        }
        ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>(examples.size());
        for (Map.Entry<String, Object> entry : examples.entrySet()) {
            HashMap<String, Object> kv = new HashMap<String, Object>();
            kv.put("contentType", entry.getKey());
            kv.put("example", entry.getValue());
            output.add(kv);
        }
        return output;
    }

    private void addHeaders(Response response, List<CodegenProperty> target) {
        if (response.getHeaders() != null) {
            for (Map.Entry headers : response.getHeaders().entrySet()) {
                target.add(this.fromProperty((String)headers.getKey(), (Property)headers.getValue()));
            }
        }
    }

    private List<CodegenParameter> addHasMore(List<CodegenParameter> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size(); ++i) {
                if (i > 0) {
                    objs.get((int)i).secondaryParam = new Boolean(true);
                }
                if (i >= objs.size() - 1) continue;
                objs.get((int)i).hasMore = new Boolean(true);
            }
        }
        return objs;
    }

    private Map<String, Object> addHasMore(Map<String, Object> objs) {
        if (objs != null) {
            for (int i = 0; i < objs.size() - 1; ++i) {
                if (i > 0) {
                    objs.put("secondaryParam", new Boolean(true));
                }
                if (i >= objs.size() - 1) continue;
                objs.put("hasMore", true);
            }
        }
        return objs;
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        List<CodegenOperation> opList = operations.get(tag);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(tag, opList);
        }
        opList.add(co);
        co.baseName = tag;
    }

    private void addParentContainer(CodegenModel m, String name, Property property) {
        String mappedType;
        CodegenProperty tmp = this.fromProperty(name, property);
        this.addImport(m, tmp.complexType);
        m.parent = this.toInstantiationType(property);
        String containerType = tmp.containerType;
        String instantiationType = this.instantiationTypes.get(containerType);
        if (instantiationType != null) {
            this.addImport(m, instantiationType);
        }
        if ((mappedType = this.typeMapping.get(containerType)) != null) {
            this.addImport(m, mappedType);
        }
    }

    public static String underscore(String word) {
        String firstPattern = "([A-Z]+)([A-Z][a-z])";
        String secondPattern = "([a-z\\d])([A-Z])";
        String replacementPattern = "$1_$2";
        word = word.replaceAll("\\.", "/");
        word = word.replaceAll("\\$", "__");
        word = word.replaceAll(firstPattern, replacementPattern);
        word = word.replaceAll(secondPattern, replacementPattern);
        word = word.replace('-', '_');
        word = word.toLowerCase();
        return word;
    }

    private void addImport(CodegenModel m, String type) {
        if (type != null && this.needToImport(type)) {
            m.imports.add(type);
        }
    }

    private void addVars(CodegenModel m, Map<String, Property> properties, Collection<String> required) {
        if (properties != null && properties.size() > 0) {
            m.hasVars = true;
            m.hasEnums = false;
            int totalCount = properties.size();
            HashSet<String> mandatory = required == null ? Collections.emptySet() : new HashSet<String>(required);
            int count = 0;
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                String key = entry.getKey();
                Property prop = entry.getValue();
                if (prop == null) {
                    LOGGER.warn("null property for " + key);
                    continue;
                }
                CodegenProperty cp = this.fromProperty(key, prop);
                Boolean bl = cp.required = mandatory.contains(key) ? Boolean.valueOf(true) : null;
                if (cp.isEnum) {
                    m.hasEnums = true;
                }
                if (++count != totalCount) {
                    cp.hasMore = true;
                }
                if (cp.isContainer != null) {
                    this.addImport(m, this.typeMapping.get("array"));
                }
                this.addImport(m, cp.baseType);
                this.addImport(m, cp.complexType);
                m.vars.add(cp);
            }
        } else {
            m.emptyVars = true;
            m.hasVars = false;
            m.hasEnums = false;
        }
    }

    public String removeNonNameElementToCamelCase(String name) {
        String nonNameElementPattern = "[-_:;#]";
        if ((name = StringUtils.join((Collection)Lists.transform((List)Lists.newArrayList((Object[])name.split(nonNameElementPattern)), (Function)new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                return StringUtils.capitalize((String)input);
            }
        }), (String)"")).length() > 0) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static String camelize(String word) {
        return DefaultCodegen.camelize(word, false);
    }

    public static String camelize(String word, boolean lowercaseFirstLetter) {
        Pattern p = Pattern.compile("\\/(.?)");
        Matcher m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("." + m.group(1));
            m = p.matcher(word);
        }
        String[] parts = word.split("\\.");
        StringBuilder f = new StringBuilder();
        for (String z : parts) {
            if (z.length() <= 0) continue;
            f.append(Character.toUpperCase(z.charAt(0))).append(z.substring(1));
        }
        word = f.toString();
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("" + Character.toUpperCase(m.group(1).charAt(0)) + m.group(1).substring(1));
            m = p.matcher(word);
        }
        p = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        m = p.matcher(word);
        if (m.find()) {
            String rep = m.group(1) + m.group(2).toUpperCase() + m.group(3);
            rep = rep.replaceAll("\\$", "\\\\\\$");
            word = m.replaceAll(rep);
        }
        p = Pattern.compile("(__)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst("\\$" + m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        p = Pattern.compile("(_)(.)");
        m = p.matcher(word);
        while (m.find()) {
            word = m.replaceFirst(m.group(2).toUpperCase());
            m = p.matcher(word);
        }
        if (lowercaseFirstLetter) {
            word = word.substring(0, 1).toLowerCase() + word.substring(1);
        }
        return word;
    }

    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + suffix;
    }

    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    public boolean isSkipOverwrite() {
        return this.skipOverwrite;
    }

    public void setSkipOverwrite(boolean skipOverwrite) {
        this.skipOverwrite = skipOverwrite;
    }

    public Map<String, String> supportedLibraries() {
        return this.supportedLibraries;
    }

    public void setLibrary(String library) {
        if (library != null && !this.supportedLibraries.containsKey(library)) {
            throw new RuntimeException("unknown library: " + library);
        }
        this.library = library;
    }

    public String getLibrary() {
        return this.library;
    }

    protected CliOption buildLibraryCliOption(Map<String, String> supportedLibraries) {
        StringBuilder sb = new StringBuilder("library template (sub-template) to use:");
        for (String lib : supportedLibraries.keySet()) {
            sb.append("\n").append(lib).append(" - ").append(supportedLibraries.get(lib));
        }
        return new CliOption("library", sb.toString());
    }

    public String sanitizeName(String name) {
        name = name.replaceAll("\\[\\]", "");
        name = name.replaceAll("\\[", "_");
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("\\(", "_");
        name = name.replaceAll("\\)", "");
        name = name.replaceAll("\\.", "_");
        name = name.replaceAll("-", "_");
        name = name.replaceAll(" ", "_");
        return name.replaceAll("[^a-zA-Z0-9_]", "");
    }
}

