/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class PerlClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String moduleName = "SwaggerClient";
    protected String moduleVersion = "1.0.0";

    public PerlClientCodegen() {
        this.modelPackage = File.separatorChar + "Object";
        this.outputFolder = "generated-code" + File.separatorChar + "perl";
        this.modelTemplateFiles.put("object.mustache", ".pm");
        this.apiTemplateFiles.put("api.mustache", ".pm");
        this.templateDir = "perl";
        this.reservedWords = new HashSet<String>(Arrays.asList("else", "lock", "qw", "__END__", "elsif", "lt", "qx", "__FILE__", "eq", "m", "s", "__LINE__", "exp", "ne", "sub", "__PACKAGE__", "for", "no", "tr", "and", "foreach", "or", "unless", "cmp", "ge", "package", "until", "continue", "gt", "q", "while", "CORE", "if", "qq", "xor", "do", "le", "qr", "y"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("double");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("boolean");
        this.languageSpecificPrimitives.add("DateTime");
        this.languageSpecificPrimitives.add("ARRAY");
        this.languageSpecificPrimitives.add("HASH");
        this.languageSpecificPrimitives.add("object");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("dateTime", "DateTime");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("array", "ARRAY");
        this.typeMapping.put("map", "HASH");
        this.typeMapping.put("object", "object");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("moduleName", "perl module name (convention: CamelCase), default: SwaggerClient"));
        this.cliOptions.add(new CliOption("moduleVersion", "perl module version, default: 1.0.0"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("moduleVersion")) {
            this.moduleVersion = (String)this.additionalProperties.get("moduleVersion");
        } else {
            this.additionalProperties.put("moduleVersion", this.moduleVersion);
        }
        if (this.additionalProperties.containsKey("moduleName")) {
            this.moduleName = (String)this.additionalProperties.get("moduleName");
        } else {
            this.additionalProperties.put("moduleName", this.moduleName);
        }
        this.supportingFiles.add(new SupportingFile("ApiClient.mustache", ("lib/WWW/" + this.moduleName).replace('/', File.separatorChar), "ApiClient.pm"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", ("lib/WWW/" + this.moduleName).replace('/', File.separatorChar), "Configuration.pm"));
        this.supportingFiles.add(new SupportingFile("BaseObject.mustache", ("lib/WWW/" + this.moduleName).replace('/', File.separatorChar), "Object/BaseObject.pm"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "perl";
    }

    @Override
    public String getHelp() {
        return "Generates a Perl client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + "/lib/WWW/" + this.moduleName + this.apiPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + "/lib/WWW/" + this.moduleName + this.modelPackage()).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        return "null";
    }

    @Override
    public String toVarName(String name) {
        if ((name = PerlClientCodegen.underscore(name)).matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.reservedWords.contains(name)) {
            this.escapeReservedWord(name);
        }
        return PerlClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return PerlClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return PerlClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((String)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.reservedWords.contains(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return PerlClientCodegen.underscore(operationId);
    }
}

