/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class SwaggerGenerator
extends DefaultCodegen
implements CodegenConfig {
    public SwaggerGenerator() {
        this.templateDir = "swagger";
        this.outputFolder = "generated-code/swagger";
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "swagger";
    }

    @Override
    public String getHelp() {
        return "Creates a static swagger.json file.";
    }

    @Override
    public void processSwagger(Swagger swagger) {
        String swaggerString = Json.pretty((Object)swagger);
        try {
            String outputFile = this.outputFolder + File.separator + "swagger.json";
            FileUtils.writeStringToFile((File)new File(outputFile), (String)swaggerString);
            System.out.println("wrote file to " + outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

