/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.AbstractGenerator;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenSecurity;
import io.swagger.codegen.Generator;
import io.swagger.codegen.InlineModelResolver;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.Parameter;
import io.swagger.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGenerator
extends AbstractGenerator
implements Generator {
    Logger LOGGER = LoggerFactory.getLogger(DefaultGenerator.class);
    protected CodegenConfig config;
    protected ClientOptInput opts;
    protected Swagger swagger;

    @Override
    public Generator opts(ClientOptInput opts) {
        this.opts = opts;
        this.swagger = opts.getSwagger();
        this.config = opts.getConfig();
        this.config.additionalProperties().putAll(opts.getOpts().getProperties());
        return this;
    }

    @Override
    public List<File> generate() {
        String templateFile;
        Template tmpl;
        String template;
        Boolean generateApis = null;
        Boolean generateModels = null;
        Boolean generateSupportingFiles = null;
        HashSet<String> modelsToGenerate = null;
        HashSet<String> apisToGenerate = null;
        HashSet<String> supportingFilesToGenerate = null;
        if (System.getProperty("models") != null) {
            String modelNames = System.getProperty("models");
            generateModels = true;
            if (!modelNames.isEmpty()) {
                modelsToGenerate = new HashSet<String>(Arrays.asList(modelNames.split(",")));
            }
        }
        if (System.getProperty("apis") != null) {
            String apiNames = System.getProperty("apis");
            generateApis = true;
            if (!apiNames.isEmpty()) {
                apisToGenerate = new HashSet<String>(Arrays.asList(apiNames.split(",")));
            }
        }
        if (System.getProperty("supportingFiles") != null) {
            String supportingFiles = System.getProperty("supportingFiles");
            generateSupportingFiles = true;
            if (!supportingFiles.isEmpty()) {
                supportingFilesToGenerate = new HashSet<String>(Arrays.asList(supportingFiles.split(",")));
            }
        }
        if (generateApis == null && generateModels == null && generateSupportingFiles == null) {
            generateApis = true;
            generateModels = true;
            generateSupportingFiles = true;
        } else {
            if (generateApis == null) {
                generateApis = false;
            }
            if (generateModels == null) {
                generateModels = false;
            }
            if (generateSupportingFiles == null) {
                generateSupportingFiles = false;
            }
        }
        if (this.swagger == null || this.config == null) {
            throw new RuntimeException("missing swagger input or config!");
        }
        if (System.getProperty("debugSwagger") != null) {
            Json.prettyPrint((Object)this.swagger);
        }
        ArrayList<File> files = new ArrayList<File>();
        this.config.processOpts();
        this.config.preprocessSwagger(this.swagger);
        this.config.additionalProperties().put("generatedDate", DateTime.now().toString());
        this.config.additionalProperties().put("generatorClass", this.config.getClass().toString());
        if (this.swagger.getInfo() != null) {
            Info info = this.swagger.getInfo();
            if (info.getTitle() != null) {
                this.config.additionalProperties().put("appName", info.getTitle());
            }
            if (info.getVersion() != null) {
                this.config.additionalProperties().put("appVersion", info.getVersion());
            }
            if (info.getDescription() != null) {
                this.config.additionalProperties().put("appDescription", this.config.escapeText(info.getDescription()));
            }
            if (info.getContact() != null) {
                Contact contact = info.getContact();
                this.config.additionalProperties().put("infoUrl", contact.getUrl());
                if (contact.getEmail() != null) {
                    this.config.additionalProperties().put("infoEmail", contact.getEmail());
                }
            }
            if (info.getLicense() != null) {
                License license = info.getLicense();
                if (license.getName() != null) {
                    this.config.additionalProperties().put("licenseInfo", license.getName());
                }
                if (license.getUrl() != null) {
                    this.config.additionalProperties().put("licenseUrl", license.getUrl());
                }
            }
            if (info.getVersion() != null) {
                this.config.additionalProperties().put("version", info.getVersion());
            }
        }
        StringBuilder hostBuilder = new StringBuilder();
        String scheme = this.swagger.getSchemes() != null && this.swagger.getSchemes().size() > 0 ? ((Scheme)this.swagger.getSchemes().get(0)).toValue() : "https";
        hostBuilder.append(scheme);
        hostBuilder.append("://");
        if (this.swagger.getHost() != null) {
            hostBuilder.append(this.swagger.getHost());
        } else {
            hostBuilder.append("localhost");
        }
        if (this.swagger.getBasePath() != null) {
            hostBuilder.append(this.swagger.getBasePath());
        }
        String contextPath = this.swagger.getBasePath() == null ? "" : this.swagger.getBasePath();
        String basePath = hostBuilder.toString();
        String basePathWithoutHost = this.swagger.getBasePath();
        InlineModelResolver inlineModelResolver = new InlineModelResolver();
        inlineModelResolver.flatten(this.swagger);
        ArrayList<HashMap<String, Object>> allOperations = new ArrayList<HashMap<String, Object>>();
        ArrayList allModels = new ArrayList();
        Map definitions = this.swagger.getDefinitions();
        if (definitions != null) {
            List<String> sortedModelKeys = this.sortModelsByInheritance(definitions);
            if (generateModels.booleanValue()) {
                if (modelsToGenerate != null && modelsToGenerate.size() > 0) {
                    ArrayList<String> updatedKeys = new ArrayList<String>();
                    for (String m : sortedModelKeys) {
                        if (!modelsToGenerate.contains(m)) continue;
                        updatedKeys.add(m);
                    }
                    sortedModelKeys = updatedKeys;
                }
                for (String name : sortedModelKeys) {
                    try {
                        if (this.config.importMapping().containsKey(name)) continue;
                        Model model = (Model)definitions.get(name);
                        HashMap<String, Model> modelMap = new HashMap<String, Model>();
                        modelMap.put(name, model);
                        Map<String, Object> models = this.processModels(this.config, modelMap, definitions);
                        models.putAll(this.config.additionalProperties());
                        allModels.add(((List)models.get("models")).get(0));
                        for (String templateName : this.config.modelTemplateFiles().keySet()) {
                            String suffix = this.config.modelTemplateFiles().get(templateName);
                            String filename = this.config.modelFileFolder() + File.separator + this.config.toModelFilename(name) + suffix;
                            if (!this.config.shouldOverwrite(filename)) continue;
                            String templateFile2 = this.getFullTemplateFile(this.config, templateName);
                            template = this.readTemplate(templateFile2);
                            tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                                public Reader getTemplate(String name) {
                                    return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                                }
                            }).defaultValue("").compile(template);
                            this.writeToFile(filename, tmpl.execute(models));
                            files.add(new File(filename));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not generate model '" + name + "'", e);
                    }
                }
            }
        }
        if (System.getProperty("debugModels") != null) {
            System.out.println("############ Model info ############");
            Json.prettyPrint(allModels);
        }
        Map<String, List<CodegenOperation>> paths = this.processPaths(this.swagger.getPaths());
        if (generateApis.booleanValue()) {
            if (apisToGenerate != null && apisToGenerate.size() > 0) {
                TreeMap<String, List<CodegenOperation>> updatedPaths = new TreeMap<String, List<CodegenOperation>>();
                for (String m : paths.keySet()) {
                    if (!apisToGenerate.contains(m)) continue;
                    updatedPaths.put(m, paths.get(m));
                }
                paths = updatedPaths;
            }
            for (String tag : paths.keySet()) {
                try {
                    List<CodegenOperation> ops = paths.get(tag);
                    Map<String, Object> operation = this.processOperations(this.config, tag, ops);
                    operation.put("basePath", basePath);
                    operation.put("basePathWithoutHost", basePathWithoutHost);
                    operation.put("contextPath", contextPath);
                    operation.put("baseName", tag);
                    operation.put("modelPackage", this.config.modelPackage());
                    operation.putAll(this.config.additionalProperties());
                    operation.put("classname", this.config.toApiName(tag));
                    operation.put("classVarName", this.config.toApiVarName(tag));
                    operation.put("importPath", this.config.toApiImport(tag));
                    boolean sortParamsByRequiredFlag = true;
                    if (this.config.additionalProperties().containsKey("sortParamsByRequiredFlag")) {
                        sortParamsByRequiredFlag = Boolean.valueOf(this.config.additionalProperties().get("sortParamsByRequiredFlag").toString());
                    }
                    operation.put("sortParamsByRequiredFlag", sortParamsByRequiredFlag);
                    this.processMimeTypes(this.swagger.getConsumes(), operation, "consumes");
                    this.processMimeTypes(this.swagger.getProduces(), operation, "produces");
                    allOperations.add(new HashMap<String, Object>(operation));
                    for (int i = 0; i < allOperations.size(); ++i) {
                        Map oo = (Map)allOperations.get(i);
                        if (i >= allOperations.size() - 1) continue;
                        oo.put("hasMore", "true");
                    }
                    for (String templateName : this.config.apiTemplateFiles().keySet()) {
                        String filename = this.config.apiFilename(templateName, tag);
                        if (!this.config.shouldOverwrite(filename) && new File(filename).exists()) continue;
                        templateFile = this.getFullTemplateFile(this.config, templateName);
                        String template2 = this.readTemplate(templateFile);
                        Template tmpl2 = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                            public Reader getTemplate(String name) {
                                return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                            }
                        }).defaultValue("").compile(template2);
                        this.writeToFile(filename, tmpl2.execute(operation));
                        files.add(new File(filename));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not generate api file for '" + tag + "'", e);
                }
            }
        }
        if (System.getProperty("debugOperations") != null) {
            System.out.println("############ Operation info ############");
            Json.prettyPrint(allOperations);
        }
        HashMap<String, Object> bundle = new HashMap<String, Object>();
        bundle.putAll(this.config.additionalProperties());
        bundle.put("apiPackage", this.config.apiPackage());
        HashMap<String, ArrayList<HashMap<String, Object>>> apis = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        apis.put("apis", allOperations);
        if (this.swagger.getHost() != null) {
            bundle.put("host", this.swagger.getHost());
        }
        bundle.put("swagger", this.swagger);
        bundle.put("basePath", basePath);
        bundle.put("scheme", scheme);
        bundle.put("contextPath", contextPath);
        bundle.put("apiInfo", apis);
        bundle.put("models", allModels);
        bundle.put("apiFolder", this.config.apiPackage().replace('.', File.separatorChar));
        bundle.put("modelPackage", this.config.modelPackage());
        List<CodegenSecurity> authMethods = this.config.fromSecurity(this.swagger.getSecurityDefinitions());
        if (authMethods != null && !authMethods.isEmpty()) {
            bundle.put("authMethods", authMethods);
            bundle.put("hasAuthMethods", true);
        }
        if (this.swagger.getExternalDocs() != null) {
            bundle.put("externalDocs", this.swagger.getExternalDocs());
        }
        for (int i = 0; i < allModels.size() - 1; ++i) {
            HashMap cm = (HashMap)allModels.get(i);
            CodegenModel m = (CodegenModel)cm.get("model");
            m.hasMoreModels = true;
        }
        this.config.postProcessSupportingFileData(bundle);
        if (System.getProperty("debugSupportingFiles") != null) {
            System.out.println("############ Supporting file info ############");
            Json.prettyPrint(bundle);
        }
        if (generateSupportingFiles.booleanValue()) {
            for (SupportingFile support : this.config.supportingFiles()) {
                try {
                    String outputFilename;
                    File of;
                    String outputFolder = this.config.outputFolder();
                    if (StringUtils.isNotEmpty((CharSequence)support.folder)) {
                        outputFolder = outputFolder + File.separator + support.folder;
                    }
                    if (!(of = new File(outputFolder)).isDirectory()) {
                        of.mkdirs();
                    }
                    if (!this.config.shouldOverwrite(outputFilename = outputFolder + File.separator + support.destinationFilename)) continue;
                    templateFile = this.getFullTemplateFile(this.config, support.templateFile);
                    boolean shouldGenerate = true;
                    if (supportingFilesToGenerate != null && supportingFilesToGenerate.size() > 0) {
                        shouldGenerate = supportingFilesToGenerate.contains(support.destinationFilename);
                    }
                    if (!shouldGenerate) continue;
                    if (templateFile.endsWith("mustache")) {
                        template = this.readTemplate(templateFile);
                        tmpl = Mustache.compiler().withLoader(new Mustache.TemplateLoader(){

                            public Reader getTemplate(String name) {
                                return DefaultGenerator.this.getTemplateReader(DefaultGenerator.this.getFullTemplateFile(DefaultGenerator.this.config, name + ".mustache"));
                            }
                        }).defaultValue("").compile(template);
                        this.writeToFile(outputFilename, tmpl.execute(bundle));
                        files.add(new File(outputFilename));
                        continue;
                    }
                    InputStream in = null;
                    try {
                        in = new FileInputStream(templateFile);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (in == null) {
                        in = this.getClass().getClassLoader().getResourceAsStream(this.getCPResourcePath(templateFile));
                    }
                    File outputFile = new File(outputFilename);
                    FileOutputStream out = new FileOutputStream(outputFile, false);
                    if (in != null && out != null) {
                        System.out.println("writing file " + outputFile);
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    } else {
                        if (in == null) {
                            System.out.println("can't open " + templateFile + " for input");
                        }
                        if (out == null) {
                            System.out.println("can't open " + outputFile + " for output");
                        }
                    }
                    files.add(outputFile);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not generate supporting file '" + support + "'", e);
                }
            }
        }
        this.config.processSwagger(this.swagger);
        return files;
    }

    private void processMimeTypes(List<String> mimeTypeList, Map<String, Object> operation, String source) {
        if (mimeTypeList != null && mimeTypeList.size() > 0) {
            ArrayList c = new ArrayList();
            int count = 0;
            for (String key : mimeTypeList) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                mediaType.put("mediaType", key);
                if (++count < mimeTypeList.size()) {
                    mediaType.put("hasMore", "true");
                } else {
                    mediaType.put("hasMore", null);
                }
                c.add(mediaType);
            }
            operation.put(source, c);
            String flagFieldName = "has" + source.substring(0, 1).toUpperCase() + source.substring(1);
            operation.put(flagFieldName, true);
        }
    }

    private List<String> sortModelsByInheritance(final Map<String, Model> definitions) {
        ArrayList<String> sortedModelKeys = new ArrayList<String>(definitions.keySet());
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int model2InheritanceDepth;
                Model model1 = (Model)definitions.get(o1);
                Model model2 = (Model)definitions.get(o2);
                int model1InheritanceDepth = this.getInheritanceDepth(model1);
                if (model1InheritanceDepth == (model2InheritanceDepth = this.getInheritanceDepth(model2))) {
                    return 0;
                }
                if (model1InheritanceDepth > model2InheritanceDepth) {
                    return 1;
                }
                return -1;
            }

            private int getInheritanceDepth(Model model) {
                int inheritanceDepth = 0;
                Model parent = this.getParent(model);
                while (parent != null) {
                    ++inheritanceDepth;
                    parent = this.getParent(parent);
                }
                return inheritanceDepth;
            }

            private Model getParent(Model model) {
                if (model instanceof ComposedModel) {
                    return (Model)definitions.get(((ComposedModel)model).getParent().getReference());
                }
                return null;
            }
        };
        Collections.sort(sortedModelKeys, cmp);
        return sortedModelKeys;
    }

    public Map<String, List<CodegenOperation>> processPaths(Map<String, Path> paths) {
        HashMap<String, List<CodegenOperation>> ops = new HashMap<String, List<CodegenOperation>>();
        for (String resourcePath : paths.keySet()) {
            Path path = paths.get(resourcePath);
            this.processOperation(resourcePath, "get", path.getGet(), ops, path);
            this.processOperation(resourcePath, "head", path.getHead(), ops, path);
            this.processOperation(resourcePath, "put", path.getPut(), ops, path);
            this.processOperation(resourcePath, "post", path.getPost(), ops, path);
            this.processOperation(resourcePath, "delete", path.getDelete(), ops, path);
            this.processOperation(resourcePath, "patch", path.getPatch(), ops, path);
            this.processOperation(resourcePath, "options", path.getOptions(), ops, path);
        }
        return ops;
    }

    public SecuritySchemeDefinition fromSecurity(String name) {
        Map map = this.swagger.getSecurityDefinitions();
        if (map == null) {
            return null;
        }
        return (SecuritySchemeDefinition)map.get(name);
    }

    public void processOperation(String resourcePath, String httpMethod, Operation operation, Map<String, List<CodegenOperation>> operations, Path path) {
        if (operation != null) {
            ArrayList<String> tags;
            if (System.getProperty("debugOperations") != null) {
                this.LOGGER.debug("processOperation: resourcePath= " + resourcePath + "\t;" + httpMethod + " " + operation + "\n");
            }
            if ((tags = operation.getTags()) == null) {
                tags = new ArrayList<String>();
                tags.add("default");
            }
            HashSet<String> operationParameters = new HashSet<String>();
            if (operation.getParameters() != null) {
                for (Parameter parameter : operation.getParameters()) {
                    operationParameters.add(this.generateParameterId(parameter));
                }
            }
            if (path.getParameters() != null) {
                for (Parameter parameter : path.getParameters()) {
                    if (operationParameters.contains(this.generateParameterId(parameter))) continue;
                    operation.addParameter(parameter);
                }
            }
            for (String tag : tags) {
                CodegenOperation co = null;
                try {
                    co = this.config.fromOperation(resourcePath, httpMethod, operation, this.swagger.getDefinitions(), this.swagger);
                    co.tags = new ArrayList<String>();
                    co.tags.add(this.sanitizeTag(tag));
                    this.config.addOperationToGroup(this.sanitizeTag(tag), resourcePath, operation, co, operations);
                    ArrayList<Map> securities = operation.getSecurity();
                    if (securities == null && this.swagger.getSecurity() != null) {
                        securities = new ArrayList<Map>();
                        for (SecurityRequirement sr : this.swagger.getSecurity()) {
                            securities.add(sr.getRequirements());
                        }
                    }
                    if (securities == null || securities.isEmpty()) continue;
                    HashMap<String, SecuritySchemeDefinition> authMethods = new HashMap<String, SecuritySchemeDefinition>();
                    if (securities.size() > 1) {
                        this.LOGGER.warn("More than 1 security requirements are found, using only the first one");
                    }
                    Map security = (Map)securities.get(0);
                    for (String securityName : security.keySet()) {
                        SecuritySchemeDefinition securityDefinition = this.fromSecurity(securityName);
                        if (securityDefinition == null) continue;
                        if (securityDefinition instanceof OAuth2Definition) {
                            OAuth2Definition oauth2Definition = (OAuth2Definition)securityDefinition;
                            OAuth2Definition oauth2Operation = new OAuth2Definition();
                            oauth2Operation.setType(oauth2Definition.getType());
                            oauth2Operation.setAuthorizationUrl(oauth2Definition.getAuthorizationUrl());
                            oauth2Operation.setFlow(oauth2Definition.getFlow());
                            oauth2Operation.setTokenUrl(oauth2Definition.getTokenUrl());
                            oauth2Operation.setScopes(new HashMap());
                            for (String scope : (List)security.get(securityName)) {
                                if (!oauth2Definition.getScopes().containsKey(scope)) continue;
                                oauth2Operation.addScope(scope, (String)oauth2Definition.getScopes().get(scope));
                            }
                            authMethods.put(securityName, (SecuritySchemeDefinition)oauth2Operation);
                            continue;
                        }
                        authMethods.put(securityName, securityDefinition);
                    }
                    if (authMethods.isEmpty()) continue;
                    co.authMethods = this.config.fromSecurity(authMethods);
                    co.hasAuthMethods = true;
                }
                catch (Exception ex) {
                    String msg = "Could not process operation:\n  Tag: " + tag + "\n" + "  Operation: " + operation.getOperationId() + "\n" + "  Resource: " + httpMethod + " " + resourcePath + "\n" + "  Definitions: " + this.swagger.getDefinitions() + "\n" + "  Exception: " + ex.getMessage();
                    throw new RuntimeException(msg, ex);
                }
            }
        }
    }

    private String generateParameterId(Parameter parameter) {
        return parameter.getName() + ":" + parameter.getIn();
    }

    protected String sanitizeTag(String tag) {
        String[] parts = tag.split(" ");
        StringBuilder buf = new StringBuilder();
        for (String part : parts) {
            if (!StringUtils.isNotEmpty((CharSequence)part)) continue;
            buf.append(StringUtils.capitalize((String)part));
        }
        return buf.toString().replaceAll("[^a-zA-Z ]", "");
    }

    public Map<String, Object> processOperations(CodegenConfig config, String tag, List<CodegenOperation> ops) {
        List os;
        HashMap<String, Object> operations = new HashMap<String, Object>();
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("classname", config.toApiName(tag));
        objs.put("pathPrefix", config.toApiVarName(tag));
        HashSet<String> opIds = new HashSet<String>();
        int counter = 0;
        for (CodegenOperation op : ops) {
            String opId = op.nickname;
            if (opIds.contains(opId)) {
                op.nickname = op.nickname + "_" + ++counter;
            }
            opIds.add(opId);
        }
        objs.put("operation", ops);
        operations.put("operations", objs);
        operations.put("package", config.apiPackage());
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (CodegenOperation op : ops) {
            allImports.addAll(op.imports);
        }
        ArrayList imports = new ArrayList();
        for (String nextImport : allImports) {
            LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping == null) continue;
            im.put("import", mapping);
            imports.add(im);
        }
        operations.put("imports", imports);
        if (imports.size() > 0) {
            operations.put("hasImport", true);
        }
        config.postProcessOperations(operations);
        if (objs.size() > 0 && (os = (List)objs.get("operation")) != null && os.size() > 0) {
            CodegenOperation op = (CodegenOperation)os.get(os.size() - 1);
            op.hasMore = null;
        }
        return operations;
    }

    public Map<String, Object> processModels(CodegenConfig config, Map<String, Model> definitions, Map<String, Model> allDefinitions) {
        HashMap<String, Object> objs = new HashMap<String, Object>();
        objs.put("package", config.modelPackage());
        ArrayList models = new ArrayList();
        LinkedHashSet<String> allImports = new LinkedHashSet<String>();
        for (String key : definitions.keySet()) {
            Model mm = definitions.get(key);
            CodegenModel cm = config.fromModel(key, mm, allDefinitions);
            HashMap<String, Object> mo = new HashMap<String, Object>();
            mo.put("model", cm);
            mo.put("importPath", config.toModelImport(key));
            models.add(mo);
            allImports.addAll(cm.imports);
        }
        objs.put("models", models);
        TreeSet<String> importSet = new TreeSet<String>();
        for (String nextImport : allImports) {
            HashMap im = new HashMap();
            String mapping = config.importMapping().get(nextImport);
            if (mapping == null) {
                mapping = config.toModelImport(nextImport);
            }
            if (mapping != null && !config.defaultIncludes().contains(mapping)) {
                importSet.add(mapping);
            }
            if ((mapping = config.instantiationTypes().get(nextImport)) == null || config.defaultIncludes().contains(mapping)) continue;
            importSet.add(mapping);
        }
        ArrayList imports = new ArrayList();
        for (String s : importSet) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("import", s);
            imports.add(item);
        }
        objs.put("imports", imports);
        config.postProcessModels(objs);
        return objs;
    }
}

