/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.examples;

import io.swagger.codegen.examples.XmlExampleGenerator;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExampleGenerator {
    protected Map<String, Model> examples;

    public ExampleGenerator(Map<String, Model> examples) {
        this.examples = examples;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Property property) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Arrays.asList("application/json");
            }
            for (String string : mediaTypes) {
                String example;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put("contentType", string);
                if (property != null && string.startsWith("application/json")) {
                    example = Json.pretty((Object)this.resolvePropertyToExample(string, property, processedModels));
                    if (example == null) continue;
                    kv.put("example", example);
                    output.add(kv);
                    continue;
                }
                if (property == null || !string.startsWith("application/xml") || (example = new XmlExampleGenerator(this.examples).toXml(property)) == null) continue;
                kv.put("example", example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put("contentType", entry.getKey());
                kv.put("example", Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put("output", "none");
            output.add(kv);
        }
        return output;
    }

    protected Object resolvePropertyToExample(String mediaType, Property property, Set<String> processedModels) {
        if (property.getExample() != null) {
            return property.getExample();
        }
        if (property instanceof StringProperty) {
            return "aeiou";
        }
        if (property instanceof BooleanProperty) {
            return Boolean.TRUE;
        }
        if (property instanceof ArrayProperty) {
            Property innerType = ((ArrayProperty)property).getItems();
            if (innerType != null) {
                return new Object[]{this.resolvePropertyToExample(mediaType, innerType, processedModels)};
            }
        } else {
            if (property instanceof DateProperty) {
                return "2000-01-23T04:56:07.000+0000";
            }
            if (property instanceof DateTimeProperty) {
                return "2000-01-23T04:56:07.000+0000";
            }
            if (property instanceof DecimalProperty) {
                return new BigDecimal(1.3579);
            }
            if (property instanceof DoubleProperty) {
                return new Double(3.149);
            }
            if (property instanceof FileProperty) {
                return "";
            }
            if (property instanceof FloatProperty) {
                return new Float(1.23);
            }
            if (property instanceof IntegerProperty) {
                return new Integer(123);
            }
            if (property instanceof LongProperty) {
                return new Long(123456789L);
            }
            if (property instanceof MapProperty) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (property.getName() != null) {
                    mp.put(property.getName(), this.resolvePropertyToExample(mediaType, ((MapProperty)property).getAdditionalProperties(), processedModels));
                } else {
                    mp.put("key", this.resolvePropertyToExample(mediaType, ((MapProperty)property).getAdditionalProperties(), processedModels));
                }
                return mp;
            }
            if (property instanceof ObjectProperty) {
                return "{}";
            }
            if (property instanceof RefProperty) {
                String simpleName = ((RefProperty)property).getSimpleRef();
                Model model = this.examples.get(simpleName);
                if (model != null) {
                    return this.resolveModelToExample(simpleName, mediaType, model, processedModels);
                }
            } else if (property instanceof UUIDProperty) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
        }
        return "";
    }

    public Object resolveModelToExample(String name, String mediaType, Model model, Set<String> processedModels) {
        if (processedModels.contains(name)) {
            return "";
        }
        if (model instanceof ModelImpl) {
            processedModels.add(name);
            ModelImpl impl = (ModelImpl)model;
            HashMap<String, Object> values = new HashMap<String, Object>();
            if (impl.getProperties() != null) {
                for (String propertyName : impl.getProperties().keySet()) {
                    Property property = (Property)impl.getProperties().get(propertyName);
                    values.put(propertyName, this.resolvePropertyToExample(mediaType, property, processedModels));
                }
            }
            return values;
        }
        return "";
    }
}

