/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.JavaClientCodegen;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaInflectorServerCodegen
extends JavaClientCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaInflectorServerCodegen.class);
    protected String title = "Swagger Inflector";
    protected String implFolder = "src/main/java";

    public JavaInflectorServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.templateDir = "JavaInflector";
        this.embeddedTemplateDir = "JavaInflector";
        this.invokerPackage = "io.swagger.handler";
        this.artifactId = "swagger-inflector-server";
        this.apiPackage = System.getProperty("swagger.codegen.inflector.apipackage", "io.swagger.handler");
        this.modelPackage = System.getProperty("swagger.codegen.inflector.modelpackage", "io.swagger.model");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("title", this.title);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("byte[]", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "inflector";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Inflector Server application.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.clear();
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.writeOptional(this.outputFolder, new SupportingFile("web.mustache", "src/main/webapp/WEB-INF", "web.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("inflector.mustache", "", "inflector.yaml"));
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "src/main/swagger", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("StringUtil.mustache", (this.sourceFolder + '/' + this.invokerPackage).replace(".", "/"), "StringUtil.java"));
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        int pos;
        String basePath = resourcePath;
        if (basePath.startsWith("/")) {
            basePath = basePath.substring(1);
        }
        if ((pos = basePath.indexOf("/")) > 0) {
            basePath = basePath.substring(0, pos);
        }
        if (basePath == "") {
            basePath = "default";
        } else {
            if (co.path.startsWith("/" + basePath)) {
                co.path = co.path.substring(("/" + basePath).length());
            }
            co.subresourceOperation = !co.path.isEmpty();
        }
        List<CodegenOperation> opList = operations.get(basePath);
        if (opList == null) {
            opList = new ArrayList<CodegenOperation>();
            operations.put(basePath, opList);
        }
        opList.add(co);
        co.baseName = basePath;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                int end;
                String rt;
                if (operation.returnType == null) {
                    operation.returnType = "Void";
                    continue;
                }
                if (operation.returnType.startsWith("List")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("List<".length(), end);
                    operation.returnContainer = "List";
                    continue;
                }
                if (operation.returnType.startsWith("Map")) {
                    rt = operation.returnType;
                    end = rt.lastIndexOf(">");
                    if (end <= 0) continue;
                    operation.returnType = rt.substring("Map<".length(), end);
                    operation.returnContainer = "Map";
                    continue;
                }
                if (!operation.returnType.startsWith("Set") || (end = (rt = operation.returnType).lastIndexOf(">")) <= 0) continue;
                operation.returnType = rt.substring("Set<".length(), end);
                operation.returnContainer = "Set";
            }
        }
        return objs;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("api.mustache")) {
            int ix = result.indexOf(this.sourceFolder);
            String beg = result.substring(0, ix);
            String end = result.substring(ix + this.sourceFolder.length());
            new File(beg + this.implFolder).mkdirs();
            result = beg + this.implFolder + end;
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Swagger swagger = (Swagger)objs.get("swagger");
        if (swagger != null) {
            try {
                objs.put("swagger-yaml", Yaml.mapper().writeValueAsString((Object)swagger));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        name = name.replaceAll("[^a-zA-Z0-9]+", "_");
        return JavaInflectorServerCodegen.camelize(name) + "Controller";
    }
}

