/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSharpCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalProjectFileFlag = true;
    protected boolean optionalEmitDefaultValue = false;
    protected boolean optionalMethodArgumentFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected String packageVersion = "1.0.0";
    protected String packageName = "IO.Swagger";
    protected String packageTitle = "Swagger Library";
    protected String packageProductName = "SwaggerLibrary";
    protected String packageDescription = "A library generated from a Swagger doc";
    protected String packageCompany = "Swagger";
    protected String packageCopyright = "No Copyright";
    protected String sourceFolder;
    protected String testFolder = this.sourceFolder = "src";
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected Logger LOGGER = LoggerFactory.getLogger(AbstractCSharpCodegen.class);

    public AbstractCSharpCodegen() {
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("IList", "List", "ICollection", "Collection", "IEnumerable"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary"));
        this.setReservedWordsLowerCase(Arrays.asList("client", "localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "double?", "decimal?", "int?", "long?", "float?", "byte[]", "ICollection", "Collection", "List", "Dictionary", "DateTime?", "DateTimeOffset?", "String", "Boolean", "Double", "Int32", "Int64", "Float", "Guid?", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("list", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("bytearray", "byte[]");
        this.typeMapping.put("boolean", "bool?");
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("long", "long?");
        this.typeMapping.put("double", "double?");
        this.typeMapping.put("number", "decimal?");
        this.typeMapping.put("datetime", "DateTime?");
        this.typeMapping.put("date", "DateTime?");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("uuid", "Guid?");
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setOptionalEmitDefaultValue(boolean optionalEmitDefaultValue) {
        this.optionalEmitDefaultValue = optionalEmitDefaultValue;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.typeMapping.put("array", "Collection");
            this.typeMapping.put("list", "Collection");
            this.instantiationTypes.put("array", "Collection");
            this.instantiationTypes.put("list", "Collection");
        }
    }

    public void setOptionalMethodArgumentFlag(boolean flag) {
        this.optionalMethodArgumentFlag = flag;
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    protected void addSwitch(String key, String description, Boolean defaultValue) {
        CliOption option = CliOption.newBoolean(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue.toString());
        }
        this.cliOptions.add(option);
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        if (flag) {
            this.typeMapping.put("datetime", "DateTimeOffset?");
        } else {
            this.typeMapping.put("datetime", "DateTime?");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(Boolean.valueOf(this.additionalProperties.get("useDateTimeOffset").toString()));
        }
        this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        if (this.additionalProperties.containsKey("useCollection")) {
            this.setUseCollection(Boolean.valueOf(this.additionalProperties.get("useCollection").toString()));
        }
        if (this.additionalProperties.containsKey("returnICollection")) {
            this.setReturnICollection(Boolean.valueOf(this.additionalProperties.get("returnICollection").toString()));
        }
        if (this.additionalProperties.containsKey("optionalEmitDefaultValues")) {
            this.setOptionalEmitDefaultValue(Boolean.valueOf(this.additionalProperties.get("optionalEmitDefaultValues").toString()));
        }
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.name.equalsIgnoreCase(cm.name)) continue;
                var.name = "_" + var.name;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations;
        super.postProcessOperations(objs);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.returnType != null) {
                    int namespaceEnd = operation.returnType.lastIndexOf(".");
                    String typeMapping = namespaceEnd > 0 ? operation.returnType.substring(namespaceEnd) : operation.returnType;
                    if (this.collectionTypes.contains(typeMapping)) {
                        int genericStart;
                        operation.isListContainer = true;
                        operation.returnContainer = operation.returnType;
                        if (this.returnICollection && (typeMapping.startsWith("List") || typeMapping.startsWith("Collection")) && (genericStart = typeMapping.indexOf("<")) > 0) {
                            operation.returnType = "ICollection" + typeMapping.substring(genericStart);
                        }
                    } else {
                        operation.returnContainer = operation.returnType;
                        operation.isMapContainer = this.mapTypes.contains(typeMapping);
                    }
                }
                this.processOperation(operation);
            }
        }
        return objs;
    }

    protected void processOperation(CodegenOperation operation) {
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractCSharpCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return AbstractCSharpCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String toExampleValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getExample() != null) {
                return "\"" + dp.getExample().toString() + "\"";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getExample() != null) {
                    return dp2.getExample().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getExample() != null) {
                    return dp3.getExample().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getExample() != null) {
                    return dp4.getExample().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getExample() != null) {
                return dp.getExample().toString();
            }
        }
        return null;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "\"" + dp.getDefault().toString() + "\"";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return String.format("%1$sF", dp3.getDefault());
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType.toLowerCase())) {
            type = (String)this.typeMapping.get(swaggerType.toLowerCase());
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toModelName(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return AbstractCSharpCodegen.camelize(name);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = AbstractCSharpCodegen.camelize(enumName) + "Enum").matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(AbstractCSharpCodegen.camelize(property.name)) + "Enum";
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
    }
}

