/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LumenServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String sourceFolder = "";
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "lumen";
    }

    @Override
    public String getHelp() {
        return "Generates a LumenServerCodegen client library.";
    }

    public LumenServerCodegen() {
        this.outputFolder = "lumen";
        String packagePath = "";
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.templateDir = "lumen";
        this.apiPackage = "app.Http.Controllers";
        this.modelPackage = "models";
        this.reservedWords = new HashSet<String>(Arrays.asList("sample1", "sample2"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("composer.mustache", packagePath, "composer.json"));
        this.supportingFiles.add(new SupportingFile("readme.md", packagePath, "readme.md"));
        this.supportingFiles.add(new SupportingFile("app.php", packagePath + File.separator + "bootstrap", "app.php"));
        this.supportingFiles.add(new SupportingFile("index.php", packagePath + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("User.php", packagePath + File.separator + "app", "User.php"));
        this.supportingFiles.add(new SupportingFile("Kernel.php", packagePath + File.separator + "app" + File.separator + "Console", "Kernel.php"));
        this.supportingFiles.add(new SupportingFile("Handler.php", packagePath + File.separator + "app" + File.separator + "Exceptions", "Handler.php"));
        this.supportingFiles.add(new SupportingFile("routes.mustache", packagePath + File.separator + "app" + File.separator + "Http", "routes.php"));
        this.supportingFiles.add(new SupportingFile("Controller.php", packagePath + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers" + File.separator, "Controller.php"));
        this.supportingFiles.add(new SupportingFile("Authenticate.php", packagePath + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware" + File.separator, "Authenticate.php"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Type1", "Type2"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        Collections.sort(operations, new Comparator<CodegenOperation>(){

            @Override
            public int compare(CodegenOperation lhs, CodegenOperation rhs) {
                return lhs.path.compareTo(rhs.path);
            }
        });
        return objs;
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

