/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RubyClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(RubyClientCodegen.class);
    public static final String GEM_NAME = "gemName";
    public static final String MODULE_NAME = "moduleName";
    public static final String GEM_VERSION = "gemVersion";
    public static final String GEM_LICENSE = "gemLicense";
    public static final String GEM_HOMEPAGE = "gemHomepage";
    public static final String GEM_SUMMARY = "gemSummary";
    public static final String GEM_DESCRIPTION = "gemDescription";
    public static final String GEM_AUTHOR = "gemAuthor";
    public static final String GEM_AUTHOR_EMAIL = "gemAuthorEmail";
    protected String gemName;
    protected String moduleName;
    protected String gemVersion = "1.0.0";
    protected String specFolder = "spec";
    protected String libFolder = "lib";
    protected String gemLicense = "Apache-2.0";
    protected String gemHomepage = "http://swagger.io";
    protected String gemSummary = "A ruby wrapper for the swagger APIs";
    protected String gemDescription = "This gem maps to a swagger API";
    protected String gemAuthor = "";
    protected String gemAuthorEmail = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected static int emptyMethodNameCounter = 0;

    public RubyClientCodegen() {
        this.modelPackage = "models";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separator + "ruby";
        this.modelTemplateFiles.put("model.mustache", ".rb");
        this.apiTemplateFiles.put("api.mustache", ".rb");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "ruby";
        this.embeddedTemplateDir = "ruby";
        this.modelTestTemplateFiles.put("model_test.mustache", ".rb");
        this.apiTestTemplateFiles.put("api_test.mustache", ".rb");
        this.setReservedWordsLowerCase(Arrays.asList("local_var_path", "query_params", "header_params", "_header_accept", "_header_accept_result", "_header_content_type", "form_params", "post_body", "auth_names", "__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.typeMapping.clear();
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("int");
        this.languageSpecificPrimitives.add("array");
        this.languageSpecificPrimitives.add("map");
        this.languageSpecificPrimitives.add("string");
        this.languageSpecificPrimitives.add("String");
        this.languageSpecificPrimitives.add("Integer");
        this.languageSpecificPrimitives.add("Float");
        this.languageSpecificPrimitives.add("Date");
        this.languageSpecificPrimitives.add("DateTime");
        this.languageSpecificPrimitives.add("BOOLEAN");
        this.languageSpecificPrimitives.add("Array");
        this.languageSpecificPrimitives.add("Hash");
        this.languageSpecificPrimitives.add("File");
        this.languageSpecificPrimitives.add("Object");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("boolean", "BOOLEAN");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Hash");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("UUID", "String");
        Iterator itr = this.cliOptions.iterator();
        while (itr.hasNext()) {
            CliOption opt = (CliOption)itr.next();
            if (!"modelPackage".equals(opt.getOpt()) && !"apiPackage".equals(opt.getOpt())) continue;
            itr.remove();
        }
        this.cliOptions.add(new CliOption(GEM_NAME, "gem name (convention: underscore_case).").defaultValue("swagger_client"));
        this.cliOptions.add(new CliOption(MODULE_NAME, "top module name (convention: CamelCase, usually corresponding to gem name).").defaultValue("SwaggerClient"));
        this.cliOptions.add(new CliOption(GEM_VERSION, "gem version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(GEM_LICENSE, "gem license. ").defaultValue("Apache-2.0"));
        this.cliOptions.add(new CliOption(GEM_HOMEPAGE, "gem homepage. ").defaultValue("http://swagger.io"));
        this.cliOptions.add(new CliOption(GEM_SUMMARY, "gem summary. ").defaultValue("A ruby wrapper for the swagger APIs"));
        this.cliOptions.add(new CliOption(GEM_DESCRIPTION, "gem description. ").defaultValue("This gem maps to a swagger API"));
        this.cliOptions.add(new CliOption(GEM_AUTHOR, "gem author (only one is supported)."));
        this.cliOptions.add(new CliOption(GEM_AUTHOR_EMAIL, "gem author email (only one is supported)."));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(GEM_NAME)) {
            this.setGemName((String)this.additionalProperties.get(GEM_NAME));
        }
        if (this.additionalProperties.containsKey(MODULE_NAME)) {
            this.setModuleName((String)this.additionalProperties.get(MODULE_NAME));
        }
        if (this.gemName == null && this.moduleName == null) {
            this.setGemName("swagger_client");
            this.setModuleName(this.generateModuleName(this.gemName));
        } else if (this.gemName == null) {
            this.setGemName(this.generateGemName(this.moduleName));
        } else if (this.moduleName == null) {
            this.setModuleName(this.generateModuleName(this.gemName));
        }
        this.additionalProperties.put(GEM_NAME, this.gemName);
        this.additionalProperties.put(MODULE_NAME, this.moduleName);
        if (this.additionalProperties.containsKey(GEM_VERSION)) {
            this.setGemVersion((String)this.additionalProperties.get(GEM_VERSION));
        } else {
            this.additionalProperties.put(GEM_VERSION, this.gemVersion);
        }
        if (this.additionalProperties.containsKey(GEM_LICENSE)) {
            this.setGemLicense((String)this.additionalProperties.get(GEM_LICENSE));
        }
        if (this.additionalProperties.containsKey(GEM_HOMEPAGE)) {
            this.setGemHomepage((String)this.additionalProperties.get(GEM_HOMEPAGE));
        }
        if (this.additionalProperties.containsKey(GEM_SUMMARY)) {
            this.setGemSummary((String)this.additionalProperties.get(GEM_SUMMARY));
        }
        if (this.additionalProperties.containsKey(GEM_DESCRIPTION)) {
            this.setGemDescription((String)this.additionalProperties.get(GEM_DESCRIPTION));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR)) {
            this.setGemAuthor((String)this.additionalProperties.get(GEM_AUTHOR));
        }
        if (this.additionalProperties.containsKey(GEM_AUTHOR_EMAIL)) {
            this.setGemAuthorEmail((String)this.additionalProperties.get(GEM_AUTHOR_EMAIL));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.setModelPackage("models");
        this.setApiPackage("api");
        this.supportingFiles.add(new SupportingFile("gemspec.mustache", "", this.gemName + ".gemspec"));
        this.supportingFiles.add(new SupportingFile("gem.mustache", this.libFolder, this.gemName + ".rb"));
        String gemFolder = this.libFolder + File.separator + this.gemName;
        this.supportingFiles.add(new SupportingFile("api_client.mustache", gemFolder, "api_client.rb"));
        this.supportingFiles.add(new SupportingFile("api_error.mustache", gemFolder, "api_error.rb"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", gemFolder, "configuration.rb"));
        this.supportingFiles.add(new SupportingFile("version.mustache", gemFolder, "version.rb"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("LICENSE", "", "LICENSE"));
        this.writeOptional(this.outputFolder, new SupportingFile("rspec.mustache", "", ".rspec"));
        this.writeOptional(this.outputFolder, new SupportingFile("spec_helper.mustache", this.specFolder, "spec_helper.rb"));
        this.writeOptional(this.outputFolder, new SupportingFile("configuration_spec.mustache", this.specFolder, "configuration_spec.rb"));
        this.writeOptional(this.outputFolder, new SupportingFile("api_client_spec.mustache", this.specFolder, "api_client_spec.rb"));
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        CodegenParameter lastRequired = null;
        CodegenParameter lastOptional = null;
        for (CodegenParameter p : op.allParams) {
            if (p.required != null && p.required.booleanValue()) {
                lastRequired = p;
                continue;
            }
            lastOptional = p;
        }
        for (CodegenParameter p : op.allParams) {
            if (p == lastRequired) {
                p.vendorExtensions.put("x-codegen-hasMoreRequired", false);
                continue;
            }
            if (p == lastOptional) {
                p.vendorExtensions.put("x-codegen-hasMoreOptional", false);
                continue;
            }
            p.vendorExtensions.put("x-codegen-hasMoreRequired", true);
            p.vendorExtensions.put("x-codegen-hasMoreOptional", true);
        }
        op.vendorExtensions.put("x-codegen-hasRequiredParams", lastRequired != null);
        return op;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ruby";
    }

    @Override
    public String getHelp() {
        return "Generates a Ruby client library.";
    }

    public String generateModuleName(String gemName) {
        return RubyClientCodegen.camelize(gemName.replaceAll("[^\\w]+", "_"));
    }

    public String generateGemName(String moduleName) {
        return RubyClientCodegen.underscore(moduleName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.libFolder + File.separator + this.gemName + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.apiPackage.replace("/", File.separator);
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.specFolder + File.separator + this.modelPackage.replace("/", File.separator);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Property p) {
        StringProperty sp;
        if (p instanceof IntegerProperty) {
            IntegerProperty dp = (IntegerProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (p instanceof FloatProperty) {
            FloatProperty dp = (FloatProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty bp = (BooleanProperty)p;
            if (bp.getDefault() != null) {
                return bp.getDefault().toString();
            }
        } else if (p instanceof StringProperty && (sp = (StringProperty)p).getDefault() != null) {
            return "\"" + this.escapeText(sp.getDefault()) + "\"";
        }
        return null;
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = RubyClientCodegen.underscore(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String modelName = RubyClientCodegen.camelize("Model" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + RubyClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return RubyClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String filename = RubyClientCodegen.underscore("model_" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + filename);
            return filename;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + RubyClientCodegen.underscore("model_" + name));
            name = "model_" + name;
        }
        return RubyClientCodegen.underscore(name);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return RubyClientCodegen.underscore(name) + "_api";
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_spec";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + "_spec";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return RubyClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if ("Integer".equals(datatype) || "Float".equals(datatype)) {
            String varName = new String(name);
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(RubyClientCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "N" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = RubyClientCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        enumName = enumName.replaceFirst("^_", "");
        if ((enumName = enumName.replaceFirst("_$", "")).matches("\\d.*")) {
            return "N" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            operationId = RubyClientCodegen.underscore("empty_method_name_" + emptyMethodNameCounter++);
            LOGGER.warn("Empty method name (operationId) found. Renamed to " + operationId);
            return operationId;
        }
        if (this.isReservedWord(operationId)) {
            String newOperationId = RubyClientCodegen.underscore("call_" + operationId);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return RubyClientCodegen.underscore(this.sanitizeName(operationId));
    }

    @Override
    public String toApiImport(String name) {
        return this.gemName + "/" + this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equals(type)) {
            if (example == null) {
                example = "true";
            }
        } else if ("File".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "File.new(\"" + this.escapeText(example) + "\")";
        } else if ("Date".equals(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "Date.parse(\"" + this.escapeText(example) + "\")";
        } else if ("DateTime".equals(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "DateTime.parse(\"" + this.escapeText(example) + "\")";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = this.moduleName + "::" + type + ".new";
        }
        if (example == null) {
            example = "nil";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "[" + example + "]";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "{'key' => " + example + "}";
        }
        p.example = example;
    }

    public void setGemName(String gemName) {
        this.gemName = gemName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setGemVersion(String gemVersion) {
        this.gemVersion = gemVersion;
    }

    public void setGemDescription(String gemDescription) {
        this.gemDescription = gemDescription;
    }

    public void setGemSummary(String gemSummary) {
        this.gemSummary = gemSummary;
    }

    public void setGemLicense(String gemLicense) {
        this.gemLicense = gemLicense;
    }

    public void setGemHomepage(String gemHomepage) {
        this.gemHomepage = gemHomepage;
    }

    public void setGemAuthor(String gemAuthor) {
        this.gemAuthor = gemAuthor;
    }

    public void setGemAuthorEmail(String gemAuthorEmail) {
        this.gemAuthorEmail = gemAuthorEmail;
    }

    @Override
    public boolean shouldOverwrite(String filename) {
        return !this.skipOverwrite || !new File(filename).exists();
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin");
    }
}

