/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CppRestClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String DECLSPEC = "declspec";
    public static final String DEFAULT_INCLUDE = "defaultInclude";
    protected String packageVersion = "1.0.0";
    protected String declspec = "";
    protected String defaultInclude = "";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "cpprest";
    }

    @Override
    public String getHelp() {
        return "Generates a C++ API client with C++ REST SDK (https://github.com/Microsoft/cpprestsdk).";
    }

    public CppRestClientCodegen() {
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.model";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.templateDir = "cpprest";
        this.embeddedTemplateDir = "cpprest";
        this.cliOptions.clear();
        this.addOption("modelPackage", "C++ namespace for models (convention: name.space.model).", this.modelPackage);
        this.addOption("apiPackage", "C++ namespace for apis (convention: name.space.api).", this.apiPackage);
        this.addOption("packageVersion", "C++ package version.", this.packageVersion);
        this.addOption(DECLSPEC, "C++ preprocessor to place before the class name for handling dllexport/dllimport.", this.declspec);
        this.addOption(DEFAULT_INCLUDE, "The default include statement that should be placed in all headers for including things like the declspec (convention: #include \"Commons.h\" ", this.defaultInclude);
        this.reservedWords = new HashSet();
        this.supportingFiles.add(new SupportingFile("modelbase-header.mustache", "", "ModelBase.h"));
        this.supportingFiles.add(new SupportingFile("modelbase-source.mustache", "", "ModelBase.cpp"));
        this.supportingFiles.add(new SupportingFile("apiclient-header.mustache", "", "ApiClient.h"));
        this.supportingFiles.add(new SupportingFile("apiclient-source.mustache", "", "ApiClient.cpp"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-header.mustache", "", "ApiConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("apiconfiguration-source.mustache", "", "ApiConfiguration.cpp"));
        this.supportingFiles.add(new SupportingFile("apiexception-header.mustache", "", "ApiException.h"));
        this.supportingFiles.add(new SupportingFile("apiexception-source.mustache", "", "ApiException.cpp"));
        this.supportingFiles.add(new SupportingFile("ihttpbody-header.mustache", "", "IHttpBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-header.mustache", "", "JsonBody.h"));
        this.supportingFiles.add(new SupportingFile("jsonbody-source.mustache", "", "JsonBody.cpp"));
        this.supportingFiles.add(new SupportingFile("httpcontent-header.mustache", "", "HttpContent.h"));
        this.supportingFiles.add(new SupportingFile("httpcontent-source.mustache", "", "HttpContent.cpp"));
        this.supportingFiles.add(new SupportingFile("multipart-header.mustache", "", "MultipartFormData.h"));
        this.supportingFiles.add(new SupportingFile("multipart-source.mustache", "", "MultipartFormData.cpp"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("int", "char", "bool", "long", "float", "double", "int32_t", "int64_t"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("date", "utility::datetime");
        this.typeMapping.put("DateTime", "utility::datetime");
        this.typeMapping.put("string", "utility::string_t");
        this.typeMapping.put("integer", "int32_t");
        this.typeMapping.put("long", "int64_t");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("array", "std::vector");
        this.typeMapping.put("map", "std::map");
        this.typeMapping.put("file", "HttpContent");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("binary", "std::string");
        this.importMapping = new HashMap<String, String>();
        this.importMapping.put("std::vector", "#include <vector>");
        this.importMapping.put("std::map", "#include <map>");
        this.importMapping.put("std::string", "#include <string>");
        this.importMapping.put("HttpContent", "#include \"HttpContent.h\"");
        this.importMapping.put("Object", "#include \"Object.h\"");
        this.importMapping.put("utility::string_t", "#include <cpprest/details/basic_types.h>");
        this.importMapping.put("utility::datetime", "#include <cpprest/details/basic_types.h>");
    }

    protected void addOption(String key, String description, String defaultValue) {
        CliOption option = new CliOption(key, description);
        if (defaultValue != null) {
            option.defaultValue(defaultValue);
        }
        this.cliOptions.add(option);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(DECLSPEC)) {
            this.declspec = this.additionalProperties.get(DECLSPEC).toString();
        }
        if (this.additionalProperties.containsKey(DEFAULT_INCLUDE)) {
            this.defaultInclude = this.additionalProperties.get(DEFAULT_INCLUDE).toString();
        }
        this.additionalProperties.put("modelNamespaceDeclarations", this.modelPackage.split("\\."));
        this.additionalProperties.put("modelNamespace", this.modelPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put("apiNamespaceDeclarations", this.apiPackage.split("\\."));
        this.additionalProperties.put("apiNamespace", this.apiPackage.replaceAll("\\.", "::"));
        this.additionalProperties.put(DECLSPEC, this.declspec);
        this.additionalProperties.put(DEFAULT_INCLUDE, this.defaultInclude);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/model";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/api";
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return "#include \"" + name + ".h\"";
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        Set<String> oldImports = codegenModel.imports;
        codegenModel.imports = new HashSet<String>();
        for (String imp : oldImports) {
            String newImp = this.toModelImport(imp);
            if (newImp.isEmpty()) continue;
            codegenModel.imports.add(newImp);
        }
        return codegenModel;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        Response methodResponse;
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (methodResponse = this.findMethodResponse(operation.getResponses())) != null && methodResponse.getSchema() != null) {
            CodegenProperty cm = this.fromProperty("response", methodResponse.getSchema());
            op.vendorExtensions.put("x-codegen-response", cm);
            if (cm.datatype == "HttpContent") {
                op.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        return op;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (this.isFileProperty(property)) {
            property.vendorExtensions.put("x-codegen-file", true);
        }
    }

    protected boolean isFileProperty(CodegenProperty property) {
        return property.baseType.equals("HttpContent");
    }

    @Override
    public String toModelFilename(String name) {
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<utility::string_t, " + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof StringProperty || p instanceof DateProperty || p instanceof DateTimeProperty || p instanceof FileProperty || this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return "std::shared_ptr<" + swaggerType + ">";
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "U(\"\")";
        }
        if (p instanceof BooleanProperty) {
            return "false";
        }
        if (p instanceof DateProperty) {
            return "utility::datetime()";
        }
        if (p instanceof DateTimeProperty) {
            return "utility::datetime()";
        }
        if (p instanceof DoubleProperty) {
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            return "0.0f";
        }
        if (p instanceof IntegerProperty || p instanceof BaseIntegerProperty) {
            return "0";
        }
        if (p instanceof LongProperty) {
            return "0L";
        }
        if (p instanceof DecimalProperty) {
            return "0.0";
        }
        if (p instanceof MapProperty) {
            MapProperty ap = (MapProperty)p;
            String inner = this.getSwaggerType(ap.getAdditionalProperties());
            return "std::map<utility::string_t, " + inner + ">()";
        }
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            String inner = this.getSwaggerType(ap.getItems());
            if (!this.languageSpecificPrimitives.contains(inner)) {
                inner = "std::shared_ptr<" + inner + ">";
            }
            return "std::vector<" + inner + ">()";
        }
        if (p instanceof RefProperty) {
            RefProperty rp = (RefProperty)p;
            return "new " + this.toModelName(rp.getSimpleRef()) + "()";
        }
        return "nullptr";
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        boolean isString;
        super.postProcessParameter(parameter);
        boolean isPrimitiveType = parameter.isPrimitiveType == Boolean.TRUE;
        boolean isListContainer = parameter.isListContainer == Boolean.TRUE;
        boolean bl = isString = parameter.isString == Boolean.TRUE;
        if (!(isPrimitiveType || isListContainer || isString || parameter.dataType.startsWith("std::shared_ptr"))) {
            parameter.dataType = "std::shared_ptr<" + parameter.dataType + ">";
        }
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        return Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toVarName(String name) {
        if (this.typeMapping.keySet().contains(name) || this.typeMapping.values().contains(name) || this.importMapping.values().contains(name) || this.defaultIncludes.contains(name) || this.languageSpecificPrimitives.contains(name)) {
            return name;
        }
        if (name.length() > 1) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    @Override
    public String toApiName(String type) {
        return Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

