/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class FlashClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String packageName = "io.swagger";
    protected String packageVersion;
    protected String invokerPackage = "io.swagger";
    protected String sourceFolder = "flash";

    public FlashClientCodegen() {
        this.modelPackage = "io.swagger.client.model";
        this.apiPackage = "io.swagger.client.api";
        this.outputFolder = "generated-code" + File.separatorChar + "flash";
        this.modelTemplateFiles.put("model.mustache", ".as");
        this.modelTemplateFiles.put("modelList.mustache", "List.as");
        this.apiTemplateFiles.put("api.mustache", ".as");
        this.templateDir = "flash";
        this.embeddedTemplateDir = "flash";
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("Number");
        this.languageSpecificPrimitives.add("Boolean");
        this.languageSpecificPrimitives.add("String");
        this.languageSpecificPrimitives.add("Date");
        this.languageSpecificPrimitives.add("Array");
        this.languageSpecificPrimitives.add("Dictionary");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Number");
        this.typeMapping.put("float", "Number");
        this.typeMapping.put("long", "Number");
        this.typeMapping.put("double", "Number");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.importMapping = new HashMap();
        this.importMapping.put("File", "flash.filesystem.File");
        this.setReservedWordsLowerCase(Arrays.asList("add", "for", "lt", "tellTarget", "and", "function", "ne", "this", "break", "ge", "new", "typeof", "continue", "gt", "not", "var", "delete", "if", "on", "void", "do", "ifFrameLoaded", "onClipEvent", "while", "else", "in", "or", "with", "eq", "le", "return"));
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "flash package name (convention: package.name)").defaultValue("io.swagger"));
        this.cliOptions.add(new CliOption("packageVersion", "flash package version").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code. e.g. flash"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
            this.apiPackage = this.packageName + ".client.api";
            this.modelPackage = this.packageName + ".client.model";
        } else {
            this.setPackageName("io.swagger");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        String invokerFolder = (this.sourceFolder + File.separator + "src/" + this.invokerPackage + File.separator).replace(".", File.separator).replace('.', File.separatorChar);
        this.supportingFiles.add(new SupportingFile("ApiInvoker.as", invokerFolder + "common", "ApiInvoker.as"));
        this.supportingFiles.add(new SupportingFile("ApiUrlHelper.as", invokerFolder + "common", "ApiUrlHelper.as"));
        this.supportingFiles.add(new SupportingFile("ApiUserCredentials.as", invokerFolder + "common", "ApiUserCredentials.as"));
        this.supportingFiles.add(new SupportingFile("ListWrapper.as", invokerFolder + "common", "ListWrapper.as"));
        this.supportingFiles.add(new SupportingFile("SwaggerApi.as", invokerFolder + "common", "SwaggerApi.as"));
        this.supportingFiles.add(new SupportingFile("XMLWriter.as", invokerFolder + "common", "XMLWriter.as"));
        this.supportingFiles.add(new SupportingFile("ApiError.as", invokerFolder + "exception", "ApiError.as"));
        this.supportingFiles.add(new SupportingFile("ApiErrorCodes.as", invokerFolder + "exception", "ApiErrorCodes.as"));
        this.supportingFiles.add(new SupportingFile("ApiClientEvent.as", invokerFolder + "event", "ApiClientEvent.as"));
        this.supportingFiles.add(new SupportingFile("Response.as", invokerFolder + "event", "Response.as"));
        this.supportingFiles.add(new SupportingFile("build.properties", this.sourceFolder, "build.properties"));
        this.supportingFiles.add(new SupportingFile("build.xml", this.sourceFolder, "build.xml"));
        this.supportingFiles.add(new SupportingFile("README.txt", this.sourceFolder, "README.txt"));
        this.supportingFiles.add(new SupportingFile("ASAXB-0.1.1.swc", this.sourceFolder + File.separatorChar + "lib", "ASAXB-0.1.1.swc"));
        this.supportingFiles.add(new SupportingFile("as3corelib.swc", this.sourceFolder + File.separatorChar + "lib", "as3corelib.swc"));
        this.supportingFiles.add(new SupportingFile("flexunit-4.1.0_RC2-28-flex_3.5.0.12683.swc", this.sourceFolder + File.separator + "lib" + File.separator + "ext", "flexunit-4.1.0_RC2-28-flex_3.5.0.12683.swc"));
        this.supportingFiles.add(new SupportingFile("flexunit-aircilistener-4.1.0_RC2-28-3.5.0.12683.swc", this.sourceFolder + File.separator + "lib" + File.separator + "ext", "flexunit-aircilistener-4.1.0_RC2-28-3.5.0.12683.swc"));
        this.supportingFiles.add(new SupportingFile("flexunit-cilistener-4.1.0_RC2-28-3.5.0.12683.swc", this.sourceFolder + File.separator + "lib" + File.separator + "ext", "flexunit-cilistener-4.1.0_RC2-28-3.5.0.12683.swc"));
        this.supportingFiles.add(new SupportingFile("flexunit-core-flex-4.0.0.2-sdk3.5.0.12683.swc", this.sourceFolder + File.separator + "lib" + File.separator + "ext", "flexunit-core-flex-4.0.0.2-sdk3.5.0.12683.swc"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    private static String dropDots(String str) {
        return str.replaceAll("\\.", "_");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "flash";
    }

    @Override
    public String getHelp() {
        return "Generates a Flash client library.";
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return (this.outputFolder + File.separatorChar + this.sourceFolder + File.separatorChar + "src/" + this.apiPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return (this.outputFolder + File.separatorChar + this.sourceFolder + File.separatorChar + "src/" + this.modelPackage().replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty || p instanceof MapProperty) {
            return this.getSwaggerType(p);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = this.toModelName(swaggerType);
        }
        return type;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            return "null";
        }
        if (p instanceof BooleanProperty) {
            return "false";
        }
        if (p instanceof DateProperty) {
            return "null";
        }
        if (p instanceof DateTimeProperty) {
            return "null";
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            FloatProperty dp = (FloatProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "0.0";
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty dp = (IntegerProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "0";
        }
        if (p instanceof LongProperty) {
            LongProperty dp = (LongProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "0";
        }
        if (p instanceof MapProperty) {
            return "new Dictionary()";
        }
        if (p instanceof ArrayProperty) {
            return "new Array()";
        }
        return "NaN";
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name = FlashClientCodegen.camelize(FlashClientCodegen.dropDots(name), true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + FlashClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return FlashClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return FlashClientCodegen.dropDots(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return FlashClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return FlashClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toApiVarName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        return FlashClientCodegen.camelize(name) + "Api";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + FlashClientCodegen.underscore(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return FlashClientCodegen.underscore(operationId);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

