/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTypeScriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String UNDEFINED_VALUE = "undefined";
    protected String modelPropertyNaming = "camelCase";
    protected Boolean supportsES6 = true;
    protected HashSet<String> languageGenericTypes;

    public AbstractTypeScriptClientCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.setReservedWordsLowerCase(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "Array", "Date", "number", "any", "File", "Error", "Map"));
        this.languageGenericTypes = new HashSet<String>(Arrays.asList("Array"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "any");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("File", "any");
        this.typeMapping.put("Error", "Error");
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
        this.cliOptions.add(new CliOption("supportsES6", "Generate code that conforms to ES6.").defaultValue("false"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        if (this.additionalProperties.containsKey("supportsES6")) {
            this.setSupportsES6(Boolean.valueOf(this.additionalProperties.get("supportsES6").toString()));
            this.additionalProperties.put("supportsES6", this.getSupportsES6());
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String modelName = AbstractTypeScriptClientCodegen.camelize("model_" + name);
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = AbstractTypeScriptClientCodegen.camelize("model_" + name);
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(name)) {
            String modelName = AbstractTypeScriptClientCodegen.camelize("model_" + name);
            LOGGER.warn(name + " (model name matches existing language type) cannot be used as a model name. Renamed to " + modelName);
            return modelName;
        }
        return AbstractTypeScriptClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (p instanceof FileProperty) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            if (sp.getDefault() != null) {
                return "\"" + sp.getDefault() + "\"";
            }
            return UNDEFINED_VALUE;
        }
        if (p instanceof BooleanProperty) {
            return UNDEFINED_VALUE;
        }
        if (p instanceof DateProperty) {
            return UNDEFINED_VALUE;
        }
        if (p instanceof DateTimeProperty) {
            return UNDEFINED_VALUE;
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (p instanceof FloatProperty) {
            FloatProperty fp = (FloatProperty)p;
            if (fp.getDefault() != null) {
                return fp.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty ip = (IntegerProperty)p;
            if (ip.getDefault() != null) {
                return ip.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (p instanceof LongProperty) {
            LongProperty lp = (LongProperty)p;
            if (lp.getDefault() != null) {
                return lp.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        return UNDEFINED_VALUE;
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            return this.escapeReservedWord(AbstractTypeScriptClientCodegen.camelize(this.sanitizeName(operationId), true));
        }
        return AbstractTypeScriptClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return AbstractTypeScriptClientCodegen.camelize(name, true);
            }
            case PascalCase: {
                return AbstractTypeScriptClientCodegen.camelize(name);
            }
            case snake_case: {
                return AbstractTypeScriptClientCodegen.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return AbstractTypeScriptClientCodegen.camelize(this.getSymbolName(name));
        }
        if ("number".equals(datatype)) {
            String varName = "NUMBER_" + name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = AbstractTypeScriptClientCodegen.camelize(enumName)).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name) + "Enum";
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + "." + var.enumName);
            }
        }
        return objs;
    }

    public void setSupportsES6(Boolean value) {
        this.supportsES6 = value;
    }

    public Boolean getSupportsES6() {
        return this.supportsES6;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

