/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractJavaCodegen;
import io.swagger.models.HttpMethod;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVertXServerCodegen
extends AbstractJavaCodegen {
    protected String resourceFolder = "src/main/resources";
    protected String rootPackage = "io.swagger.server.api";
    protected String apiVersion = "1.0.0-SNAPSHOT";
    public static final String ROOT_PACKAGE = "rootPackage";
    public static final String RX_INTERFACE_OPTION = "rxInterface";
    public static final String VERTX_SWAGGER_ROUTER_VERSION_OPTION = "vertxSwaggerRouterVersion";

    public JavaVertXServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + "javaVertXServer";
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiVerticle.mustache", "Verticle.java");
        this.apiTemplateFiles.put("apiException.mustache", "Exception.java");
        this.templateDir = "JavaVertXServer";
        this.embeddedTemplateDir = "JavaVertXServer";
        this.apiPackage = this.rootPackage + ".verticle";
        this.modelPackage = this.rootPackage + ".model";
        this.additionalProperties.put(ROOT_PACKAGE, this.rootPackage);
        this.groupId = "io.swagger";
        this.artifactId = "swagger-java-vertx-server";
        this.artifactVersion = this.apiVersion;
        this.setDateLibrary("java8");
        this.cliOptions.add(CliOption.newBoolean(RX_INTERFACE_OPTION, "When specified, API interfaces are generated with RX and methods return Single<> and Comparable."));
        this.cliOptions.add(CliOption.newString(VERTX_SWAGGER_ROUTER_VERSION_OPTION, "Specify the version of the swagger router library"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-vertx";
    }

    @Override
    public String getHelp() {
        return "Generates a java-Vert.X Server library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiTestTemplateFiles.clear();
        this.importMapping.remove("JsonCreator");
        this.importMapping.remove("com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonInclude", "com.fasterxml.jackson.annotation.JsonInclude");
        this.importMapping.put("JsonProperty", "com.fasterxml.jackson.annotation.JsonProperty");
        this.importMapping.put("JsonValue", "com.fasterxml.jackson.annotation.JsonValue");
        this.importMapping.put("MainApiException", this.rootPackage + ".MainApiException");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("swagger.mustache", this.resourceFolder, "swagger.json"));
        this.supportingFiles.add(new SupportingFile("MainApiVerticle.mustache", this.sourceFolder + File.separator + this.rootPackage.replace(".", File.separator), "MainApiVerticle.java"));
        this.supportingFiles.add(new SupportingFile("MainApiException.mustache", this.sourceFolder + File.separator + this.rootPackage.replace(".", File.separator), "MainApiException.java"));
        this.writeOptional(this.outputFolder, new SupportingFile("vertx-default-jul-logging.mustache", this.resourceFolder, "vertx-default-jul-logging.properties"));
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!model.isEnum) {
            model.imports.add("JsonInclude");
            model.imports.add("JsonProperty");
            if (model.hasEnums) {
                model.imports.add("JsonValue");
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map<String, Object> newObjs = super.postProcessOperations(objs);
        Map operations = (Map)newObjs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                operation.httpMethod = operation.httpMethod.toLowerCase();
                if ("Void".equalsIgnoreCase(operation.returnType)) {
                    operation.returnType = null;
                }
                if (!operation.getHasPathParams()) continue;
                operation.path = this.camelizePath(operation.path);
            }
        }
        return newObjs;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Model> definitions, Swagger swagger) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, definitions, swagger);
        codegenOperation.imports.add("MainApiException");
        return codegenOperation;
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        return codegenModel;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        super.preprocessSwagger(swagger);
        String swaggerDef = Json.pretty((Object)swagger);
        this.additionalProperties.put("fullSwagger", swaggerDef);
        String host = swagger.getHost();
        String port = this.extractPortFromHost(host);
        this.additionalProperties.put("serverPort", port);
        this.artifactVersion = swagger.getInfo() != null && swagger.getInfo().getVersion() != null ? (this.apiVersion = swagger.getInfo().getVersion()) : this.apiVersion;
        Map paths = swagger.getPaths();
        if (paths != null) {
            for (Map.Entry entry : paths.entrySet()) {
                this.manageOperationNames((Path)entry.getValue(), (String)entry.getKey());
            }
        }
        this.additionalProperties.remove("gson");
    }

    private void manageOperationNames(Path path, String pathname) {
        Map operationMap = path.getOperationMap();
        if (operationMap != null) {
            for (Map.Entry<HttpMethod, Operation> entry : operationMap.entrySet()) {
                String serviceIdTemp = this.computeServiceId(pathname, entry);
                entry.getValue().setVendorExtension("x-serviceid", (Object)serviceIdTemp);
                entry.getValue().setVendorExtension("x-serviceid-varname", (Object)(serviceIdTemp.toUpperCase() + "_SERVICE_ID"));
            }
        }
    }

    private String computeServiceId(String pathname, Map.Entry<HttpMethod, Operation> entry) {
        String operationId = entry.getValue().getOperationId();
        return operationId != null ? operationId : entry.getKey().name() + pathname.replaceAll("-", "_").replaceAll("/", "_").replaceAll("[{}]", "");
    }

    protected String extractPortFromHost(String host) {
        int portSeparatorIndex;
        if (host != null && (portSeparatorIndex = host.indexOf(58)) >= 0 && portSeparatorIndex + 1 < host.length()) {
            return host.substring(portSeparatorIndex + 1);
        }
        return "8080";
    }

    private String camelizePath(String path) {
        String word = path;
        Pattern pattern = Pattern.compile("\\{([^/]*)\\}");
        Matcher matcher = pattern.matcher(word);
        while (matcher.find()) {
            word = matcher.replaceFirst(":" + matcher.group(1));
            matcher = pattern.matcher(word);
        }
        pattern = Pattern.compile("(_)(.)");
        matcher = pattern.matcher(word);
        while (matcher.find()) {
            word = matcher.replaceFirst(matcher.group(2).toUpperCase());
            matcher = pattern.matcher(word);
        }
        return word;
    }
}

