/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.mustache.CamelCaseLambda;
import io.swagger.codegen.mustache.IndentedLambda;
import io.swagger.codegen.mustache.LowercaseLambda;
import io.swagger.codegen.mustache.TitlecaseLambda;
import io.swagger.codegen.mustache.UppercaseLambda;
import io.swagger.codegen.utils.ModelUtils;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCSharpCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected boolean optionalAssemblyInfoFlag = true;
    protected boolean optionalProjectFileFlag = true;
    protected boolean optionalEmitDefaultValue = false;
    protected boolean optionalMethodArgumentFlag = true;
    protected boolean useDateTimeOffsetFlag = false;
    protected boolean useCollection = false;
    protected boolean returnICollection = false;
    protected boolean preserveNewLines = false;
    protected boolean netCoreProjectFileFlag = false;
    protected String modelPropertyNaming = CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.PascalCase.name();
    protected String packageVersion = "1.0.0";
    protected String packageName = "IO.Swagger";
    protected String packageTitle = "Swagger Library";
    protected String packageProductName = "SwaggerLibrary";
    protected String packageDescription = "A library generated from a Swagger doc";
    protected String packageCompany = "Swagger";
    protected String packageCopyright = "No Copyright";
    protected String packageAuthors = "Swagger";
    protected String interfacePrefix = "I";
    protected String sourceFolder;
    protected String testFolder = this.sourceFolder = "src";
    protected Set<String> collectionTypes;
    protected Set<String> mapTypes;
    protected Logger LOGGER = LoggerFactory.getLogger(AbstractCSharpCodegen.class);

    public AbstractCSharpCodegen() {
        this.supportsInheritance = true;
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.embeddedTemplateDir = this.templateDir = this.getName();
        this.collectionTypes = new HashSet<String>(Arrays.asList("IList", "List", "ICollection", "Collection", "IEnumerable"));
        this.mapTypes = new HashSet<String>(Arrays.asList("IDictionary"));
        this.reservedWords.addAll(Arrays.asList("Client", "client", "parameter", "File", "file", "localVarPath", "localVarPathParams", "localVarQueryParams", "localVarHeaderParams", "localVarFormParams", "localVarFileParams", "localVarStatusCode", "localVarResponse", "localVarPostBody", "localVarHttpHeaderAccepts", "localVarHttpHeaderAccept", "localVarHttpContentTypes", "localVarHttpContentType", "localVarStatusCode", "abstract", "as", "base", "bool", "break", "byte", "case", "catch", "char", "checked", "class", "const", "continue", "decimal", "default", "delegate", "do", "double", "else", "enum", "event", "explicit", "extern", "false", "finally", "fixed", "float", "for", "foreach", "goto", "if", "implicit", "in", "int", "interface", "internal", "is", "lock", "long", "namespace", "new", "null", "object", "operator", "out", "override", "params", "private", "protected", "public", "readonly", "ref", "return", "sbyte", "sealed", "short", "sizeof", "stackalloc", "static", "string", "struct", "switch", "this", "throw", "true", "try", "typeof", "uint", "ulong", "unchecked", "unsafe", "ushort", "using", "virtual", "void", "volatile", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "string", "bool?", "double?", "decimal?", "int?", "long?", "float?", "byte[]", "ICollection", "Collection", "List", "Dictionary", "DateTime?", "DateTimeOffset?", "String", "Boolean", "Double", "Int32", "Int64", "Float", "Guid?", "System.IO.Stream", "Object"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("list", "List");
        this.instantiationTypes.put("map", "Dictionary");
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "string");
        this.typeMapping.put("binary", "byte[]");
        this.typeMapping.put("bytearray", "byte[]");
        this.typeMapping.put("boolean", "bool?");
        this.typeMapping.put("integer", "int?");
        this.typeMapping.put("float", "float?");
        this.typeMapping.put("long", "long?");
        this.typeMapping.put("double", "double?");
        this.typeMapping.put("number", "decimal?");
        this.typeMapping.put("datetime", "DateTime?");
        this.typeMapping.put("date", "DateTime?");
        this.typeMapping.put("file", "System.IO.Stream");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("list", "List");
        this.typeMapping.put("map", "Dictionary");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("uuid", "Guid?");
    }

    public void setReturnICollection(boolean returnICollection) {
        this.returnICollection = returnICollection;
    }

    public void setOptionalEmitDefaultValue(boolean optionalEmitDefaultValue) {
        this.optionalEmitDefaultValue = optionalEmitDefaultValue;
    }

    public void setUseCollection(boolean useCollection) {
        this.useCollection = useCollection;
        if (useCollection) {
            this.typeMapping.put("array", "Collection");
            this.typeMapping.put("list", "Collection");
            this.instantiationTypes.put("array", "Collection");
            this.instantiationTypes.put("list", "Collection");
        }
    }

    public void setOptionalMethodArgumentFlag(boolean flag) {
        this.optionalMethodArgumentFlag = flag;
    }

    public void setNetCoreProjectFileFlag(boolean flag) {
        this.netCoreProjectFileFlag = flag;
    }

    public void useDateTimeOffset(boolean flag) {
        this.useDateTimeOffsetFlag = flag;
        if (flag) {
            this.typeMapping.put("datetime", "DateTimeOffset?");
        } else {
            this.typeMapping.put("datetime", "DateTime?");
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        } else {
            this.additionalProperties.put("sourceFolder", this.sourceFolder);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.LOGGER.warn(String.format("%s is not used by C# generators. Please use %s", "invokerPackage", "packageName"));
        }
        if (this.additionalProperties.containsKey("packageTitle")) {
            this.setPackageTitle((String)this.additionalProperties.get("packageTitle"));
        } else {
            this.additionalProperties.put("packageTitle", this.packageTitle);
        }
        if (this.additionalProperties.containsKey("packageProductName")) {
            this.setPackageProductName((String)this.additionalProperties.get("packageProductName"));
        } else {
            this.additionalProperties.put("packageProductName", this.packageProductName);
        }
        if (this.additionalProperties.containsKey("packageDescription")) {
            this.setPackageDescription((String)this.additionalProperties.get("packageDescription"));
        } else {
            this.additionalProperties.put("packageDescription", this.packageDescription);
        }
        if (this.additionalProperties.containsKey("packageCompany")) {
            this.setPackageCompany((String)this.additionalProperties.get("packageCompany"));
        } else {
            this.additionalProperties.put("packageCompany", this.packageCompany);
        }
        if (this.additionalProperties.containsKey("packageCopyright")) {
            this.setPackageCopyright((String)this.additionalProperties.get("packageCopyright"));
        } else {
            this.additionalProperties.put("packageCopyright", this.packageCopyright);
        }
        if (this.additionalProperties.containsKey("packageAuthors")) {
            this.setPackageAuthors((String)this.additionalProperties.get("packageAuthors"));
        } else {
            this.additionalProperties.put("packageAuthors", this.packageAuthors);
        }
        if (this.additionalProperties.containsKey("useDateTimeOffset")) {
            this.useDateTimeOffset(this.convertPropertyToBooleanAndWriteBack("useDateTimeOffset"));
        } else {
            this.additionalProperties.put("useDateTimeOffset", this.useDateTimeOffsetFlag);
        }
        if (this.additionalProperties.containsKey("useCollection")) {
            this.setUseCollection(this.convertPropertyToBooleanAndWriteBack("useCollection"));
        } else {
            this.additionalProperties.put("useCollection", this.useCollection);
        }
        if (this.additionalProperties.containsKey("returnICollection")) {
            this.setReturnICollection(this.convertPropertyToBooleanAndWriteBack("returnICollection"));
        } else {
            this.additionalProperties.put("returnICollection", this.returnICollection);
        }
        if (this.additionalProperties.containsKey("optionalEmitDefaultValues")) {
            this.setOptionalEmitDefaultValue(this.convertPropertyToBooleanAndWriteBack("optionalEmitDefaultValues"));
        } else {
            this.additionalProperties.put("optionalEmitDefaultValues", this.optionalEmitDefaultValue);
        }
        if (this.additionalProperties.containsKey("netCoreProjectFile")) {
            this.setNetCoreProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("netCoreProjectFile"));
        } else {
            this.additionalProperties.put("netCoreProjectFile", this.netCoreProjectFileFlag);
        }
        if (this.additionalProperties.containsKey("preserveNewlinesInComments")) {
            this.setPreserveNewLines(Boolean.valueOf(this.additionalProperties.get("preserveNewlinesInComments").toString()));
        }
        if (this.additionalProperties.containsKey("interfacePrefix")) {
            String useInterfacePrefix = this.additionalProperties.get("interfacePrefix").toString();
            if ("false".equals(useInterfacePrefix.toLowerCase())) {
                this.setInterfacePrefix("");
            } else if (!"true".equals(useInterfacePrefix.toLowerCase())) {
                this.setInterfacePrefix(this.sanitizeName(useInterfacePrefix));
            }
        }
        this.additionalProperties.put("interfacePrefix", this.interfacePrefix);
        this.addMustacheLambdas(this.additionalProperties);
    }

    private void addMustacheLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"lowercase", (Object)new LowercaseLambda().generator(this)).put((Object)"uppercase", (Object)new UppercaseLambda()).put((Object)"titlecase", (Object)new TitlecaseLambda()).put((Object)"camelcase", (Object)new CamelCaseLambda().generator(this)).put((Object)"camelcase_param", (Object)new CamelCaseLambda().generator(this).escapeAsParamName(true)).put((Object)"indented", (Object)new IndentedLambda()).put((Object)"indented_8", (Object)new IndentedLambda(8, " ")).put((Object)"indented_12", (Object)new IndentedLambda(12, " ")).put((Object)"indented_16", (Object)new IndentedLambda(16, " ")).build();
        if (objs.containsKey("lambda")) {
            this.LOGGER.warn("An property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'. You'll likely need to use a custom template, see https://github.com/swagger-api/swagger-codegen#modifying-the-client-library-format. ");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                if (!var.name.equalsIgnoreCase(cm.name)) continue;
                var.name = "_" + var.name;
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> processed = super.postProcessAllModels(objs);
        this.postProcessEnumRefs(processed);
        return processed;
    }

    private void postProcessEnumRefs(Map<String, Object> models) {
        HashMap<String, CodegenModel> enumRefs = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            CodegenModel model = ModelUtils.getModelByName(entry.getKey(), models);
            if (!model.isEnum) continue;
            enumRefs.put(entry.getKey(), model);
        }
        for (Map.Entry<String, Object> entry : models.entrySet()) {
            String swaggerName = entry.getKey();
            CodegenModel model = ModelUtils.getModelByName(swaggerName, models);
            if (model != null) {
                for (CodegenProperty var : model.allVars) {
                    if (!enumRefs.containsKey(var.datatype)) continue;
                    CodegenModel refModel = (CodegenModel)enumRefs.get(var.datatype);
                    var.allowableValues = new HashMap<String, Object>(refModel.allowableValues);
                    var.isEnum = true;
                    this.updateCodegenPropertyEnum(var);
                    var.isPrimitiveType = true;
                }
                if (!model.isEnum) continue;
                Boolean isString = false;
                Boolean isInteger = false;
                Boolean isLong = false;
                Boolean isByte = false;
                if (model.dataType.startsWith("byte")) {
                    isByte = true;
                    model.vendorExtensions.put("x-enum-byte", true);
                } else if (model.dataType.startsWith("int32")) {
                    isInteger = true;
                    model.vendorExtensions.put("x-enum-integer", true);
                } else if (model.dataType.startsWith("int64")) {
                    isLong = true;
                    model.vendorExtensions.put("x-enum-long", true);
                } else {
                    isString = true;
                    model.vendorExtensions.put("x-enum-string", true);
                }
                ArrayList enumVars = (ArrayList)model.allowableValues.get("enumVars");
                ArrayList newEnumVars = new ArrayList();
                for (Map enumVar : enumVars) {
                    HashMap<String, Boolean> mixedVars = new HashMap<String, Boolean>();
                    mixedVars.putAll(enumVar);
                    mixedVars.put("isString", isString);
                    mixedVars.put("isLong", isLong);
                    mixedVars.put("isInteger", isInteger);
                    mixedVars.put("isByte", isByte);
                    newEnumVars.add(mixedVars);
                }
                if (newEnumVars.isEmpty()) continue;
                model.allowableValues.put("enumVars", newEnumVars);
                continue;
            }
            this.LOGGER.warn("Expected to retrieve model %s by name, but no model was found. Check your -Dmodels inclusions.", (Object)swaggerName);
        }
    }

    @Override
    public CodegenModel fromModel(String name, Model model, Map<String, Model> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, model, allDefinitions);
        if (this.typeMapping.containsKey(name.toLowerCase()) && this.isReservedWord(name)) {
            this.typeMapping.remove(name.toLowerCase());
        }
        return codegenModel;
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        if (var.vendorExtensions == null) {
            var.vendorExtensions = new HashMap<String, Object>();
        }
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum) {
            if ("byte".equals(var.dataFormat)) {
                var.vendorExtensions.put("x-enum-byte", true);
                var.isString = false;
                var.isLong = false;
                var.isInteger = false;
            } else if ("int32".equals(var.dataFormat)) {
                var.isInteger = true;
                var.isString = false;
                var.isLong = false;
            } else if ("int64".equals(var.dataFormat)) {
                var.isLong = true;
                var.isString = false;
                var.isInteger = false;
            } else {
                var.isString = true;
                var.isInteger = false;
                var.isLong = false;
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        super.postProcessOperations(objs);
        if (objs != null) {
            boolean hasAuthMethods = false;
            Map operations = (Map)objs.get("operations");
            if (operations != null) {
                List ops = (List)operations.get("operation");
                for (CodegenOperation operation : ops) {
                    if (operation.returnType != null) {
                        int namespaceEnd = operation.returnType.lastIndexOf(".");
                        String typeMapping = namespaceEnd > 0 ? operation.returnType.substring(namespaceEnd) : operation.returnType;
                        if (this.collectionTypes.contains(typeMapping)) {
                            int genericStart;
                            operation.isListContainer = true;
                            operation.returnContainer = operation.returnType;
                            if (this.returnICollection && (typeMapping.startsWith("List") || typeMapping.startsWith("Collection")) && (genericStart = typeMapping.indexOf("<")) > 0) {
                                operation.returnType = "ICollection" + typeMapping.substring(genericStart);
                            }
                        } else {
                            operation.returnContainer = operation.returnType;
                            operation.isMapContainer = this.mapTypes.contains(typeMapping);
                        }
                    }
                    if (operation.examples != null) {
                        for (Map<String, String> example : operation.examples) {
                            for (Map.Entry<String, String> entry : example.entrySet()) {
                                String val = entry.getValue().replace("\"", "\\\"").replace("\r", "\\r").replace("\n", "\\n");
                                entry.setValue(val);
                            }
                        }
                    }
                    this.processOperation(operation);
                    if (!operation.hasAuthMethods) continue;
                    hasAuthMethods = true;
                }
            }
            objs.put("hasAuthMethods", hasAuthMethods);
        }
        return objs;
    }

    protected void processOperation(CodegenOperation operation) {
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + this.modelPackage();
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            this.LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + AbstractCSharpCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return AbstractCSharpCodegen.camelize(this.sanitizeName(operationId));
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        name = this.sanitizeName(name);
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = AbstractCSharpCodegen.camelize(name, true)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toExampleValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getExample() != null) {
                return "\"" + dp.getExample().toString() + "\"";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getExample() != null) {
                return dp.getExample().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getExample() != null) {
                    return dp2.getExample().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getExample() != null) {
                    return dp3.getExample().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getExample() != null) {
                    return dp4.getExample().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getExample() != null) {
                return dp.getExample().toString();
            }
        }
        return null;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                String _default = dp.getDefault();
                if (dp.getEnum() == null) {
                    return "\"" + _default + "\"";
                }
                return _default;
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return String.format("%1$sF", dp3.getDefault());
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (swaggerType == null) {
            swaggerType = "";
        }
        if (this.typeMapping.containsKey(swaggerType.toLowerCase())) {
            type = (String)this.typeMapping.get(swaggerType.toLowerCase());
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    private String getArrayTypeDeclaration(ArrayProperty arr) {
        String arrayType = (String)this.typeMapping.get("array");
        StringBuilder instantiationType = new StringBuilder(arrayType);
        Property items = arr.getItems();
        String nestedType = this.getTypeDeclaration(items);
        instantiationType.append("<").append(nestedType).append(">");
        return instantiationType.toString();
    }

    @Override
    public String toInstantiationType(Property p) {
        if (p instanceof ArrayProperty) {
            return this.getArrayTypeDeclaration((ArrayProperty)p);
        }
        return super.toInstantiationType(p);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            return this.getArrayTypeDeclaration((ArrayProperty)p);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<string, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toModelName(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + AbstractCSharpCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return AbstractCSharpCodegen.camelize(name);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + ".Test";
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiName(name) + "Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Tests";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setPackageTitle(String packageTitle) {
        this.packageTitle = packageTitle;
    }

    public void setPackageProductName(String packageProductName) {
        this.packageProductName = packageProductName;
    }

    public void setPackageDescription(String packageDescription) {
        this.packageDescription = packageDescription;
    }

    public void setPackageCompany(String packageCompany) {
        this.packageCompany = packageCompany;
    }

    public void setPackageCopyright(String packageCopyright) {
        this.packageCopyright = packageCopyright;
    }

    public void setPackageAuthors(String packageAuthors) {
        this.packageAuthors = packageAuthors;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public String getInterfacePrefix() {
        return this.interfacePrefix;
    }

    public void setInterfacePrefix(String interfacePrefix) {
        this.interfacePrefix = interfacePrefix;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (datatype.startsWith("int") || datatype.startsWith("long") || datatype.startsWith("byte")) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return AbstractCSharpCodegen.camelize(this.getSymbolName(name));
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = AbstractCSharpCodegen.camelize(enumName) + "Enum").matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(AbstractCSharpCodegen.camelize(property.name)) + "Enum";
    }

    public String testPackageName() {
        return this.packageName + ".Test";
    }

    public boolean isPreserveNewLines() {
        return this.preserveNewLines;
    }

    public void setPreserveNewLines(boolean preserveNewLines) {
        this.preserveNewLines = preserveNewLines;
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        if (this.preserveNewLines) {
            if (swagger.getDefinitions() != null) {
                for (String name : swagger.getDefinitions().keySet()) {
                    ModelImpl impl;
                    Model model = (Model)swagger.getDefinitions().get(name);
                    if (StringUtils.isNotBlank((CharSequence)model.getDescription())) {
                        model.setDescription(this.preserveNewlines(model.getDescription(), 1));
                    }
                    if (!(model instanceof ModelImpl) || (impl = (ModelImpl)model).getProperties() == null) continue;
                    for (String propertyName : impl.getProperties().keySet()) {
                        Property property = (Property)impl.getProperties().get(propertyName);
                        if (!StringUtils.isNotBlank((CharSequence)property.getDescription())) continue;
                        property.setDescription(this.preserveNewlines(property.getDescription(), 2));
                    }
                }
            }
            for (String pathname : swagger.getPaths().keySet()) {
                Path path = (Path)swagger.getPaths().get(pathname);
                for (Operation op : path.getOperations()) {
                    if (StringUtils.isNotBlank((CharSequence)op.getDescription())) {
                        op.setDescription(this.preserveNewlines(op.getDescription(), 2));
                    }
                    if (StringUtils.isNotBlank((CharSequence)op.getSummary())) {
                        op.setSummary(this.preserveNewlines(op.getSummary(), 2));
                    }
                    if (op.getParameters() != null) {
                        for (Parameter param : op.getParameters()) {
                            if (!StringUtils.isNotBlank((CharSequence)param.getDescription())) continue;
                            param.setDescription(this.preserveNewlines(param.getDescription(), 2));
                        }
                    }
                    if (op.getResponses() == null) continue;
                    for (String responseCode : op.getResponses().keySet()) {
                        Response response = (Response)op.getResponses().get(responseCode);
                        if (!StringUtils.isNotBlank((CharSequence)response.getDescription())) continue;
                        response.setDescription(this.preserveNewlines(response.getDescription(), 2));
                    }
                }
            }
        }
    }

    public String preserveNewlines(String input, int tabstops) {
        if (tabstops == 1) {
            return input.replaceAll("\\n", "~~N1");
        }
        return input.replaceAll("\\n", "~~N2");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        String intermediate = input.replace("*/", "*_/").replace("/*", "/_*").replace("--", "- -");
        intermediate = intermediate.replaceAll("~~N1", "\n    /// ");
        intermediate = intermediate.replaceAll("~~N2", "\n        /// ");
        return intermediate;
    }
}

