/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractGoCodegen;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class GoServerCodegen
extends AbstractGoCodegen {
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected String apiPath = "go";

    public GoServerCodegen() {
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.templateDir = "go-server";
        this.embeddedTemplateDir = "go-server";
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("swagger");
        }
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.additionalProperties.put("apiPath", this.apiPath);
        this.additionalProperties.put("packageName", this.packageName);
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "swagger.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.apiPath, "routers.go"));
        this.supportingFiles.add(new SupportingFile("logger.mustache", this.apiPath, "logger.go"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", this.apiPath, "README.md"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String toModelName(String name) {
        return GoServerCodegen.camelize(this.toModelFilename(name));
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + GoServerCodegen.camelize(this.sanitizeName("call_" + operationId)));
            operationId = "call_" + operationId;
        }
        return GoServerCodegen.camelize(operationId);
    }

    @Override
    public String toModelFilename(String name) {
        if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + name;
        }
        if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = this.sanitizeName(name))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + GoServerCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return GoServerCodegen.camelize(name);
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            return String.format("[]%s", this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && GoServerCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return this.getSchemaType(propertySchema) + "[string]" + this.getTypeDeclaration(inner);
        }
        String schemaType = this.getSchemaType(propertySchema);
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.typeMapping.containsValue(schemaType)) {
            return schemaType;
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        return this.toModelName(schemaType);
    }

    @Override
    public String getSchemaType(Schema propertySchema) {
        String swaggerType = super.getSchemaType(propertySchema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return GoServerCodegen.underscore(name);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(GoServerCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = GoServerCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }
}

