/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenConstants;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractScalaCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ScalaLagomServerCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    private String authScheme = "";
    private boolean authPreemptive = false;
    protected String groupId = "io.swagger";
    protected String artifactId = "scala-lagom-server";
    protected String artifactVersion = "1.0.0";

    public ScalaLagomServerCodegen() {
        this.outputFolder = "generated-code/scala-lagom-server";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scala-lagom-server";
        this.embeddedTemplateDir = "scala-lagom-server";
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.model";
        this.setReservedWordsLowerCase(Arrays.asList("path", "contentTypes", "contentType", "queryParams", "headerParams", "formParams", "postBody", "mp", "basePath", "apiInvoker", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.additionalProperties.put("authScheme", this.authScheme);
        this.additionalProperties.put("authPreemptive", this.authPreemptive);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("build.properties.mustache", "", "project/build.properties"));
        this.supportingFiles.add(new SupportingFile("plugins.sbt.mustache", "", "project/plugins.sbt"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.importMapping.put("ListBuffer", "scala.collection.mutable.ListBuffer");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Integer", "Int");
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "Seq");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    private String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return ScalaLagomServerCodegen.camelize(name, true);
            }
            case PascalCase: {
                return ScalaLagomServerCodegen.camelize(name);
            }
            case snake_case: {
                return ScalaLagomServerCodegen.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-lagom-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Lagom API (Beta) in scala";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            throw new RuntimeException(operationId + " (reserved word) cannot be used as method name");
        }
        return ScalaLagomServerCodegen.camelize(operationId, true);
    }

    @Override
    public String toModelName(String name) {
        String sanitizedName = this.sanitizeName(this.modelNamePrefix + name + this.modelNameSuffix);
        String camelizedName = ScalaLagomServerCodegen.camelize(sanitizedName);
        if (this.isReservedWord(camelizedName)) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(camelizedName + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = "Model" + camelizedName;
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        return camelizedName;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            for (CodegenProperty var : cm.vars) {
                boolean isEnum = ExtensionHelper.getBooleanValue(var, "x-is-enum");
                if (!isEnum) continue;
                List enumValues = (List)var.allowableValues.get("values");
                ListIterator<String> i = enumValues.listIterator();
                while (i.hasNext()) {
                    String element = String.valueOf(i.next());
                    i.set(element.replaceAll("^\"|\"$", ""));
                }
            }
        }
        if (this.additionalProperties.containsKey("gson")) {
            List imports = (List)objs.get("imports");
            for (Object _mo : models) {
                Map mo = (Map)_mo;
                CodegenModel cm = (CodegenModel)mo.get("model");
                boolean isEnum = ExtensionHelper.getBooleanValue(cm, "x-is-enum");
                if (!Boolean.TRUE.equals(isEnum) || cm.allowableValues == null) continue;
                cm.imports.add((String)this.importMapping.get("SerializedName"));
                HashMap item = new HashMap();
                item.put("import", this.importMapping.get("SerializedName"));
                imports.add(item);
            }
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        ArrayList oplist = (ArrayList)operations.get("operation");
        for (CodegenOperation codegenOperation : oplist) {
            String path = codegenOperation.path;
            codegenOperation.path = path.replaceAll("\\{", ":").replaceAll("}", "");
        }
        return objs;
    }
}

