/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.examples;

import io.swagger.codegen.examples.XmlExampleGenerator;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ExampleGenerator.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_XML = "application/xml";
    private static final String EXAMPLE = "example";
    private static final String CONTENT_TYPE = "contentType";
    private static final String OUTPUT = "output";
    private static final String NONE = "none";
    private static final String URL = "url";
    private static final String URI = "uri";
    protected Map<String, Schema> examples;
    private Random random;

    public ExampleGenerator(Map<String, Schema> examples) {
        this.examples = examples;
        this.random = new Random("ExampleGenerator".hashCode());
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, Schema property) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (property != null && string.startsWith(MIME_TYPE_JSON)) {
                    example = Json.pretty((Object)this.resolvePropertyToExample("", string, property, processedModels));
                    if (example == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (property == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(property)) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        System.out.println("the size is: " + output.size());
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    public List<Map<String, String>> generate(Map<String, Object> examples, List<String> mediaTypes, String modelName) {
        ArrayList<Map<String, String>> output = new ArrayList<Map<String, String>>();
        HashSet<String> processedModels = new HashSet<String>();
        if (examples == null) {
            if (mediaTypes == null) {
                mediaTypes = Collections.singletonList(MIME_TYPE_JSON);
            }
            for (String string : mediaTypes) {
                String example;
                Schema schema;
                HashMap<String, String> kv = new HashMap<String, String>();
                kv.put(CONTENT_TYPE, string);
                if (modelName != null && string.startsWith(MIME_TYPE_JSON)) {
                    schema = this.examples.get(modelName);
                    if (schema == null || (example = Json.pretty((Object)this.resolveModelToExample(modelName, string, schema, processedModels))) == null) continue;
                    kv.put(EXAMPLE, example);
                    output.add(kv);
                    continue;
                }
                if (modelName == null || !string.startsWith(MIME_TYPE_XML) || (example = new XmlExampleGenerator(this.examples).toXml(schema = this.examples.get(modelName), 0, Collections.emptySet())) == null) continue;
                kv.put(EXAMPLE, example);
                output.add(kv);
            }
        } else {
            for (Map.Entry entry : examples.entrySet()) {
                HashMap kv = new HashMap();
                kv.put(CONTENT_TYPE, entry.getKey());
                kv.put(EXAMPLE, Json.pretty(entry.getValue()));
                output.add(kv);
            }
        }
        if (output.size() == 0) {
            HashMap<String, String> kv = new HashMap<String, String>();
            kv.put(OUTPUT, NONE);
            output.add(kv);
        }
        return output;
    }

    private Object resolvePropertyToExample(String propertyName, String mediaType, Schema property, Set<String> processedModels) {
        logger.debug("Resolving example for property {}...", (Object)property);
        if (property.getExample() != null) {
            logger.debug("Example set in swagger spec, returning example: '{}'", (Object)property.getExample().toString());
            return property.getExample();
        }
        if (property instanceof StringSchema) {
            logger.debug("String property");
            String defaultValue = (String)((StringSchema)property).getDefault();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                logger.debug("Default value found: '{}'", (Object)defaultValue);
                return defaultValue;
            }
            List enumValues = ((StringSchema)property).getEnum();
            if (enumValues != null && !enumValues.isEmpty()) {
                logger.debug("Enum value found: '{}'", enumValues.get(0));
                return enumValues.get(0);
            }
            String format = property.getFormat();
            if (format != null && (URI.equals(format) || URL.equals(format))) {
                logger.debug("URI or URL format, without default or enum, generating random one.");
                return "http://example.com/aeiou";
            }
            logger.debug("No values found, using property name " + propertyName + " as example");
            return propertyName;
        }
        if (property instanceof BooleanSchema) {
            Object defaultValue = property.getDefault();
            if (defaultValue != null) {
                return defaultValue;
            }
            return Boolean.TRUE;
        }
        if (property instanceof ArraySchema) {
            Schema innerType = ((ArraySchema)property).getItems();
            if (innerType != null) {
                int arrayLength = null == ((ArraySchema)property).getMaxItems() ? 2 : ((ArraySchema)property).getMaxItems();
                Object[] objectProperties = new Object[arrayLength];
                Object objProperty = this.resolvePropertyToExample(propertyName, mediaType, innerType, processedModels);
                for (int i = 0; i < arrayLength; ++i) {
                    objectProperties[i] = objProperty;
                }
                return objectProperties;
            }
        } else {
            if (property instanceof DateSchema) {
                return "2000-01-23";
            }
            if (property instanceof DateTimeSchema) {
                return "2000-01-23T04:56:07.000+00:00";
            }
            if (property instanceof NumberSchema) {
                Double max;
                Double min = property.getMinimum() == null ? null : Double.valueOf(property.getMinimum().doubleValue());
                Double d = max = property.getMaximum() == null ? null : Double.valueOf(property.getMaximum().doubleValue());
                if ("float".equals(property.getFormat())) {
                    return Float.valueOf((float)this.randomNumber(min, max));
                }
                return this.randomNumber(min, max);
            }
            if (property instanceof FileSchema) {
                return "";
            }
            if (property instanceof IntegerSchema) {
                Double max;
                Double min = property.getMinimum() == null ? null : Double.valueOf(property.getMinimum().doubleValue());
                Double d = max = property.getMaximum() == null ? null : Double.valueOf(property.getMaximum().doubleValue());
                if ("int32".equals(property.getFormat())) {
                    return (long)this.randomNumber(min, max);
                }
                return (int)this.randomNumber(min, max);
            }
            if (property instanceof MapSchema && property.getAdditionalProperties() != null && property.getAdditionalProperties() instanceof Schema) {
                HashMap<String, Object> mp = new HashMap<String, Object>();
                if (property.getName() != null) {
                    mp.put(property.getName(), this.resolvePropertyToExample(propertyName, mediaType, (Schema)property.getAdditionalProperties(), processedModels));
                } else {
                    mp.put("key", this.resolvePropertyToExample(propertyName, mediaType, (Schema)property.getAdditionalProperties(), processedModels));
                }
                return mp;
            }
            if (property instanceof ObjectSchema) {
                return "{}";
            }
            if (property instanceof UUIDSchema) {
                return "046b6c7f-0b8a-43b9-b35d-6489e6daee91";
            }
        }
        return "";
    }

    private double randomNumber(Double min, Double max) {
        if (min != null && max != null) {
            double range = max - min;
            return this.random.nextDouble() * range + min;
        }
        if (min != null) {
            return this.random.nextDouble() + min;
        }
        if (max != null) {
            return this.random.nextDouble() * max;
        }
        return this.random.nextDouble() * 10.0;
    }

    private Object resolveModelToExample(String name, String mediaType, Schema schema, Set<String> processedModels) {
        if (processedModels.contains(name)) {
            return schema.getExample();
        }
        processedModels.add(name);
        HashMap<String, Object> values = new HashMap<String, Object>();
        logger.debug("Resolving model '{}' to example", (Object)name);
        if (schema.getExample() != null) {
            logger.debug("Using example from spec: {}", schema.getExample());
            return schema.getExample();
        }
        if (schema.getProperties() != null) {
            logger.debug("Creating example from model values");
            for (Object propertyName : schema.getProperties().keySet()) {
                schema.getProperties().get(propertyName.toString());
                values.put(propertyName.toString(), this.resolvePropertyToExample(propertyName.toString(), mediaType, schema, processedModels));
            }
            schema.setExample(values);
        }
        return values;
    }
}

