/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.utils;

import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelUtils {
    public static CodegenModel getModelByName(String name, Map<String, Object> models) {
        Map dataMap;
        Object dataModels;
        Object data = models.get(name);
        if (data instanceof Map && (dataModels = (dataMap = (Map)data).get("models")) instanceof List) {
            List dataModelsList = (List)dataModels;
            for (Object entry : dataModelsList) {
                Map entryMap;
                Object model;
                if (!(entry instanceof Map) || !((model = (entryMap = (Map)entry).get("model")) instanceof CodegenModel)) continue;
                return (CodegenModel)model;
            }
        }
        return null;
    }

    public static Operation[] createOperationArray(PathItem pathItem) {
        return new Operation[]{pathItem.getGet(), pathItem.getPost(), pathItem.getDelete(), pathItem.getHead(), pathItem.getPut(), pathItem.getPatch(), pathItem.getOptions()};
    }

    public static void processCodegenModels(Map<String, CodegenModel> allModels) {
        for (CodegenModel codegenModel : allModels.values()) {
            if (codegenModel.getParent() != null) {
                codegenModel.setParentModel(allModels.get(codegenModel.getParent()));
            }
            if (codegenModel.getInterfaces() == null || codegenModel.getInterfaces().isEmpty()) continue;
            codegenModel.setInterfaceModels(new ArrayList<CodegenModel>(codegenModel.getInterfaces().size()));
            for (String intf : codegenModel.getInterfaces()) {
                CodegenModel intfModel = allModels.get(intf);
                if (intfModel == null) continue;
                codegenModel.getInterfaceModels().add(intfModel);
            }
        }
        for (String name : allModels.keySet()) {
            CodegenModel codegenModel = allModels.get(name);
            CodegenModel parent = allModels.get(codegenModel.getParent());
            while (parent != null) {
                if (parent.getChildren() == null) {
                    parent.setChildren(new ArrayList<CodegenModel>());
                }
                parent.getChildren().add(codegenModel);
                if (parent.getDiscriminator() == null) {
                    parent = allModels.get(parent.parent);
                    continue;
                }
                parent = null;
            }
        }
    }

    public static void processModelEnums(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            boolean isEnum = ExtensionHelper.getBooleanValue(cm, "x-is-enum");
            if (Boolean.TRUE.equals(isEnum) && cm.allowableValues != null) {
                Map<String, Object> allowableValues = cm.allowableValues;
                List values = (List)allowableValues.get("values");
                ArrayList enumVars = new ArrayList();
                String commonPrefix = ModelUtils.findCommonPrefixOfVars(values);
                int truncateIdx = commonPrefix.length();
                for (Object value : values) {
                    String enumName;
                    HashMap<String, String> enumVar = new HashMap<String, String>();
                    if (truncateIdx == 0) {
                        enumName = value.toString();
                    } else {
                        enumName = value.toString().substring(truncateIdx);
                        if ("".equals(enumName)) {
                            enumName = value.toString();
                        }
                    }
                    enumVar.put("name", ModelUtils.toEnumVarName(enumName));
                    enumVar.put("value", ModelUtils.toEnumValue(value.toString(), cm.dataType));
                    enumVars.add(enumVar);
                }
                cm.allowableValues.put("enumVars", enumVars);
            }
            for (CodegenProperty var : cm.vars) {
                ModelUtils.updateCodegenPropertyEnum(var);
            }
        }
    }

    public static String findCommonPrefixOfVars(List<Object> vars) {
        try {
            String[] listStr = vars.toArray(new String[vars.size()]);
            String prefix = StringUtils.getCommonPrefix((String[])listStr);
            return prefix.replaceAll("[a-zA-Z0-9]+\\z", "");
        }
        catch (ArrayStoreException e) {
            return "";
        }
    }

    public static void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.items != null) {
            allowableValues = var.items.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        ArrayList enumVars = new ArrayList();
        String commonPrefix = ModelUtils.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        for (Object value : values) {
            String enumName;
            Map enumVar = new HashMap<String, String>();
            if (truncateIdx == 0) {
                enumName = value.toString();
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            enumVar.put("name", ModelUtils.toEnumVarName(enumName));
            enumVar.put("value", ModelUtils.toEnumValue(value.toString(), var.datatype));
            enumVars.add(enumVar);
        }
        allowableValues.put("enumVars", enumVars);
        if (var.defaultValue != null) {
            String enumName = null;
            for (Map enumVar : enumVars) {
                if (!ModelUtils.toEnumValue(var.defaultValue, var.datatype).equals(enumVar.get("value"))) continue;
                enumName = (String)enumVar.get("name");
                break;
            }
            if (enumName != null) {
                var.defaultValue = String.format("%s.%s", enumName, var.datatypeWithEnum);
            }
        }
    }

    public static String toEnumVarName(String value) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String var = value.replaceAll("\\W+", "_").toUpperCase();
        if (var.matches("\\d.*")) {
            return "_" + var;
        }
        return var;
    }

    private static String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype)) {
            return value;
        }
        value = StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)value).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\").replace("\"", "\\\"");
        return String.format("\"%s\"", value);
    }
}

