/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.ArrayModel;
import io.swagger.models.Car;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Manufacturers;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.ReadOnlyModel;
import io.swagger.models.RefModel;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelSerializerTest {
    private final ObjectMapper m = Json.mapper();

    @Test(description="it should convert a model")
    public void convertModel() throws JsonProcessingException {
        ModelImpl pet = new ModelImpl();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("intValue", new IntegerProperty());
        props.put("longValue", new LongProperty());
        props.put("dateValue", new DateProperty());
        props.put("dateTimeValue", new DateTimeProperty());
        pet.setProperties(props);
        pet.setRequired(Arrays.asList("intValue", "name"));
        String json = "{\n   \"required\":[\n      \"intValue\"\n   ],\n   \"properties\":{\n      \"dateValue\":{\n         \"type\":\"string\",\n         \"format\":\"date\"\n      },\n      \"longValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int64\"\n      },\n      \"dateTimeValue\":{\n         \"type\":\"string\",\n         \"format\":\"date-time\"\n      },\n      \"intValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      }\n   }\n}";
        SerializationMatchers.assertEqualsToJson(pet, "{\n   \"required\":[\n      \"intValue\"\n   ],\n   \"properties\":{\n      \"dateValue\":{\n         \"type\":\"string\",\n         \"format\":\"date\"\n      },\n      \"longValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int64\"\n      },\n      \"dateTimeValue\":{\n         \"type\":\"string\",\n         \"format\":\"date-time\"\n      },\n      \"intValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      }\n   }\n}");
    }

    @Test(description="it should deserialize a model")
    public void deserializeModel() throws IOException {
        String json = "{\n   \"required\":[\n      \"intValue\"\n   ],\n   \"properties\":{\n      \"dateValue\":{\n         \"type\":\"string\",\n         \"format\":\"date\"\n      },\n      \"longValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int64\"\n      },\n      \"dateTimeValue\":{\n         \"type\":\"string\",\n         \"format\":\"date-time\"\n      },\n      \"intValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      },\n      \"byteArrayValue\":{\n         \"type\":\"string\",\n         \"format\":\"binary\"\n      }\n   }\n}";
        Model p = (Model)this.m.readValue("{\n   \"required\":[\n      \"intValue\"\n   ],\n   \"properties\":{\n      \"dateValue\":{\n         \"type\":\"string\",\n         \"format\":\"date\"\n      },\n      \"longValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int64\"\n      },\n      \"dateTimeValue\":{\n         \"type\":\"string\",\n         \"format\":\"date-time\"\n      },\n      \"intValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      },\n      \"byteArrayValue\":{\n         \"type\":\"string\",\n         \"format\":\"binary\"\n      }\n   }\n}", Model.class);
        SerializationMatchers.assertEqualsToJson(p, "{\n   \"required\":[\n      \"intValue\"\n   ],\n   \"properties\":{\n      \"dateValue\":{\n         \"type\":\"string\",\n         \"format\":\"date\"\n      },\n      \"longValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int64\"\n      },\n      \"dateTimeValue\":{\n         \"type\":\"string\",\n         \"format\":\"date-time\"\n      },\n      \"intValue\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      },\n      \"byteArrayValue\":{\n         \"type\":\"string\",\n         \"format\":\"binary\"\n      }\n   }\n}");
    }

    @Test(description="it should serialize an array model")
    public void serializeArrayModel() throws IOException {
        ArrayModel model = new ArrayModel();
        model.setItems((Property)new RefProperty("Pet"));
        Assert.assertEquals((String)this.m.writeValueAsString((Object)model), (String)"{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Pet\"}}");
    }

    @Test(description="it should deserialize an array model")
    public void deserializeArrayModel() throws IOException {
        String json = "{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Pet\"}}";
        Model p = (Model)this.m.readValue("{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Pet\"}}", Model.class);
        Assert.assertTrue((boolean)(p instanceof ArrayModel));
        Assert.assertEquals((String)this.m.writeValueAsString((Object)p), (String)"{\"type\":\"array\",\"items\":{\"$ref\":\"#/definitions/Pet\"}}");
    }

    @Test(description="it should not create an xml object for ref")
    public void shouldNotCreateXmlObjectForRef() throws IOException {
        RefModel model = new RefModel("Monster");
        model.setDescription("oops");
        model.setExternalDocs(new ExternalDocs("external docs", "http://swagger.io"));
        Assert.assertEquals((String)Json.mapper().writeValueAsString((Object)model), (String)"{\"$ref\":\"#/definitions/Monster\"}");
    }

    @Test(description="it should make a field readOnly by annotation")
    public void makeFieldReadOnly() throws IOException {
        Map schemas = ModelConverters.getInstance().read(Car.class);
        String json = "{\n   \"Car\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"wheelCount\":{\n            \"type\":\"integer\",\n            \"format\":\"int32\",\n            \"readOnly\":true\n         }\n      }\n   }\n}";
        SerializationMatchers.assertEqualsToJson(schemas, "{\n   \"Car\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"wheelCount\":{\n            \"type\":\"integer\",\n            \"format\":\"int32\",\n            \"readOnly\":true\n         }\n      }\n   }\n}");
    }

    @Test(description="it should serialize a model with a Set")
    public void serializeModelWithSet() throws IOException {
        Map schemas = ModelConverters.getInstance().read(Manufacturers.class);
        String json = "{\n   \"Manufacturers\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"countries\":{\n            \"type\":\"array\",\n            \"uniqueItems\":true,\n            \"items\":{\n               \"type\":\"string\"\n            }\n         }\n      }\n   }\n}";
        SerializationMatchers.assertEqualsToJson(schemas, "{\n   \"Manufacturers\":{\n      \"type\":\"object\",\n      \"properties\":{\n         \"countries\":{\n            \"type\":\"array\",\n            \"uniqueItems\":true,\n            \"items\":{\n               \"type\":\"string\"\n            }\n         }\n      }\n   }\n}");
    }

    @Test(description="it should deserialize a model with object example")
    public void deserializeModelWithObjectExample() throws IOException {
        String json = "{\n   \"title\":\"Error\",\n   \"type\":\"object\",\n   \"properties\":{\n      \"code\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      },\n      \"message\":{\n         \"type\":\"string\"\n      },\n      \"fields\":{\n         \"type\":\"string\"\n      }\n   },\n   \"example\":{\n      \"code\":1,\n      \"message\":\"hello\",\n      \"fields\":\"abc\"\n   }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue("{\n   \"title\":\"Error\",\n   \"type\":\"object\",\n   \"properties\":{\n      \"code\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\"\n      },\n      \"message\":{\n         \"type\":\"string\"\n      },\n      \"fields\":{\n         \"type\":\"string\"\n      }\n   },\n   \"example\":{\n      \"code\":1,\n      \"message\":\"hello\",\n      \"fields\":\"abc\"\n   }\n}", ModelImpl.class);
        Assert.assertEquals((String)Json.mapper().writeValueAsString(model.getExample()), (String)"{\"code\":1,\"message\":\"hello\",\"fields\":\"abc\"}");
    }

    @Test(description="it should deserialize a model with read-only property")
    public void deserializeModelWithReadOnlyProperty() throws IOException {
        String json = "{\n   \"properties\":{\n      \"id\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\",\n         \"readOnly\":true\n      }\n   }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue("{\n   \"properties\":{\n      \"id\":{\n         \"type\":\"integer\",\n         \"format\":\"int32\",\n         \"readOnly\":true\n      }\n   }\n}", ModelImpl.class);
        Property property = (Property)model.getProperties().get("id");
        Assert.assertTrue((boolean)property.getReadOnly());
    }

    @Test(description="it should generate a JSON with read-only from pojo, #1161")
    public void readOnlyJsonGeneration() throws IOException {
        Map models = ModelConverters.getInstance().read(ReadOnlyModel.class);
        Model model = (Model)models.get("ReadOnlyModel");
        Property id = (Property)model.getProperties().get("id");
        Assert.assertTrue((boolean)id.getReadOnly());
        Property readWriteId = (Property)model.getProperties().get("readWriteId");
        Assert.assertNull((Object)readWriteId.getReadOnly());
    }

    @Test(description="it should generate an integer field with enum")
    public void integerEnumGeneration() throws IOException {
        String json = "{\n   \"properties\":{\n      \"id\":{\n         \"description\":\"fun!\",\n         \"type\":\"integer\",\n         \"format\":\"int32\",\n         \"readOnly\":true,\n         \"enum\": [ 0, 1]\n      }\n   }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue("{\n   \"properties\":{\n      \"id\":{\n         \"description\":\"fun!\",\n         \"type\":\"integer\",\n         \"format\":\"int32\",\n         \"readOnly\":true,\n         \"enum\": [ 0, 1]\n      }\n   }\n}", ModelImpl.class);
        IntegerProperty p = (IntegerProperty)model.getProperties().get("id");
        Assert.assertNotNull((Object)p.getEnum());
        Assert.assertEquals(p.getEnum().get(0), (Object)new Integer(0));
        Assert.assertEquals(p.getEnum().get(1), (Object)new Integer(1));
    }

    @Test(description="it retains enums per ")
    public void testEnumParser() throws IOException {
        String json = "{\n  \"properties\": {\n    \"AdvStateType\": {\n      \"description\": \"Advertising State\",\n      \"enum\": [\n        \"off\",\n        \"on\"\n      ],\n      \"type\": \"string\"\n    }\n  }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        StringProperty p = (StringProperty)model.getProperties().get("AdvStateType");
        Assert.assertNotNull((Object)p.getEnum());
        Assert.assertEquals((String)((String)p.getEnum().get(0)), (String)"off");
        Assert.assertEquals((String)((String)p.getEnum().get(1)), (String)"on");
    }

    @Test
    public void testPrimitiveModel() throws Exception {
        String json = "{\n  \"type\": \"string\",\n  \"enum\": [\n    \"a\",\n    \"b\",\n    \"c\"\n  ]\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Assert.assertNotNull((Object)model.getEnum());
        Assert.assertTrue((model.getEnum().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testIssue1852() throws Exception {
        String json = "{\n  \"type\": \"integer\",\n  \"minimum\": 10,\n  \"maximum\": 20,\n  \"default\": 15\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Assert.assertEquals((int)model.getMinimum().intValue(), (int)10);
        Assert.assertEquals((int)model.getMaximum().intValue(), (int)20);
        Assert.assertEquals((Object)model.getDefaultValue(), (Object)15);
    }

    @Test
    public void testIssue2064Neg() throws Exception {
        String json = "{\n  \"type\": \"string\",\n  \"uniqueItems\": false\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Assert.assertFalse((boolean)model.getUniqueItems());
    }

    @Test
    public void testIssue2064() throws Exception {
        String json = "{\n  \"type\": \"string\",\n  \"uniqueItems\": true\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        Assert.assertTrue((boolean)model.getUniqueItems());
    }

    @Test
    public void testIssue2064Ip() throws Exception {
        String json = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"id\": {\n      \"type\": \"integer\",\n      \"format\": \"int32\",\n      \"multipleOf\": 3.0\n    }\n  }\n}";
        ModelImpl model = (ModelImpl)Json.mapper().readValue(json, ModelImpl.class);
        IntegerProperty ip = (IntegerProperty)model.getProperties().get("id");
        Assert.assertEquals((Object)ip.getMultipleOf(), (Object)new BigDecimal("3.0"));
    }
}

