/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverters;
import io.swagger.util.Json;
import java.math.BigDecimal;
import java.util.Map;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NumericFormatTest {
    @Test
    public void testFormatOfInteger() {
        Map models = ModelConverters.getInstance().readAll(ModelWithIntegerFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)"{\n  \"ModelWithIntegerFields\" : {\n    \"type\" : \"object\",\n    \"properties\" : {\n      \"id\" : {\n        \"type\" : \"integer\",\n        \"format\" : \"int32\",\n        \"minimum\" : 3\n      }\n    }\n  }\n}");
    }

    @Test
    public void testFormatOfDecimal() {
        Map models = ModelConverters.getInstance().readAll(ModelWithDecimalFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)"{\n  \"ModelWithDecimalFields\" : {\n    \"type\" : \"object\",\n    \"properties\" : {\n      \"id\" : {\n        \"type\" : \"number\",\n        \"format\" : \"double\",\n        \"minimum\" : 3.3,\n        \"exclusiveMinimum\" : false\n      }\n    }\n  }\n}");
    }

    @Test
    public void testFormatOfBigDecimal() {
        Map models = ModelConverters.getInstance().readAll(ModelWithoutScientificFields.class);
        Assert.assertEquals((int)models.size(), (int)1);
        String json = Json.pretty((Object)models);
        Assert.assertEquals((String)json, (String)"{\n  \"ModelWithoutScientificFields\" : {\n    \"type\" : \"object\",\n    \"properties\" : {\n      \"id\" : {\n        \"type\" : \"number\",\n        \"minimum\" : -9999999999999999.99,\n        \"maximum\" : 9999999999999999.99,\n        \"exclusiveMinimum\" : false,\n        \"exclusiveMaximum\" : false\n      }\n    }\n  }\n}");
    }

    static class ModelWithoutScientificFields {
        @ApiModelProperty
        @DecimalMin(value="-9999999999999999.99")
        @DecimalMax(value="9999999999999999.99")
        public BigDecimal id;

        ModelWithoutScientificFields() {
        }
    }

    static class ModelWithDecimalFields {
        @ApiModelProperty
        @DecimalMin(value="3.3")
        public Double id;

        ModelWithDecimalFields() {
        }
    }

    static class ModelWithIntegerFields {
        @ApiModelProperty
        @Min(value=3L)
        public Integer id;

        ModelWithIntegerFields() {
        }
    }
}

