/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.properties;

import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Yaml;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ArrayPropertyDeserializerTest {
    private static final String yaml = "      produces:\n        - application/yaml\n      responses:\n        200:\n          description: OK\n          schema:\n            type: array\n            minItems: 3\n            maxItems: 100\n            items:\n              type: string\n            example:\n              - Array example\n              - with two items";

    @Test(description="it should includes the example in the arrayproperty")
    public void testArrayDeserialization() throws Exception {
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property responseSchema = response.getSchema();
        Assert.assertNotNull((Object)responseSchema);
        Assert.assertTrue((boolean)(responseSchema instanceof ArrayProperty));
        ArrayProperty mp = (ArrayProperty)responseSchema;
        Assert.assertNotNull((Object)mp.getExample());
        Assert.assertEquals((Object)mp.getMinItems(), (Object)new Integer(3));
        Assert.assertEquals((Object)mp.getMaxItems(), (Object)new Integer(100));
    }
}

