/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.reflection.Child;
import io.swagger.reflection.IParent;
import io.swagger.reflection.Parent;
import io.swagger.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ReflectionUtilsTest {
    @Test
    public void typeFromStringTest() {
        Assert.assertEquals((Object)ReflectionUtils.typeFromString((String)"int"), Integer.class);
        Assert.assertEquals((Object)ReflectionUtils.typeFromString((String)"java.lang.String"), String.class);
        Assert.assertNull((Object)ReflectionUtils.typeFromString((String)"FakeType"));
        Assert.assertNull((Object)ReflectionUtils.typeFromString(null));
    }

    @Test
    public void isOverriddenMethodTest() throws NoSuchMethodException {
        for (Method method : Child.class.getMethods()) {
            if ("parametrizedMethod1".equals(method.getName())) {
                boolean result = ReflectionUtils.isOverriddenMethod((Method)method, Child.class);
                Class<?> first = method.getParameterTypes()[0];
                if (Number.class.equals(first)) {
                    Assert.assertTrue((boolean)result);
                    continue;
                }
                if (!Integer.class.equals(first)) continue;
                Assert.assertFalse((boolean)result);
                continue;
            }
            if (!"parametrizedMethod3".equals(method.getName())) continue;
            Assert.assertFalse((boolean)ReflectionUtils.isOverriddenMethod((Method)method, Child.class));
        }
        for (Method method : Object.class.getMethods()) {
            if (!"equals".equals(method.getName())) continue;
            Assert.assertFalse((boolean)ReflectionUtils.isOverriddenMethod((Method)method, Object.class));
        }
        for (Method method : IParent.class.getMethods()) {
            if ("parametrizedMethod5".equals(method.getName())) {
                Assert.assertTrue((boolean)ReflectionUtils.isOverriddenMethod((Method)method, IParent.class));
                continue;
            }
            if ("parametrizedMethod2".equals(method.getName())) {
                Assert.assertFalse((boolean)ReflectionUtils.isOverriddenMethod((Method)method, IParent.class));
                continue;
            }
            Assert.fail((String)"Method not expected");
        }
    }

    @Test
    public void getOverriddenMethodTest() throws NoSuchMethodException {
        Method method1 = ReflectionUtils.getOverriddenMethod((Method)Child.class.getMethod("parametrizedMethod1", Integer.class));
        Assert.assertNotNull((Object)method1);
        Assert.assertEquals(method1.getParameterTypes()[0], Number.class);
        Method method2 = ReflectionUtils.getOverriddenMethod((Method)Child.class.getMethod("parametrizedMethod2", Long.class));
        Assert.assertNotNull((Object)method2);
        Assert.assertEquals(method2.getParameterTypes()[0], Number.class);
        Method method3 = ReflectionUtils.getOverriddenMethod((Method)Child.class.getMethod("parametrizedMethod3", Long.class));
        Assert.assertNull((Object)method3);
        Assert.assertNull((Object)ReflectionUtils.getOverriddenMethod((Method)Object.class.getMethod("equals", Object.class)));
    }

    @Test
    public void findMethodTest() throws NoSuchMethodException {
        Method methodToFind1 = Child.class.getMethod("parametrizedMethod1", Integer.class);
        Method method1 = ReflectionUtils.findMethod((Method)methodToFind1, Parent.class);
        Assert.assertNotNull((Object)method1);
        Assert.assertEquals(method1.getParameterTypes()[0], Number.class);
        Method methodToFind2 = Child.class.getMethod("parametrizedMethod4", Long.class);
        Method method2 = ReflectionUtils.findMethod((Method)methodToFind2, Parent.class);
        Assert.assertNull((Object)method2);
    }

    @Test
    public void isInjectTest() throws NoSuchMethodException {
        Method injectableMethod = Child.class.getMethod("injectableMethod", new Class[0]);
        Assert.assertTrue((boolean)ReflectionUtils.isInject(Arrays.asList(injectableMethod.getDeclaredAnnotations())));
        Method methodToFind = Child.class.getMethod("parametrizedMethod1", Integer.class);
        Assert.assertFalse((boolean)ReflectionUtils.isInject(Arrays.asList(methodToFind.getDeclaredAnnotations())));
    }

    @Test
    public void isConstructorCompatibleTest() throws NoSuchMethodException {
        Assert.assertFalse((boolean)ReflectionUtils.isConstructorCompatible(Child.class.getDeclaredConstructor(new Class[0])));
        Assert.assertTrue((boolean)ReflectionUtils.isConstructorCompatible(Child.class.getDeclaredConstructor(String.class)));
    }

    @Test
    public void getAnnotationTest() throws NoSuchMethodException {
        Method method = Child.class.getMethod("annotationHolder", new Class[0]);
        Assert.assertNotNull((Object)ReflectionUtils.getAnnotation((Method)method, ApiOperation.class));
        Assert.assertNull((Object)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class));
    }

    @Test
    public void isVoidTest() {
        Assert.assertTrue((boolean)ReflectionUtils.isVoid(Void.class));
        Assert.assertTrue((boolean)ReflectionUtils.isVoid(Void.TYPE));
        Assert.assertFalse((boolean)ReflectionUtils.isVoid(String.class));
    }

    @Test
    public void testDerivedAnnotation() {
        Path annotation = (Path)ReflectionUtils.getAnnotation(Child.class, Path.class);
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((String)annotation.value(), (String)"parentInterfacePath");
    }

    @Test
    public void getDeclaredFieldsFromInterfaceTest() throws NoSuchMethodException {
        Class<IParent> cls = IParent.class;
        Assert.assertEquals(Collections.emptyList(), (Collection)ReflectionUtils.getDeclaredFields(cls));
    }

    @Test
    public void getIndirectAnnotation() throws NoSuchMethodException {
        Method method = Child.class.getMethod("indirectAnnotationMethod", new Class[0]);
        Assert.assertNotNull((Object)ReflectionUtils.getAnnotation((Method)method, ApiImplicitParams.class));
    }

    @Test
    public void getIndirectAnnotationFromClass() throws NoSuchMethodException {
        Assert.assertNotNull((Object)ReflectionUtils.getAnnotation(Parent.class, ApiImplicitParams.class));
    }

    @Test
    public void getIndirectAnnotationFromInterface() throws NoSuchMethodException {
        Assert.assertNotNull((Object)ReflectionUtils.getAnnotation(Child.class, ApiImplicitParams.class));
    }
}

