/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.properties;

import io.swagger.models.properties.AbstractProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.io.IOException;
import java.math.BigDecimal;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PropertyDeserializerTest {
    @Test
    public void deserializeParameterWithMinimumMaximumValues() throws Exception {
        String json = "{\n  \"in\": \"query\",\n  \"type\": \"integer\",\n  \"format\": \"int32\",\n  \"minimum\": 32,\n  \"maximum\": 100\n}";
        Property property = (Property)Json.mapper().readValue(json, Property.class);
        Assert.assertTrue((boolean)(property instanceof IntegerProperty));
        IntegerProperty ip = (IntegerProperty)property;
        Assert.assertEquals((Object)ip.getMinimum(), (Object)new BigDecimal("32"));
        Assert.assertEquals((Object)ip.getMaximum(), (Object)new BigDecimal("100"));
    }

    @Test
    public void deserializePropertyWithMinimumMaximumValues() throws Exception {
        String json = "{\n  \"type\": \"integer\",\n  \"format\": \"int32\",\n  \"minimum\": 32,\n  \"maximum\": 100\n}";
        Property param = (Property)Json.mapper().readValue(json, Property.class);
        IntegerProperty ip = (IntegerProperty)param;
        Assert.assertEquals((Object)ip.getMinimum(), (Object)new BigDecimal("32"));
        Assert.assertEquals((Object)ip.getMaximum(), (Object)new BigDecimal("100"));
    }

    @Test(description="it should deserialize a property with xml")
    public void testXmlProperty() throws IOException {
        String json = "{\n  \"type\": \"object\",\n  \"title\": \"root\",\n  \"description\": \"root\",\n  \"properties\": {\n    \"progdoi\": {\n      \"type\": \"array\",\n      \"xml\": {\n        \"wrapped\": true\n      },\n      \"items\": {\n        \"type\": \"string\",\n        \"xml\": {\n          \"name\": \"doi\"\n        }\n      }\n    },\n    \"collectors\": {\n      \"type\": \"array\",\n      \"xml\": {\n        \"wrapped\": true,\n        \"name\": \"cols\"\n      },\n      \"items\": {\n        \"$ref\": \"#/definitions/Actor\",\n        \"xml\": {\n          \"name\": \"collector\"\n        }\n      }\n    }\n  }\n}";
        Property result = (Property)Json.mapper().readValue("{\n  \"type\": \"object\",\n  \"title\": \"root\",\n  \"description\": \"root\",\n  \"properties\": {\n    \"progdoi\": {\n      \"type\": \"array\",\n      \"xml\": {\n        \"wrapped\": true\n      },\n      \"items\": {\n        \"type\": \"string\",\n        \"xml\": {\n          \"name\": \"doi\"\n        }\n      }\n    },\n    \"collectors\": {\n      \"type\": \"array\",\n      \"xml\": {\n        \"wrapped\": true,\n        \"name\": \"cols\"\n      },\n      \"items\": {\n        \"$ref\": \"#/definitions/Actor\",\n        \"xml\": {\n          \"name\": \"collector\"\n        }\n      }\n    }\n  }\n}", Property.class);
        Assert.assertTrue((boolean)(result instanceof ObjectProperty));
        Assert.assertEquals((int)2, (int)((ObjectProperty)result).getProperties().size());
        Assert.assertTrue((boolean)((Property)((ObjectProperty)result).getProperties().get("progdoi")).getXml().getWrapped());
        Assert.assertEquals((String)((ArrayProperty)((ObjectProperty)result).getProperties().get("progdoi")).getItems().getXml().getName(), (String)"doi");
        Assert.assertTrue((boolean)((Property)((ObjectProperty)result).getProperties().get("collectors")).getXml().getWrapped());
        Assert.assertEquals((String)((Property)((ObjectProperty)result).getProperties().get("collectors")).getXml().getName(), (String)"cols");
        Assert.assertEquals((String)((ArrayProperty)((ObjectProperty)result).getProperties().get("collectors")).getItems().getXml().getName(), (String)"collector");
    }

    @DataProvider
    public Object[][] readOnlyDataProvider() {
        return new Object[][]{{"\"type\": \"integer\", \"format\": \"int32\""}, {"\"type\": \"string\", \"format\": \"date\""}, {"\"type\": \"number\""}, {"\"type\": \"array\", \"items\": {\"type\": \"string\"}"}, {"\"type\": \"object\", \"additionalProperties\": {\"type\": \"string\"}"}, {"\"type\": \"object\", \"properties\": {\"prop1\": {\"type\": \"string\"}}"}, {"\"$ref\": \"#/definitions/SomeObject\""}};
    }

    @Test(dataProvider="readOnlyDataProvider")
    public void deserializePropertyWithReadOnlyValue(String type) throws Exception {
        String json = "{\n" + type + ",  \"readOnly\": true}";
        Property param = (Property)Json.mapper().readValue(json, Property.class);
        AbstractProperty property = (AbstractProperty)param;
        Assert.assertTrue((boolean)property.getReadOnly());
    }
}

