/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BinaryProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.models.utils.PropertyModelConverter;
import io.swagger.util.Yaml;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PropertyModelConverterTest {
    @Test
    public void convertToUUIDProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: uuid\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof UUIDProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"uuid");
    }

    @Test
    public void convertToEmailProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: email\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof EmailProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"email");
    }

    @Test
    public void convertToBooleanProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: boolean\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof BooleanProperty));
        Assert.assertEquals((String)property.getType(), (String)"boolean");
    }

    @Test
    public void convertToDateProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: date\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof DateProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"date");
    }

    @Test
    public void convertToDateTimeProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: date-time\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof DateTimeProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"date-time");
    }

    @Test
    public void convertToStringProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: password\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof StringProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"password");
    }

    @Test
    public void convertToBinaryProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: binary\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof BinaryProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"binary");
    }

    @Test
    public void convertToDoubleProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: number\n            format: double\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof DoubleProperty));
        Assert.assertEquals((String)property.getType(), (String)"number");
        Assert.assertEquals((String)property.getFormat(), (String)"double");
    }

    @Test
    public void convertToByteArrayProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: string\n            format: byte\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof ByteArrayProperty));
        Assert.assertEquals((String)property.getType(), (String)"string");
        Assert.assertEquals((String)property.getFormat(), (String)"byte");
    }

    @Test
    public void convertToLongProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: integer\n            format: int64\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof LongProperty));
        Assert.assertEquals((String)property.getType(), (String)"integer");
        Assert.assertEquals((String)property.getFormat(), (String)"int64");
    }

    @Test
    public void convertToIntegerProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: integer\n            format: int32\n";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof IntegerProperty));
        Assert.assertEquals((String)property.getType(), (String)"integer");
        Assert.assertEquals((String)property.getFormat(), (String)"int32");
    }

    @Test
    public void convertToArrayProperty() throws Exception {
        String yaml = "      produces:\n        - application/json\n      parameters:\n        []\n      responses:\n        200:\n          description: OK\n          schema:\n            type: array\n            items:\n              type: string\n              format: date-time\n              example: 1985-04-12T23:20:50.52Z";
        Operation operation = (Operation)Yaml.mapper().readValue(yaml, Operation.class);
        Response response = (Response)operation.getResponses().get("200");
        Assert.assertNotNull((Object)response);
        Property property = response.getSchema();
        Assert.assertTrue((boolean)(property instanceof ArrayProperty));
        ArrayProperty arrayProperty = (ArrayProperty)property;
        Assert.assertEquals((String)property.getType(), (String)"array");
        Assert.assertEquals((String)arrayProperty.getItems().getType(), (String)"string");
        Assert.assertEquals((String)arrayProperty.getItems().getFormat(), (String)"date-time");
        Assert.assertEquals((Object)arrayProperty.getItems().getExample(), (Object)"1985-04-12T23:20:50.52Z");
    }

    @Test
    public void convertArrayModel() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/models.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Model arrayModel = (Model)swagger.getDefinitions().get("InstructionSequence");
        PropertyModelConverter converter = new PropertyModelConverter();
        Property convertedProperty = converter.modelToProperty(arrayModel);
        Assert.assertTrue((boolean)(convertedProperty instanceof ArrayProperty));
        ArrayProperty property = (ArrayProperty)convertedProperty;
        Assert.assertEquals((String)property.getTitle(), (String)"InstructionSequence");
        Assert.assertEquals((String)property.getDescription(), (String)"The sequence of steps that make up the Instructions");
        Assert.assertEquals((String)property.getType(), (String)"array");
        Assert.assertTrue((boolean)(property.getItems() instanceof StringProperty));
        Assert.assertEquals((String)property.getItems().getType(), (String)"string");
    }

    @Test
    public void convertAddressModel() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/models.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Model arrayModel = (Model)swagger.getDefinitions().get("Address");
        PropertyModelConverter converter = new PropertyModelConverter();
        Property convertedProperty = converter.modelToProperty(arrayModel);
        Assert.assertTrue((boolean)(convertedProperty instanceof ObjectProperty));
        ObjectProperty property = (ObjectProperty)convertedProperty;
        Assert.assertEquals((String)property.getType(), (String)"object");
        Assert.assertEquals((String)((String)property.getRequiredProperties().get(0)), (String)"street");
        Assert.assertEquals((String)((Property)property.getProperties().get("city")).getType(), (String)"string");
    }

    @Test
    public void composedExtendedModelToPropertyTest() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/models.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Model composedModel = (Model)swagger.getDefinitions().get("ExtendedAddress");
        PropertyModelConverter converter = new PropertyModelConverter();
        Property convertedProperty = converter.modelToProperty(composedModel);
        Assert.assertTrue((boolean)(convertedProperty instanceof ObjectProperty));
        ObjectProperty objectProperty = (ObjectProperty)convertedProperty;
        Assert.assertEquals((String)objectProperty.getType(), (String)"object");
        Assert.assertEquals((String)((Property)objectProperty.getProperties().get("Address")).getType(), (String)"ref");
        Assert.assertEquals((String)((Property)objectProperty.getProperties().get("gps")).getType(), (String)"string");
        Assert.assertEquals((String)((String)objectProperty.getRequiredProperties().get(0)), (String)"gps");
    }

    @Test
    public void composedModelToPropertyTest() {
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> requiredList = new ArrayList<String>();
        requiredList.add("url");
        ModelImpl model = new ModelImpl();
        model.setType("object");
        model.setRequired(requiredList);
        StringProperty property = new StringProperty();
        property.setDescription("Url with information or picture of the product");
        HashMap<String, StringProperty> propertyMap = new HashMap<String, StringProperty>();
        propertyMap.put("url", property);
        model.setProperties(propertyMap);
        list.add(model);
        RefModel refModel1 = new RefModel("#/definitions/ReferencedObject1");
        list.add(refModel1);
        RefModel refModel2 = new RefModel("#/definitions/ReferencedObject2");
        list.add(refModel2);
        ComposedModel composedModel = new ComposedModel();
        composedModel.setDescription("AllOf test");
        composedModel.setExample((Object)"Example");
        composedModel.setAllOf(list);
        PropertyModelConverter converter = new PropertyModelConverter();
        Property convertedProperty = converter.modelToProperty((Model)composedModel);
        Assert.assertTrue((boolean)(convertedProperty instanceof ObjectProperty));
        ObjectProperty objectProperty = (ObjectProperty)convertedProperty;
        Assert.assertEquals((String)objectProperty.getType(), (String)"object");
        Assert.assertEquals((Object)objectProperty.getExample(), (Object)"Example");
        Assert.assertEquals((String)objectProperty.getDescription(), (String)"AllOf test");
        Assert.assertEquals((String)((Property)objectProperty.getProperties().get("url")).getType(), (String)"string");
        Assert.assertEquals((String)((Property)objectProperty.getProperties().get("ReferencedObject1")).getType(), (String)"ref");
        Assert.assertEquals((String)((String)objectProperty.getRequiredProperties().get(0)), (String)"url");
    }

    @Test
    public void convertPropertyToModel() {
        IntegerProperty integerProperty = new IntegerProperty();
        MapProperty mapProperty = new MapProperty();
        mapProperty.setAdditionalProperties((Property)integerProperty);
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel((Property)mapProperty);
        Assert.assertTrue((boolean)(convertedModel instanceof ModelImpl));
        ModelImpl model = (ModelImpl)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"object");
        Assert.assertEquals((String)model.getAdditionalProperties().getType(), (String)"integer");
    }

    @Test
    public void convertStringProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/string");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ModelImpl));
        ModelImpl model = (ModelImpl)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"string");
        Assert.assertEquals((Object)model.getExample(), (Object)"Hello");
    }

    @Test
    public void convertStringRefProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/stringRef");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof RefModel));
        RefModel model = (RefModel)convertedModel;
        Assert.assertEquals((String)model.get$ref(), (String)"#/definitions/DayOfWeekAsString");
    }

    @Test
    public void convertBooleanProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/boolean");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ModelImpl));
        ModelImpl model = (ModelImpl)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"boolean");
        Assert.assertEquals((Object)model.getExample(), (Object)true);
    }

    @Test
    public void convertNumberProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/number");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ModelImpl));
        ModelImpl model = (ModelImpl)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"number");
        Assert.assertEquals((Object)model.getExample(), (Object)1.5);
    }

    @Test
    public void convertArrayProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/arrayOfInt");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ArrayModel));
        ArrayModel model = (ArrayModel)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"array");
        Assert.assertEquals((String)model.getItems().getType(), (String)"integer");
    }

    @Test
    public void convertArrayOfRefProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/arrayOfRef");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ArrayModel));
        ArrayModel model = (ArrayModel)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"array");
        Assert.assertEquals((String)model.getItems().getType(), (String)"ref");
        RefProperty items = (RefProperty)model.getItems();
        Assert.assertEquals((String)items.get$ref(), (String)"#/definitions/User");
    }

    @Test
    public void convertArrayRefProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/arrayRef");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof RefModel));
        RefModel model = (RefModel)convertedModel;
        Assert.assertEquals((String)model.get$ref(), (String)"#/definitions/ArrayOfint");
    }

    @Test
    public void convertObjectProperty() throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode rootNode = mapper.readTree(Files.readAllBytes(Paths.get(this.getClass().getResource("/specFiles/responses.yaml").toURI())));
        String specAsYaml = rootNode.toString();
        Swagger swagger = (Swagger)Yaml.mapper().readValue(specAsYaml, Swagger.class);
        Path string = (Path)swagger.getPaths().get("/object");
        Operation operation = (Operation)string.getOperations().get(0);
        Response response = (Response)operation.getResponses().get("200");
        Property property = response.getSchema();
        PropertyModelConverter converter = new PropertyModelConverter();
        Model convertedModel = converter.propertyToModel(property);
        Assert.assertTrue((boolean)(convertedModel instanceof ModelImpl));
        ModelImpl model = (ModelImpl)convertedModel;
        Assert.assertEquals((String)model.getType(), (String)"object");
        Assert.assertEquals((String)((Property)model.getProperties().get("id")).getType(), (String)"integer");
        Assert.assertEquals((String)((Property)model.getProperties().get("id")).getFormat(), (String)"int64");
        Assert.assertEquals((String)((Property)model.getProperties().get("name")).getType(), (String)"string");
        Assert.assertEquals((String)((String)model.getRequired().get(0)), (String)"id");
        Assert.assertEquals((String)((String)model.getRequired().get(1)), (String)"name");
    }
}

