/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.Model;
import io.swagger.models.ModelWithModelPropertyOverrides;
import io.swagger.models.ModelWithPrimitiveArray;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelPropertyTest {
    @Test
    public void extractProperties() {
        Map models = ModelConverters.getInstance().readAll(Family.class);
        Assert.assertEquals((int)models.size(), (int)3);
        Model person = (Model)models.get("Person");
        Property employer = (Property)person.getProperties().get("employer");
        Assert.assertTrue((boolean)(employer instanceof ArrayProperty));
        ArrayProperty employerProperty = (ArrayProperty)employer;
        Property items = employerProperty.getItems();
        Assert.assertTrue((boolean)(items instanceof RefProperty));
        Assert.assertEquals((String)((RefProperty)items).getSimpleRef(), (String)"Employer");
        Property awards = (Property)person.getProperties().get("awards");
        Assert.assertTrue((boolean)(awards instanceof ArrayProperty));
        Assert.assertTrue((boolean)(((ArrayProperty)awards).getItems() instanceof StringProperty));
    }

    @Test
    public void extractPrimitiveArray() {
        Map models = ModelConverters.getInstance().readAll(ModelWithPrimitiveArray.class);
        Assert.assertEquals((int)models.size(), (int)1);
        Model model = (Model)models.get("ModelWithPrimitiveArray");
        ArrayProperty longArray = (ArrayProperty)model.getProperties().get("longArray");
        Property longArrayItems = longArray.getItems();
        Assert.assertTrue((boolean)(longArrayItems instanceof LongProperty));
        ArrayProperty intArray = (ArrayProperty)model.getProperties().get("intArray");
        Assert.assertTrue((boolean)(intArray.getItems() instanceof IntegerProperty));
    }

    @Test
    public void readModelProperty() {
        Map models = ModelConverters.getInstance().readAll(IsModelTest.class);
        Model model = (Model)models.get("IsModelTest");
        Assert.assertNotNull((Object)model);
    }

    @Test(description="it should read a model with property dataTypes configured #679")
    public void readDataTypesProperty() {
        Map models = ModelConverters.getInstance().readAll(ModelWithModelPropertyOverrides.class);
        String json = "{   \"Children\":{      \"type\":\"object\",      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   },   \"ModelWithModelPropertyOverrides\":{      \"type\":\"object\",      \"properties\":{         \"children\":{            \"type\":\"array\",            \"items\":{               \"$ref\":\"#/definitions/Children\"            }         }      }   }}";
        SerializationMatchers.assertEqualsToJson(models, "{   \"Children\":{      \"type\":\"object\",      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   },   \"ModelWithModelPropertyOverrides\":{      \"type\":\"object\",      \"properties\":{         \"children\":{            \"type\":\"array\",            \"items\":{               \"$ref\":\"#/definitions/Children\"            }         }      }   }}");
    }

    class IsModelTest {
        public Boolean is_happy;
        public String name;

        IsModelTest() {
        }
    }

    class Employer {
        public String name;
        public int size;

        Employer() {
        }
    }

    class Person {
        public String firstname;
        public String lastname;
        public int age;
        public Date birthday;
        public List<Employer> employer;
        public List<String> awards;

        Person() {
        }
    }

    class Family {
        public Date membersSince;
        public List<Person> members;

        Family() {
        }
    }
}

