/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.InnerType;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.util.Calendar;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ContainerTest
extends SwaggerTestBase {
    @Test
    public void testArray() throws Exception {
        ModelResolver modelResolver = new ModelResolver(ContainerTest.mapper());
        ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)modelResolver);
        Model model = context.resolve(ArrayBean.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)1, (int)props.size());
        Property prop = (Property)props.get("a");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((String)prop.getType(), (String)"array");
        Property items = ((ArrayProperty)prop).getItems();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((String)items.getType(), (String)"integer");
    }

    @Test
    public void testMap() throws Exception {
        ModelResolver modelResolver = new ModelResolver(ContainerTest.mapper());
        ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)modelResolver);
        Model model = context.resolve(MapBean.class);
        Map props = model.getProperties();
        Assert.assertEquals((int)1, (int)props.size());
        Property prop = (Property)props.get("stuff");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((String)prop.getType(), (String)"object");
        Property items = ((MapProperty)prop).getAdditionalProperties();
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((String)items.getType(), (String)"string");
        Assert.assertEquals((String)items.getFormat(), (String)"date-time");
    }

    @Test
    public void testComplexMap() throws Exception {
        ModelResolver resolver = new ModelResolver(ContainerTest.mapper());
        ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)resolver);
        context.resolve(WrapperType.class);
        Map models = context.getDefinedModels();
        Model innerType = (Model)models.get("InnerType");
        Assert.assertNotNull((Object)innerType);
        Map innerProps = innerType.getProperties();
        Assert.assertEquals((int)innerProps.size(), (int)2);
        Property foo = (Property)innerProps.get("foo");
        Assert.assertEquals((String)foo.getType(), (String)"integer");
        Assert.assertEquals((String)foo.getFormat(), (String)"int32");
        Property name = (Property)innerProps.get("name");
        Assert.assertEquals((String)name.getType(), (String)"string");
        Model wrapperType = (Model)models.get("WrapperType");
        Assert.assertNotNull((Object)wrapperType);
        Assert.assertEquals((String)((Property)wrapperType.getProperties().get("innerType")).getType(), (String)"object");
    }

    static class WrapperType {
        public Map<String, InnerType> innerType;

        WrapperType() {
        }
    }

    static class MapBean {
        public Map<Short, Calendar> stuff;

        MapBean() {
        }
    }

    static class ArrayBean {
        public int[] a;

        ArrayBean() {
        }
    }
}

