/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModel;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.ComposedModel;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InheritedBeanTest
extends SwaggerTestBase {
    private final ModelResolver modelResolver = new ModelResolver(new ObjectMapper());
    private final ModelConverterContextImpl context = new ModelConverterContextImpl((ModelConverter)this.modelResolver);

    @Test
    public void testInheritedBean() throws Exception {
        Model baseModel = this.context.resolve(BaseBean.class);
        Assert.assertNotNull((Object)baseModel);
        Map baseProperites = baseModel.getProperties();
        Assert.assertEquals((int)baseProperites.size(), (int)3);
        for (Map.Entry entry : baseProperites.entrySet()) {
            String name = (String)entry.getKey();
            Property prop = (Property)entry.getValue();
            if ("type".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                continue;
            }
            if ("a".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"integer");
                Assert.assertEquals((String)prop.getFormat(), (String)"int32");
                continue;
            }
            if (!"b".equals(name)) continue;
            Assert.assertEquals((String)prop.getType(), (String)"string");
        }
        Model subModel = (Model)this.context.getDefinedModels().get("Sub1Bean");
        Assert.assertNotNull((Object)subModel);
        Assert.assertTrue((boolean)(subModel instanceof ComposedModel));
        ComposedModel cm = (ComposedModel)subModel;
        Assert.assertEquals((String)cm.getParent().getReference(), (String)"#/definitions/BaseBean");
        Map subProperties = cm.getChild().getProperties();
        Assert.assertEquals((int)subProperties.size(), (int)1);
    }

    @ApiModel(description="Sub1Bean")
    static class Sub1Bean
    extends BaseBean {
        public int c;

        Sub1Bean() {
        }
    }

    @JsonTypeInfo(include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.NAME, property="type", visible=true)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Sub1Bean.class, name="sub1")})
    @ApiModel(description="BaseBean", discriminator="type", subTypes={Sub1Bean.class})
    static class BaseBean {
        public String type;
        public int a;
        public String b;

        BaseBean() {
        }
    }
}

