/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parameter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ParameterSerializationTest {
    private final ObjectMapper m = Json.mapper();

    @Test(description="it should serialize a QueryParameter")
    public void serializeQueryParameter() {
        QueryParameter p = (QueryParameter)new QueryParameter().property((Property)new StringProperty());
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"string\"}";
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"query\",\"required\":false,\"type\":\"string\"}");
    }

    @Test(description="it should deserialize a QueryParameter")
    public void deserializeQueryParameter() throws IOException {
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"string\"}";
        Parameter p = (Parameter)this.m.readValue("{\"in\":\"query\",\"required\":false,\"type\":\"string\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"query\",\"required\":false,\"type\":\"string\"}");
    }

    @Test(description="it should serialize a QueryParameter with array")
    public void serializeArrayQueryParameter() {
        QueryParameter p = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().type("array")).items((Property)new StringProperty())).collectionFormat("multi");
        String json = "{   \"in\":\"query\",   \"required\":false,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"query\",   \"required\":false,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should deserialize a QueryParameter with array")
    public void deserializeArrayQueryParameter() throws IOException {
        String json = "{   \"in\":\"query\",   \"required\":false,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"query\",   \"required\":false,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"query\",   \"required\":false,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should serialize a PathParameter")
    public void serializePathParameter() {
        PathParameter p = (PathParameter)new PathParameter().property((Property)new StringProperty());
        String json = "{\"in\":\"path\",\"required\":true,\"type\":\"string\"}";
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"path\",\"required\":true,\"type\":\"string\"}");
    }

    @Test(description="it should deserialize a PathParameter")
    public void deserializePathParameter() throws IOException {
        String json = "{\"in\":\"query\",\"required\":true,\"type\":\"string\"}";
        Parameter p = (Parameter)this.m.readValue("{\"in\":\"query\",\"required\":true,\"type\":\"string\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"query\",\"required\":true,\"type\":\"string\"}");
        Assert.assertTrue((boolean)p.getRequired());
    }

    @Test(description="it should serialize a PathParameter with string array")
    public void serializeStringArrayPathParameter() {
        PathParameter p = (PathParameter)((PathParameter)((PathParameter)new PathParameter().type("array")).items((Property)new StringProperty())).collectionFormat("multi");
        String json = "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}");
        String yaml = "---\nin: \"path\"\nrequired: true\ntype: \"array\"\nitems:\n  type: \"string\"\ncollectionFormat: \"multi\"";
        SerializationMatchers.assertEqualsToYaml(p, "---\nin: \"path\"\nrequired: true\ntype: \"array\"\nitems:\n  type: \"string\"\ncollectionFormat: \"multi\"");
    }

    @Test(description="it should deserialize a PathParameter with string array")
    public void deserializeStringArrayPathParameter() throws IOException {
        String json = "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"string\"   },   \"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should serialize a PathParameter with integer array")
    public void serializeIntegerArrayPathParameter() {
        PathParameter p = (PathParameter)((PathParameter)((PathParameter)new PathParameter().type("array")).items((Property)new IntegerProperty())).collectionFormat("multi");
        String json = "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"integer\",      \"format\":\"int32\"   },   \"collectionFormat\":\"multi\"}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"integer\",      \"format\":\"int32\"   },   \"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should deserialize a PathParameter with integer array ")
    public void deserializeIntegerArrayPathParameter() throws IOException {
        String json = "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"integer\",      \"format\":\"int32\"   },   \"collectionFormat\":\"multi\"}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"integer\",      \"format\":\"int32\"   },   \"collectionFormat\":\"multi\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"type\":\"array\",   \"items\":{      \"type\":\"integer\",      \"format\":\"int32\"   },   \"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should it should serialize a HeaderParameter")
    public void serializeHeaderParameter() {
        HeaderParameter p = (HeaderParameter)new HeaderParameter().property((Property)new StringProperty());
        String json = "{\"in\":\"header\",\"required\":false,\"type\":\"string\"}";
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"header\",\"required\":false,\"type\":\"string\"}");
        String yaml = "---\nin: \"header\"\nrequired: false\ntype: \"string\"";
        SerializationMatchers.assertEqualsToYaml(p, "---\nin: \"header\"\nrequired: false\ntype: \"string\"");
    }

    @Test(description="it should deserialize a HeaderParameter")
    public void deserializeHeaderParameter() throws IOException {
        String json = "{\"in\":\"header\",\"required\":true,\"type\":\"string\"}";
        Parameter p = (Parameter)this.m.readValue("{\"in\":\"header\",\"required\":true,\"type\":\"string\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"header\",\"required\":true,\"type\":\"string\"}");
    }

    @Test(description="it should serialize a string array HeaderParameter")
    public void serializeStringArrayHeaderParameter() {
        HeaderParameter p = (HeaderParameter)((HeaderParameter)((HeaderParameter)new HeaderParameter().type("array")).property((Property)new StringProperty())).collectionFormat("multi");
        String json = "{\"in\":\"header\",\"required\":false,\"type\":\"string\",\"collectionFormat\":\"multi\"}";
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"header\",\"required\":false,\"type\":\"string\",\"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should deserialize a string array HeaderParameter")
    public void deserializeStringArrayHeaderParameter() throws IOException {
        String json = "{\"in\":\"header\",\"required\":true,\"type\":\"string\",\"collectionFormat\":\"multi\"}";
        Parameter p = (Parameter)this.m.readValue("{\"in\":\"header\",\"required\":true,\"type\":\"string\",\"collectionFormat\":\"multi\"}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"header\",\"required\":true,\"type\":\"string\",\"collectionFormat\":\"multi\"}");
    }

    @Test(description="it should serialize a BodyParameter")
    public void serializeBodyParameter() {
        ModelImpl model = new ModelImpl().name("Cat").property("name", (Property)new StringProperty());
        BodyParameter p = new BodyParameter().schema((Model)model);
        String json = "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   }}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   }}");
    }

    @Test(description="it should serialize a BodyParameter to yaml")
    public void serializeBodyParameterToYaml() {
        ModelImpl model = new ModelImpl().name("Cat").property("name", (Property)new StringProperty());
        BodyParameter p = new BodyParameter().schema((Model)model);
        String yaml = "---\nin: \"body\"\nrequired: false\nschema:\n  properties:\n    name:\n      type: \"string\"";
        SerializationMatchers.assertEqualsToYaml(p, "---\nin: \"body\"\nrequired: false\nschema:\n  properties:\n    name:\n      type: \"string\"");
    }

    @Test(description="it should deserialize a BodyParameter")
    public void deserializeBodyParameter() throws IOException {
        String json = "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   }}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   }}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"properties\":{         \"name\":{            \"type\":\"string\"         }      }   }}");
    }

    @Test(description="it should serialize a ref BodyParameter")
    public void serializeRefBodyParameter() {
        RefModel model = new RefModel("Cat");
        BodyParameter p = new BodyParameter().schema((Model)model);
        String json = "{\"in\":\"body\",\"required\":false,\"schema\":{\"$ref\":\"#/definitions/Cat\"}}";
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"body\",\"required\":false,\"schema\":{\"$ref\":\"#/definitions/Cat\"}}");
    }

    @Test(description="it should deserialize a ref BodyParameter")
    public void deserializeRefBodyParameter() throws IOException {
        String json = "{\"in\":\"body\",\"required\":false,\"schema\":{\"$ref\":\"#/definitions/Cat\"}}";
        Parameter p = (Parameter)this.m.readValue("{\"in\":\"body\",\"required\":false,\"schema\":{\"$ref\":\"#/definitions/Cat\"}}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{\"in\":\"body\",\"required\":false,\"schema\":{\"$ref\":\"#/definitions/Cat\"}}");
    }

    @Test(description="it should serialize an array BodyParameter")
    public void serializeArrayBodyParameter() {
        ArrayModel model = new ArrayModel().items((Property)new RefProperty("Cat"));
        BodyParameter p = new BodyParameter().schema((Model)model);
        String json = "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"type\":\"array\",      \"items\":{         \"$ref\":\"#/definitions/Cat\"      }   }}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"type\":\"array\",      \"items\":{         \"$ref\":\"#/definitions/Cat\"      }   }}");
    }

    @Test(description="it should deserialize an array BodyParameter")
    public void deserializeArrayBodyParameter() throws IOException {
        String json = "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"type\":\"array\",      \"items\":{         \"$ref\":\"#/definitions/Cat\"      }   }}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"type\":\"array\",      \"items\":{         \"$ref\":\"#/definitions/Cat\"      }   }}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"body\",   \"required\":false,   \"schema\":{      \"type\":\"array\",      \"items\":{         \"$ref\":\"#/definitions/Cat\"      }   }}");
    }

    @Test(description="it should serialize a path parameter with enum")
    public void serializeEnumPathParameter() {
        PathParameter p = (PathParameter)((PathParameter)new PathParameter().items((Property)new StringProperty()))._enum(Arrays.asList("a", "b", "c"));
        String json = "{   \"in\":\"path\",   \"required\":true,   \"items\":{      \"type\":\"string\"   },   \"enum\":[\"a\",\"b\",\"c\"]}";
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"items\":{      \"type\":\"string\"   },   \"enum\":[\"a\",\"b\",\"c\"]}");
    }

    @Test(description="it should deserialize a path parameter with enum")
    public void deserializeEnumPathParameter() throws IOException {
        String json = "{   \"in\":\"path\",   \"required\":true,   \"items\":{      \"type\":\"string\"   },   \"enum\":[\"a\",\"b\",\"c\"]}";
        Parameter p = (Parameter)this.m.readValue("{   \"in\":\"path\",   \"required\":true,   \"items\":{      \"type\":\"string\"   },   \"enum\":[\"a\",\"b\",\"c\"]}", Parameter.class);
        SerializationMatchers.assertEqualsToJson(p, "{   \"in\":\"path\",   \"required\":true,   \"items\":{      \"type\":\"string\"   },   \"enum\":[\"a\",\"b\",\"c\"]}");
        Assert.assertEquals((Collection)((PathParameter)p).getEnum(), Arrays.asList("a", "b", "c"));
    }

    @Test(description="should serialize string value")
    public void testStringValue() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("false");
        param.setType("string");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"string\",\"default\":\"false\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"string\",\"default\":\"false\"}");
    }

    @Test(description="should serialize boolean value")
    public void testBooleanValue() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("false");
        param.setType("boolean");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"boolean\",\"default\":false}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"boolean\",\"default\":false}");
    }

    @Test(description="should serialize long value")
    public void testLongValue() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("1234");
        param.setType("integer");
        param.setFormat("1nt64");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"integer\",\"default\":1234,\"format\":\"1nt64\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"integer\",\"default\":1234,\"format\":\"1nt64\"}");
    }

    @Test(description="should serialize double value")
    public void testDoubleValue() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("12.34");
        param.setType("number");
        param.setFormat("double");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":12.34,\"format\":\"double\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":12.34,\"format\":\"double\"}");
    }

    @Test(description="should serialize double value")
    public void testFloatValue() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("12.34");
        param.setType("number");
        param.setFormat("float");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":12.34,\"format\":\"float\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":12.34,\"format\":\"float\"}");
    }

    @Test(description="should serialize incorrect boolean value as string")
    public void testIncorrectBoolean() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("test");
        param.setType("boolean");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"boolean\",\"default\":\"test\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"boolean\",\"default\":\"test\"}");
    }

    @Test(description="should serialize incorrect long value as string")
    public void testIncorrectLong() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("test");
        param.setType("integer");
        param.setFormat("1nt64");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"integer\",\"default\":\"test\",\"format\":\"1nt64\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"integer\",\"default\":\"test\",\"format\":\"1nt64\"}");
    }

    @Test(description="should serialize incorrect double value as string")
    public void testIncorrectDouble() {
        QueryParameter param = new QueryParameter();
        param.setDefaultValue("test");
        param.setType("number");
        param.setFormat("double");
        String json = "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":\"test\",\"format\":\"double\"}";
        SerializationMatchers.assertEqualsToJson(param, "{\"in\":\"query\",\"required\":false,\"type\":\"number\",\"default\":\"test\",\"format\":\"double\"}");
    }
}

