/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.models.Address;
import io.swagger.models.Issue534;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.ModelWithJAXBAnnotations;
import io.swagger.models.Xml;
import io.swagger.models.properties.Property;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XmlModelTest {
    @Test(description="it should process an XML model attribute")
    public void processXMLModelAttribute() {
        Map schemas = ModelConverters.getInstance().readAll(Monster.class);
        Model model = (Model)schemas.get("Monster");
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        Xml xml = ((ModelImpl)model).getXml();
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((String)xml.getName(), (String)"monster");
        Property property = (Property)model.getProperties().get("children");
        Assert.assertNotNull((Object)property);
        xml = property.getXml();
        Assert.assertTrue((boolean)xml.getWrapped());
        Assert.assertNull((Object)xml.getName());
    }

    @Test(description="it should not create an xml object")
    public void itShouldNotCreateXmlObject() {
        Map schemas = ModelConverters.getInstance().readAll(Address.class);
        Model model = (Model)schemas.get("Address");
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        Property property = (Property)model.getProperties().get("streetNumber");
        Xml xml = property.getXml();
        Assert.assertNull((Object)xml);
    }

    @Test(description="it should stay hidden per 534")
    public void stayHidden() {
        Map schemas = ModelConverters.getInstance().readAll(Issue534.class);
        Assert.assertEquals((int)((Model)schemas.get("Issue534")).getProperties().size(), (int)1);
    }

    @Test(description="it should process a model with JAXB annotations")
    public void processModelWithJAXBAnnotations() {
        Map schemas = ModelConverters.getInstance().readAll(ModelWithJAXBAnnotations.class);
        Assert.assertEquals((int)schemas.size(), (int)1);
        Model model = (Model)schemas.get("ModelWithJAXBAnnotations");
        Assert.assertNotNull((Object)model);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        Xml rootXml = ((ModelImpl)model).getXml();
        Assert.assertNotNull((Object)rootXml);
        Assert.assertEquals((String)rootXml.getName(), (String)"rootName");
        for (Map.Entry entry : model.getProperties().entrySet()) {
            Xml xml;
            String name = (String)entry.getKey();
            Property property = (Property)entry.getValue();
            if ("id".equals(name)) {
                xml = property.getXml();
                Assert.assertNotNull((Object)xml);
                Assert.assertNull((Object)xml.getName());
                Assert.assertTrue((boolean)xml.getAttribute());
                Assert.assertNull((Object)xml.getWrapped());
                continue;
            }
            if ("name".equals(name)) {
                xml = property.getXml();
                Assert.assertNotNull((Object)xml);
                Assert.assertEquals((String)xml.getName(), (String)"renamed");
                Assert.assertNull((Object)xml.getAttribute());
                Assert.assertNull((Object)xml.getWrapped());
                continue;
            }
            if (Arrays.asList("list", "forcedElement").contains(name)) {
                Assert.assertNull((Object)property.getXml());
                continue;
            }
            if ("wrappedList".equals(name)) {
                xml = property.getXml();
                Assert.assertNotNull((Object)xml);
                Assert.assertEquals((String)xml.getName(), (String)"wrappedListItems");
                Assert.assertNull((Object)xml.getAttribute());
                Assert.assertTrue((boolean)xml.getWrapped());
                continue;
            }
            Assert.fail((String)String.format("Unexpected property: %s", name));
        }
    }

    @Test(description="it should deserialize a model")
    public void deserializeModel() throws IOException {
        String yaml = "---\ntype: \"object\"\nproperties:\n  id:\n    type: \"string\"\n    xml:\n      attribute: true\n  name:\n    type: \"string\"\n    xml:\n      name: \"renamed\"\n  list:\n    type: \"array\"\n    items:\n      type: \"string\"\n  wrappedList:\n    type: \"array\"\n    xml:\n      name: \"wrappedListItems\"\n      wrapped: true\n    items:\n      type: \"string\"\n  forcedElement:\n    type: \"array\"\n    items:\n      type: \"string\"\nxml:\n  name: \"rootName\"";
        ModelImpl model = (ModelImpl)Yaml.mapper().readValue("---\ntype: \"object\"\nproperties:\n  id:\n    type: \"string\"\n    xml:\n      attribute: true\n  name:\n    type: \"string\"\n    xml:\n      name: \"renamed\"\n  list:\n    type: \"array\"\n    items:\n      type: \"string\"\n  wrappedList:\n    type: \"array\"\n    xml:\n      name: \"wrappedListItems\"\n      wrapped: true\n    items:\n      type: \"string\"\n  forcedElement:\n    type: \"array\"\n    items:\n      type: \"string\"\nxml:\n  name: \"rootName\"", ModelImpl.class);
        Property wrappedList = (Property)model.getProperties().get("wrappedList");
        Assert.assertNotNull((Object)wrappedList);
        Assert.assertNotNull((Object)wrappedList.getXml());
        Assert.assertEquals((String)wrappedList.getXml().getName(), (String)"wrappedListItems");
    }

    @XmlRootElement(name="monster")
    class Monster {
        public String name = "";
        @XmlElementWrapper
        @XmlElement(name="children")
        public List<String> children = new ArrayList<String>();

        Monster() {
        }
    }
}

