/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Model;
import io.swagger.models.properties.Property;
import java.util.Map;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public class JodaTest
extends SwaggerTestBase {
    @Test
    public void testSimple() throws Exception {
        ModelResolver mr = this.modelResolver();
        Model model = mr.resolve(ModelWithJodaDateTime.class, (ModelConverterContext)new ModelConverterContextImpl((ModelConverter)mr), null);
        Assert.assertNotNull((Object)model);
        Map props = model.getProperties();
        Assert.assertEquals((int)props.size(), (int)2);
        for (Map.Entry entry : props.entrySet()) {
            String name = (String)entry.getKey();
            Property prop = (Property)entry.getValue();
            if ("name".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                continue;
            }
            if ("createdAt".equals(name)) {
                Assert.assertEquals((String)prop.getType(), (String)"string");
                Assert.assertEquals((String)prop.getFormat(), (String)"date-time");
                continue;
            }
            FileAssert.fail((String)String.format("Unknown property '%s'", name));
        }
    }

    static class ModelWithJodaDateTime {
        @ApiModelProperty(value="Name!", position=2)
        public String name;
        @ApiModelProperty(value="creation timestamp", required=true, position=1)
        public DateTime createdAt;

        ModelWithJodaDateTime() {
        }
    }
}

