/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jackson;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.jackson.SwaggerTestBase;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Xml;
import io.swagger.models.properties.Property;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XMLInfoTest
extends SwaggerTestBase {
    @Test
    public void testSimple() throws Exception {
        ModelResolver mr = this.modelResolver();
        Model model = mr.resolve(XmlDecoratedBean.class, (ModelConverterContext)new ModelConverterContextImpl((ModelConverter)mr), null);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)model;
        Xml xml = impl.getXml();
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((String)xml.getName(), (String)"xmlDecoratedBean");
        Property property = (Property)impl.getProperties().get("items");
        Assert.assertNotNull((Object)property);
        Xml propertyXml = property.getXml();
        Assert.assertNotNull((Object)propertyXml);
        Assert.assertEquals((String)propertyXml.getName(), (String)"item");
        Assert.assertTrue((boolean)propertyXml.getWrapped());
        Assert.assertNotNull(impl.getProperties().get("elementC"));
    }

    @Test
    public void testReadingXmlAccessorTypeNone() throws Exception {
        ModelResolver mr = this.modelResolver();
        Model model = mr.resolve(XmlDecoratedBeanXmlAccessorNone.class, (ModelConverterContext)new ModelConverterContextImpl((ModelConverter)mr), null);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)model;
        Xml xml = impl.getXml();
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((String)xml.getName(), (String)"xmlDecoratedBean");
        Property property = (Property)impl.getProperties().get("a");
        Assert.assertNotNull((Object)property);
        Assert.assertNull(impl.getProperties().get("b"));
    }

    @Test
    public void testReadingXmlAccessorTypePublic() throws Exception {
        ModelResolver mr = this.modelResolver();
        Model model = mr.resolve(XmlDecoratedBeanXmlAccessorPublic.class, (ModelConverterContext)new ModelConverterContextImpl((ModelConverter)mr), null);
        Assert.assertTrue((boolean)(model instanceof ModelImpl));
        ModelImpl impl = (ModelImpl)model;
        Xml xml = impl.getXml();
        Assert.assertNotNull((Object)xml);
        Assert.assertEquals((String)xml.getName(), (String)"xmlDecoratedBean");
        Property propertyA = (Property)impl.getProperties().get("a");
        Assert.assertNotNull((Object)propertyA);
        Property propertyB = (Property)impl.getProperties().get("b");
        Assert.assertNotNull((Object)propertyB);
    }

    @XmlRootElement(name="xmlDecoratedBean")
    @ApiModel
    static class XmlDecoratedBeanXmlAccessorPublic {
        @XmlElement
        public int a;
        public String b;

        XmlDecoratedBeanXmlAccessorPublic() {
        }
    }

    @XmlRootElement(name="xmlDecoratedBean")
    @XmlAccessorType(value=XmlAccessType.NONE)
    @ApiModel
    static class XmlDecoratedBeanXmlAccessorNone {
        @XmlElement
        public int a;
        public String b;

        XmlDecoratedBeanXmlAccessorNone() {
        }
    }

    @XmlRootElement(name="xmlDecoratedBean")
    @ApiModel(description="DESC")
    static class XmlDecoratedBean {
        @XmlElement(name="elementB")
        public int b;
        @XmlElementWrapper(name="items")
        @XmlElement(name="item")
        public List<String> items;
        @JsonProperty(value="elementC")
        public String c;

        XmlDecoratedBean() {
        }
    }
}

