/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public enum OutputReplacer {
    OUT{

        @Override
        PrintStream getOutputStream() {
            return System.out;
        }

        @Override
        void setOutputStream(PrintStream outputStream) {
            System.setOut(outputStream);
        }
    }
    ,
    ERROR{

        @Override
        PrintStream getOutputStream() {
            return System.err;
        }

        @Override
        void setOutputStream(PrintStream outputStream) {
            System.setErr(outputStream);
        }
    };


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Function function) {
        PrintStream out = this.getOutputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.setOutputStream(new PrintStream(outputStream));
            function.run();
        }
        finally {
            this.setOutputStream(out);
        }
        try {
            return outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    abstract PrintStream getOutputStream();

    abstract void setOutputStream(PrintStream var1);

    public static interface Function {
        public void run();
    }
}

