/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.model.override;

import io.swagger.annotations.ApiModelProperty;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.model.override.MyCustomClass;
import io.swagger.model.override.SamplePropertyConverter;
import java.util.Map;
import org.testng.annotations.Test;

public class ModelPropertyOverrideTest {
    @Test
    public void overrideTest() throws Exception {
        ModelConverters.getInstance().addConverter((ModelConverter)new SamplePropertyConverter());
        Map model = ModelConverters.getInstance().read(MyPojo.class);
        String expected = "{  \"MyPojo\" : {    \"type\" : \"object\",    \"properties\" : {      \"id\" : {        \"type\" : \"string\"      },      \"myCustomClass\" : {        \"type\" : \"string\",        \"format\" : \"date-time\",        \"description\" : \"instead of modeling this class in the documentation, we will model a string\"      }    }  }}";
        SerializationMatchers.assertEqualsToJson(model, "{  \"MyPojo\" : {    \"type\" : \"object\",    \"properties\" : {      \"id\" : {        \"type\" : \"string\"      },      \"myCustomClass\" : {        \"type\" : \"string\",        \"format\" : \"date-time\",        \"description\" : \"instead of modeling this class in the documentation, we will model a string\"      }    }  }}");
    }

    public static class MyPojo {
        public String getId() {
            return "";
        }

        public void setId(String id) {
        }

        @ApiModelProperty(value="instead of modeling this class in the documentation, we will model a string")
        public MyCustomClass getMyCustomClass() {
            return null;
        }

        public void setMyCustomClass(MyCustomClass myCustomClass) {
        }
    }
}

