/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import io.swagger.TestUtils;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonDeserializationTest {
    @Test
    public void testDeserializePetStoreFile() throws Exception {
        TestUtils.deserializeJsonFileFromClasspath("specFiles/petstore.json", Swagger.class);
    }

    @Test
    public void testDeserializeCompositionTest() throws Exception {
        TestUtils.deserializeJsonFileFromClasspath("specFiles/compositionTest.json", Swagger.class);
    }

    @Test
    public void testDeserializeAPathRef() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/pathRef.json", Swagger.class);
        Path petPath = swagger.getPath("/pet");
        Assert.assertTrue((boolean)(petPath instanceof RefPath));
        Assert.assertEquals((String)((RefPath)petPath).get$ref(), (String)"http://my.company.com/paths/health.json");
        Assert.assertTrue((boolean)(swagger.getPath("/user") instanceof Path));
    }

    @Test
    public void testDeserializeAResponseRef() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/responseRef.json", Swagger.class);
        Map responseMap = swagger.getPath("/pet").getPut().getResponses();
        this.assertIsRefResponse((Response)responseMap.get("405"), "http://my.company.com/responses/errors.json#/method-not-allowed");
        this.assertIsRefResponse((Response)responseMap.get("404"), "http://my.company.com/responses/errors.json#/not-found");
        Assert.assertTrue((boolean)(responseMap.get("400") instanceof Response));
    }

    private void assertIsRefResponse(Response response, String expectedRef) {
        Assert.assertTrue((boolean)(response instanceof RefResponse));
        RefResponse refResponse = (RefResponse)response;
        Assert.assertEquals((String)refResponse.get$ref(), (String)expectedRef);
    }

    @Test
    public void testDeserializeSecurity() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/securityDefinitions.json", Swagger.class);
        List security = swagger.getSecurity();
        List securityRequirements = swagger.getSecurityRequirement();
        Assert.assertNotNull((Object)security);
        Assert.assertEquals((Collection)security, (Collection)securityRequirements);
        Assert.assertEquals((int)security.size(), (int)2);
        SecurityRequirement securityRequirement = (SecurityRequirement)security.get(0);
        Map requirements = securityRequirement.getRequirements();
        List basic_auth = (List)requirements.get("basic_auth");
        Assert.assertNotNull((Object)basic_auth);
        Assert.assertTrue((boolean)basic_auth.isEmpty());
        List api_key = (List)requirements.get("api_key");
        Assert.assertNotNull((Object)api_key);
        Assert.assertTrue((boolean)api_key.isEmpty());
        securityRequirement = (SecurityRequirement)security.get(1);
        requirements = securityRequirement.getRequirements();
        List oauth2 = (List)requirements.get("oauth2");
        Assert.assertNotNull((Object)oauth2);
        Assert.assertFalse((boolean)oauth2.isEmpty());
        Assert.assertEquals((String)((String)oauth2.get(0)), (String)"hello");
        Assert.assertEquals((String)((String)oauth2.get(1)), (String)"world");
    }

    @Test(description="should deserialize a string property with constraints")
    public void testDeserializeConstrainedStringProperty() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/propertiesWithConstraints.json", Swagger.class);
        StringProperty property = (StringProperty)((Model)swagger.getDefinitions().get("Health")).getProperties().get("string_with_constraints");
        Assert.assertEquals((Object)property.getMinLength(), (Object)10);
        Assert.assertEquals((Object)property.getMaxLength(), (Object)100);
        Assert.assertEquals((String)property.getPattern(), (String)"apattern");
    }

    @Test(description="should deserialize a base64 encoded string property with constraints")
    public void testDeserializeConstrainedBase64StringProperty() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/propertiesWithConstraints.json", Swagger.class);
        ByteArrayProperty property = (ByteArrayProperty)((Model)swagger.getDefinitions().get("Health")).getProperties().get("string_base64_encoded");
        Assert.assertEquals((Object)property.getMinLength(), (Object)5);
        Assert.assertEquals((Object)property.getMaxLength(), (Object)50);
        Assert.assertEquals((String)property.getPattern(), (String)"^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
        Assert.assertNull((Object)property.getEnum());
    }

    @Test(description="should deserialize an array property with constraints")
    public void testDeserializeConstrainedArrayProperties() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/propertiesWithConstraints.json", Swagger.class);
        Map properties = ((Model)swagger.getDefinitions().get("Health")).getProperties();
        ArrayProperty withMin = (ArrayProperty)properties.get("array_with_min");
        Assert.assertEquals((Object)withMin.getMinItems(), (Object)5);
        Assert.assertNull((Object)withMin.getMaxItems());
        Assert.assertNull((Object)withMin.getUniqueItems());
        ArrayProperty withMax = (ArrayProperty)properties.get("array_with_max");
        Assert.assertNull((Object)withMax.getMinItems());
        Assert.assertEquals((Object)withMax.getMaxItems(), (Object)10);
        Assert.assertNull((Object)withMax.getUniqueItems());
        ArrayProperty withUnique = (ArrayProperty)properties.get("array_with_unique");
        Assert.assertNull((Object)withUnique.getMinItems());
        Assert.assertNull((Object)withUnique.getMaxItems());
        Assert.assertEquals((Object)withUnique.getUniqueItems(), (Object)Boolean.TRUE);
        ArrayProperty withAll = (ArrayProperty)properties.get("array_with_all");
        Assert.assertEquals((Object)withAll.getMinItems(), (Object)1);
        Assert.assertEquals((Object)withAll.getMaxItems(), (Object)10);
        Assert.assertEquals((Object)withAll.getUniqueItems(), (Object)Boolean.TRUE);
    }

    @Test(description="should deserialize a property with vendor extensions of different types")
    public void testDeserializePropertyWithVendorExtensions() throws Exception {
        Swagger swagger = TestUtils.deserializeJsonFileFromClasspath("specFiles/propertyWithVendorExtensions.json", Swagger.class);
        Map vendorExtensions = ((Property)((Model)swagger.getDefinitions().get("Health")).getProperties().get("status")).getVendorExtensions();
        Assert.assertNotNull((Object)vendorExtensions);
        Assert.assertEquals((int)6, (int)vendorExtensions.size());
        String xStringValue = (String)vendorExtensions.get("x-string-value");
        Assert.assertNotNull((Object)xStringValue);
        Assert.assertEquals((String)xStringValue, (String)"Hello World");
        Assert.assertTrue((boolean)vendorExtensions.containsKey("x-null-value"));
        Assert.assertNull(vendorExtensions.get("x-null-value"));
        Map xMapValue = (Map)vendorExtensions.get("x-map-value");
        Assert.assertNotNull((Object)xMapValue);
        Assert.assertEquals((String)((String)xMapValue.get("hello")), (String)"world");
        Assert.assertEquals((String)((String)xMapValue.get("foo")), (String)"bar");
        List xListValue = (List)vendorExtensions.get("x-list-value");
        Assert.assertNotNull((Object)xListValue);
        Assert.assertEquals((String)((String)xListValue.get(0)), (String)"Hello");
        Assert.assertEquals((String)((String)xListValue.get(1)), (String)"World");
        Integer xNumberValue = (Integer)vendorExtensions.get("x-number-value");
        Assert.assertNotNull((Object)xNumberValue);
        Assert.assertEquals((int)xNumberValue, (int)123);
        Boolean xBooleanValue = (Boolean)vendorExtensions.get("x-boolean-value");
        Assert.assertNotNull((Object)xBooleanValue);
        Assert.assertTrue((boolean)xBooleanValue);
        Assert.assertFalse((boolean)vendorExtensions.containsKey("not-an-extension"));
        vendorExtensions = ((Property)((Model)swagger.getDefinitions().get("Health")).getProperties().get("array")).getVendorExtensions();
        xStringValue = (String)vendorExtensions.get("x-string-value");
        Assert.assertNotNull((Object)xStringValue);
        Assert.assertEquals((String)xStringValue, (String)"string_value");
    }

    @Test
    public void shouldDeserializeArrayPropertyMinItems() throws Exception {
        String path = "json-schema-validation/array.json";
        ArrayProperty property = (ArrayProperty)TestUtils.deserializeJsonFileFromClasspath(path, Property.class);
        Assert.assertNotNull((Object)property.getMinItems());
        Assert.assertEquals((int)property.getMinItems(), (int)1);
    }

    @Test
    public void shouldDeserializeArrayPropertyMaxItems() throws Exception {
        String path = "json-schema-validation/array.json";
        ArrayProperty property = (ArrayProperty)TestUtils.deserializeJsonFileFromClasspath(path, Property.class);
        Assert.assertNotNull((Object)property.getMaxItems());
        Assert.assertEquals((int)property.getMaxItems(), (int)10);
    }

    @Test
    public void shouldDeserializeArrayPropertyUniqueItems() throws Exception {
        String path = "json-schema-validation/array.json";
        ArrayProperty property = (ArrayProperty)TestUtils.deserializeJsonFileFromClasspath(path, Property.class);
        Assert.assertNotNull((Object)property.getUniqueItems());
        Assert.assertTrue((boolean)property.getUniqueItems());
    }

    @Test
    public void givenMapProperty_shouldDeserializeMinProperties() {
        String path = "json-schema-validation/map.json";
        MapProperty property = (MapProperty)TestUtils.deserializeJsonFileFromClasspath(path, Property.class);
        Assert.assertNotNull((Object)property.getMinProperties());
        Assert.assertEquals((int)property.getMinProperties(), (int)1);
    }

    @Test
    public void givenMapProperty_shouldDeserializeMaxProperties() {
        String path = "json-schema-validation/map.json";
        MapProperty property = (MapProperty)TestUtils.deserializeJsonFileFromClasspath(path, Property.class);
        Assert.assertNotNull((Object)property.getMaxProperties());
        Assert.assertEquals((int)property.getMaxProperties(), (int)10);
    }
}

