/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import io.swagger.util.BaseReaderUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BaseReaderUtilsTest {
    @DataProvider
    private Object[][] expectedData() {
        ArrayNode testJsonArray = JsonNodeFactory.instance.arrayNode().add("11").add("22");
        BooleanNode testJsonBoolean = JsonNodeFactory.instance.booleanNode(true);
        return new Object[][]{{"methodOne", Collections.emptyMap()}, {"methodTwo", Collections.emptyMap()}, {"methodThree", ImmutableMap.of((Object)"x-test1", (Object)"value1", (Object)"x-test2", (Object)"value2", (Object)"x-test", (Object)ImmutableMap.of((Object)"test1", (Object)"value1", (Object)"test2", (Object)"value2"))}, {"methodFour", ImmutableMap.of((Object)"x-test", (Object)ImmutableMap.of((Object)"test1", (Object)"value1", (Object)"test2", (Object)"value2"), (Object)"x-test1", (Object)"value1", (Object)"x-test2", (Object)"value2")}, {"methodFive", ImmutableMap.of((Object)"x-test1", (Object)ImmutableMap.of((Object)"test1", (Object)"value1", (Object)"test2", (Object)"value2"), (Object)"x-test2", (Object)"value2")}, {"methodSix", ImmutableMap.of((Object)"x-test1", (Object)"value1", (Object)"x-test2", (Object)"value2")}, {"methodSeven", ImmutableMap.of((Object)"x-test1", (Object)testJsonArray)}, {"methodEight", ImmutableMap.of((Object)"x-test1", (Object)testJsonBoolean)}};
    }

    @Test(dataProvider="expectedData")
    public void extensionsTest(String methodName, Map<String, Object> expected) throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod(methodName, new Class[0]);
        Extension[] extensions = method.getAnnotation(ApiOperation.class).extensions();
        Map map = BaseReaderUtils.parseExtensions((Extension[])extensions);
        Assert.assertEquals((Map)map, expected);
    }

    @ApiOperation(value="method")
    private void methodOne() {
    }

    @ApiOperation(value="method", extensions={@Extension(name="test", properties={@ExtensionProperty(name="test1", value="")})})
    private void methodTwo() {
    }

    @ApiOperation(value="method", extensions={@Extension(properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")}), @Extension(name="test", properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")})})
    private void methodThree() {
    }

    @ApiOperation(value="method", extensions={@Extension(name="test", properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")}), @Extension(properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")})})
    private void methodFour() {
    }

    @ApiOperation(value="method", extensions={@Extension(properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")}), @Extension(name="test1", properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")})})
    private void methodFive() {
    }

    @ApiOperation(value="method", extensions={@Extension(name="test1", properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")}), @Extension(properties={@ExtensionProperty(name="test1", value="value1"), @ExtensionProperty(name="test2", value="value2")})})
    private void methodSix() {
    }

    @ApiOperation(value="method", extensions={@Extension(properties={@ExtensionProperty(name="test1", value="[\"11\", \"22\"]", parseValue=true)})})
    private void methodSeven() {
    }

    @ApiOperation(value="method", extensions={@Extension(properties={@ExtensionProperty(name="test1", value="true", parseValue=true)})})
    private void methodEight() {
    }
}

