/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import io.swagger.converter.ModelConverters;
import io.swagger.models.BeanValidationsModel;
import io.swagger.models.Model;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.StringProperty;
import java.math.BigDecimal;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BeanValidatorTest {
    @Test(description="read bean validations")
    public void readBeanValidatorTest() {
        Map schemas = ModelConverters.getInstance().readAll(BeanValidationsModel.class);
        Model model = (Model)schemas.get("BeanValidationsModel");
        Map properties = model.getProperties();
        IntegerProperty age = (IntegerProperty)properties.get("age");
        Assert.assertEquals((Object)age.getMinimum(), (Object)new BigDecimal(13.0));
        Assert.assertEquals((Object)age.getMaximum(), (Object)new BigDecimal(99.0));
        StringProperty password = (StringProperty)properties.get("password");
        Assert.assertEquals((int)password.getMinLength(), (int)6);
        Assert.assertEquals((int)password.getMaxLength(), (int)20);
        StringProperty email = (StringProperty)properties.get("email");
        Assert.assertEquals((String)email.getPattern(), (String)"(.+?)@(.+?)");
        DoubleProperty minBalance = (DoubleProperty)properties.get("minBalance");
        Assert.assertTrue((boolean)minBalance.getExclusiveMinimum());
        DoubleProperty maxBalance = (DoubleProperty)properties.get("maxBalance");
        Assert.assertTrue((boolean)maxBalance.getExclusiveMaximum());
        ArrayProperty items = (ArrayProperty)properties.get("items");
        Assert.assertEquals((int)items.getMinItems(), (int)2);
        Assert.assertEquals((int)items.getMaxItems(), (int)10);
    }
}

