/*
 * Decompiled with CFR 0.152.
 */
package io.swagger;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.matchers.SerializationMatchers;
import io.swagger.models.ModelImpl;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BooleanModelTest {
    @Test
    public void testBooleanProperty() throws JsonProcessingException {
        String yaml = "swagger: '2.0'\ninfo:\n  title: Some API\n  description: >-\n    This is the Some Api\n  version: 2.0.0\nbasePath: /somepath\nschemes:\n  - https\nconsumes:\n  - application/json\nproduces:\n  - application/json\npaths:\n  /somepath:\n    get:\n      description: >\n        my description\n      operationId: MyGet\n      responses:\n        '200':\n          $ref: '#/responses/Response'\nresponses:\n  Response:\n    description: Response\n    schema:\n      type: object\n      required:\n        - Report\n      properties:\n        Report:\n          type: string\n      additionalProperties: false";
        Swagger swagger = (Swagger)Yaml.mapper().readValue(yaml, Swagger.class);
        Assert.assertEquals((boolean)((ModelImpl)((Response)swagger.getResponses().get("Response")).getResponseSchema()).getAdditionalProperties().getBooleanValue(), (boolean)false);
        SerializationMatchers.assertEqualsToYaml(swagger, "swagger: \"2.0\"\ninfo:\n  description: \"This is the Some Api\"\n  version: \"2.0.0\"\n  title: \"Some API\"\nbasePath: \"/somepath\"\nschemes:\n- \"https\"\nconsumes:\n- \"application/json\"\nproduces:\n- \"application/json\"\npaths:\n  /somepath:\n    get:\n      description: \"my description\\n\"\n      operationId: \"MyGet\"\n      parameters: []\n      responses:\n        \"200\":\n          $ref: \"#/responses/Response\"\nresponses:\n  Response:\n    description: \"Response\"\n    schema:\n      type: \"object\"\n      required:\n      - \"Report\"\n      properties:\n        Report:\n          type: \"string\"\n      additionalProperties: false");
    }
}

